/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.popup;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.view.ContextExcludePanel;
import com.stackhawk.hste.view.popup.PopupMenuItemSiteNodeContainer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;

public class PopupMenuItemExcludeFromContext
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 2766535157899537709L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuItemExcludeFromContext.class);
    protected Context context;

    public PopupMenuItemExcludeFromContext(Context context) {
        super(context.getName(), true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.exclude.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
        Context uiSharedContext = View.getSingleton().getSessionDialog().getUISharedContext(this.context.getId());
        try {
            uiSharedContext.excludeFromContext(sn, !sn.isLeaf());
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute action exclude from context: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> hrefs) {
        Session session = Model.getSingleton().getSession();
        View.getSingleton().getSessionDialog().recreateUISharedContexts(session);
        super.performHistoryReferenceActions(hrefs);
        View.getSingleton().showSessionDialog(session, ContextExcludePanel.getPanelName(this.context.getId()), false);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        return this.context.isIncluded(sn) && !this.context.isExcluded(sn);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

