/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.popup;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.view.popup.PopupMenuItemSiteNodeContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;

public abstract class PopupMenuItemSiteNodeContextMenuFactory
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 9129911066364621427L;
    private List<ExtensionPopupMenuItem> subMenus = new ArrayList<ExtensionPopupMenuItem>();
    private String parentMenu;

    public PopupMenuItemSiteNodeContextMenuFactory(String parentMenu) {
        super("ContextMenuFactory", true);
        this.parentMenu = parentMenu;
    }

    @Override
    public String getParentMenuName() {
        return this.parentMenu;
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public boolean isDummyItem() {
        return true;
    }

    @Override
    public void performAction(SiteNode sn) {
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode sn) {
        Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
        for (ExtensionPopupMenuItem menu : this.subMenus) {
            mainPopupMenuItems.remove(menu);
        }
        this.subMenus.clear();
        Session session = Model.getSingleton().getSession();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            ExtensionPopupMenuItem piicm = this.getContextMenu(context, this.parentMenu);
            piicm.setMenuIndex(this.getMenuIndex());
            mainPopupMenuItems.add(piicm);
            this.subMenus.add(piicm);
        }
        return false;
    }

    public abstract ExtensionPopupMenuItem getContextMenu(Context var1, String var2);

    @Override
    public boolean isSafe() {
        return true;
    }
}

