/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.table;

import com.stackhawk.hste.view.table.HistoryReferencesTableEntry;
import com.stackhawk.hste.view.table.HistoryReferencesTableModel;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

public abstract class AbstractHistoryReferencesTableModel<T extends HistoryReferencesTableEntry>
extends AbstractTableModel
implements HistoryReferencesTableModel<T> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("view.href.table.header.hrefid"), Constant.messages.getString("view.href.table.header.timestamp.request"), Constant.messages.getString("view.href.table.header.timestamp.response"), Constant.messages.getString("view.href.table.header.hreftype"), Constant.messages.getString("view.href.table.header.hreftype.name"), Constant.messages.getString("view.href.table.header.method"), Constant.messages.getString("view.href.table.header.url"), Constant.messages.getString("view.href.table.header.hostname"), Constant.messages.getString("view.href.table.header.pathandquery"), Constant.messages.getString("view.href.table.header.code"), Constant.messages.getString("view.href.table.header.reason"), Constant.messages.getString("view.href.table.header.rtt"), Constant.messages.getString("view.href.table.header.size.message"), Constant.messages.getString("view.href.table.header.size.requestheader"), Constant.messages.getString("view.href.table.header.size.requestbody"), Constant.messages.getString("view.href.table.header.size.responseheader"), Constant.messages.getString("view.href.table.header.size.responsebody"), Constant.messages.getString("view.href.table.header.sessionid"), Constant.messages.getString("view.href.table.header.highestalert"), Constant.messages.getString("view.href.table.header.note"), Constant.messages.getString("view.href.table.header.tags")};
    private final HistoryReferencesTableModel.Column[] columns;
    private final Map<HistoryReferencesTableModel.Column, Integer> cacheColumnToColumnIdx;

    public AbstractHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("Parameter columns must not be null.");
        }
        this.columns = Arrays.copyOf(columns, columns.length);
        this.cacheColumnToColumnIdx = this.buildCacheColumnToColumnIdx(columns);
    }

    private Map<HistoryReferencesTableModel.Column, Integer> buildCacheColumnToColumnIdx(HistoryReferencesTableModel.Column[] columns) {
        TreeMap<HistoryReferencesTableModel.Column, Integer> cache = new TreeMap<HistoryReferencesTableModel.Column, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            cache.put(columns[i], i);
        }
        return cache;
    }

    protected boolean isCustomColumn(int columnIndex) {
        return AbstractHistoryReferencesTableModel.isCustomColumn(this.columns, columnIndex);
    }

    @Override
    public abstract Class<?> getColumnClass(int var1);

    @Override
    public HistoryReferencesTableModel.Column[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    @Override
    public HistoryReferencesTableModel.Column getColumn(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public int getColumnIndex(HistoryReferencesTableModel.Column column) {
        Integer idx = this.cacheColumnToColumnIdx.get((Object)column);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    @Override
    public boolean isColumnEnabled(HistoryReferencesTableModel.Column column) {
        return this.getColumnIndex(column) != -1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[this.columns[columnIndex].ordinal()];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getEntry(rowIndex).getValue(this.getColumn(columnIndex));
    }

    protected static boolean isCustomColumn(HistoryReferencesTableModel.Column[] columns, int columnIndex) {
        return columns[columnIndex] == HistoryReferencesTableModel.Column.CUSTOM;
    }
}

