/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.Constant;

public class AlertRiskTableCellItem
implements Comparable<AlertRiskTableCellItem> {
    private static final Map<Integer, AlertRiskTableCellItem> values;
    public static final AlertRiskTableCellItem NO_RISK_CELL_ITEM;
    public static final AlertRiskTableCellItem UNDEFINED_RISK_CELL_ITEM;
    private final int risk;
    private final String description;

    private AlertRiskTableCellItem(int risk, String description) {
        this.risk = risk;
        this.description = description;
    }

    public int getRisk() {
        return this.risk;
    }

    public int hashCode() {
        return 31 + this.risk;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AlertRiskTableCellItem other = (AlertRiskTableCellItem)object;
        return this.risk == other.risk;
    }

    @Override
    public int compareTo(AlertRiskTableCellItem o) {
        int otherRisk = o.risk;
        if (this.risk < otherRisk) {
            return -1;
        }
        if (this.risk > otherRisk) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.description;
    }

    public static AlertRiskTableCellItem getItemForRisk(int risk) {
        if (risk == -1) {
            return NO_RISK_CELL_ITEM;
        }
        AlertRiskTableCellItem alertCelLItem = values.get(risk);
        if (alertCelLItem == null) {
            return UNDEFINED_RISK_CELL_ITEM;
        }
        return alertCelLItem;
    }

    static {
        HashMap<Integer, AlertRiskTableCellItem> temp = new HashMap<Integer, AlertRiskTableCellItem>();
        AlertRiskTableCellItem alertCellItem = new AlertRiskTableCellItem(0, Constant.messages.getString("view.href.table.cell.alert.risk.label.info"));
        temp.put(alertCellItem.getRisk(), alertCellItem);
        alertCellItem = new AlertRiskTableCellItem(1, Constant.messages.getString("view.href.table.cell.alert.risk.label.low"));
        temp.put(alertCellItem.getRisk(), alertCellItem);
        alertCellItem = new AlertRiskTableCellItem(2, Constant.messages.getString("view.href.table.cell.alert.risk.label.medium"));
        temp.put(alertCellItem.getRisk(), alertCellItem);
        alertCellItem = new AlertRiskTableCellItem(3, Constant.messages.getString("view.href.table.cell.alert.risk.label.high"));
        temp.put(alertCellItem.getRisk(), alertCellItem);
        values = Collections.unmodifiableMap(temp);
        NO_RISK_CELL_ITEM = new AlertRiskTableCellItem(-1, "");
        UNDEFINED_RISK_CELL_ITEM = new AlertRiskTableCellItem(-2, Constant.messages.getString("view.href.table.cell.alert.risk.label.undefined"));
    }
}

