/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.table;

import com.stackhawk.hste.view.table.AbstractHistoryReferencesTableModel;
import com.stackhawk.hste.view.table.DefaultHistoryReferencesTableEntry;
import com.stackhawk.hste.view.table.HistoryReferencesTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import org.parosproxy.paros.model.HistoryReference;

public class DefaultHistoryReferencesTableModel
extends AbstractHistoryReferencesTableModel<DefaultHistoryReferencesTableEntry> {
    private static final long serialVersionUID = -8628528927411108669L;
    private static final HistoryReferencesTableModel.Column[] DEFAULT_COLUMNS = new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.NOTE, HistoryReferencesTableModel.Column.TAGS};
    private ArrayList<DefaultHistoryReferencesTableEntry> hrefList = new ArrayList();
    private SortedMap<Integer, RowIndex> historyIdToRow = new TreeMap<Integer, RowIndex>();
    private SortedSet<RowIndex> rowIndexes = new TreeSet<RowIndex>();

    public static HistoryReferencesTableModel.Column[] getDefaultColumns() {
        return Arrays.copyOf(DEFAULT_COLUMNS, DEFAULT_COLUMNS.length);
    }

    public DefaultHistoryReferencesTableModel() {
        this(DefaultHistoryReferencesTableModel.getDefaultColumns());
    }

    public DefaultHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columns) {
        super(columns);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return DefaultHistoryReferencesTableEntry.getColumnClass(this.getColumn(columnIndex));
    }

    public Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return DefaultHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.hrefList.size();
    }

    @Override
    public Object getPrototypeValue(int columnIndex) {
        return DefaultHistoryReferencesTableEntry.getPrototypeValue(this.getColumn(columnIndex));
    }

    public Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return DefaultHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    public void addEntry(DefaultHistoryReferencesTableEntry historyReference) {
        this.hrefList.add(historyReference);
        RowIndex rowIndex = new RowIndex(this.hrefList.size() - 1);
        this.historyIdToRow.put(historyReference.getHistoryReference().getHistoryId(), rowIndex);
        this.rowIndexes.add(rowIndex);
        this.fireTableRowsInserted(rowIndex.getValue(), rowIndex.getValue());
    }

    @Override
    public void refreshEntryRow(int historyReferenceId) {
        DefaultHistoryReferencesTableEntry entry = this.getEntryWithHistoryId(historyReferenceId);
        if (entry != null) {
            int rowIndex = this.getEntryRowIndex(historyReferenceId);
            this.getEntryWithHistoryId(historyReferenceId).refreshCachedValues();
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public void refreshEntryRows() {
        if (this.hrefList.isEmpty()) {
            return;
        }
        for (DefaultHistoryReferencesTableEntry entry : this.hrefList) {
            entry.refreshCachedValues();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.hrefList.size() - 1));
    }

    @Override
    public void removeEntry(int historyReferenceId) {
        Integer key = historyReferenceId;
        RowIndex rowIndex = (RowIndex)this.historyIdToRow.get(key);
        if (rowIndex != null) {
            this.hrefList.remove(rowIndex.getValue());
            this.historyIdToRow.remove(key);
            this.rowIndexes.remove(rowIndex);
            this.decreaseRowIndexes(rowIndex);
            this.fireTableRowsDeleted(rowIndex.getValue(), rowIndex.getValue());
        }
    }

    private void decreaseRowIndexes(RowIndex fromRowIndex) {
        RowIndex[] indexes;
        for (RowIndex rowIndex : indexes = this.removeRowIndexes(fromRowIndex)) {
            rowIndex.decreaseValue();
        }
        this.rowIndexes.addAll(Arrays.asList(indexes));
    }

    private RowIndex[] removeRowIndexes(RowIndex fromRowIndex) {
        SortedSet<RowIndex> indexes = this.rowIndexes.tailSet(fromRowIndex);
        RowIndex[] removedIndexes = new RowIndex[indexes.size()];
        removedIndexes = indexes.toArray(removedIndexes);
        indexes.clear();
        return removedIndexes;
    }

    @Override
    public void clear() {
        this.hrefList.clear();
        this.hrefList.trimToSize();
        this.historyIdToRow = new TreeMap<Integer, RowIndex>();
        this.rowIndexes = new TreeSet<RowIndex>();
        this.fireTableDataChanged();
    }

    @Override
    public int getEntryRowIndex(int historyReferenceId) {
        RowIndex rowIndex = (RowIndex)this.historyIdToRow.get(historyReferenceId);
        if (rowIndex != null) {
            return rowIndex.getValue();
        }
        return -1;
    }

    @Override
    public DefaultHistoryReferencesTableEntry getEntryWithHistoryId(int historyId) {
        int row = this.getEntryRowIndex(historyId);
        if (row != -1) {
            return this.hrefList.get(row);
        }
        return null;
    }

    @Override
    public DefaultHistoryReferencesTableEntry getEntry(int rowIndex) {
        return this.hrefList.get(rowIndex);
    }

    public void addHistoryReference(HistoryReference historyReference) {
        this.addEntry(new DefaultHistoryReferencesTableEntry(historyReference, this.getColumns()));
    }

    public void removeHistoryReference(HistoryReference historyReference) {
        if (historyReference == null) {
            return;
        }
        this.removeEntry(historyReference.getHistoryId());
    }

    public HistoryReference getHistoryReference(int historyReferenceId) {
        DefaultHistoryReferencesTableEntry entry = this.getEntryWithHistoryId(historyReferenceId);
        if (entry != null) {
            return entry.getHistoryReference();
        }
        return null;
    }

    private static class RowIndex
    implements Comparable<RowIndex> {
        private int value;

        public RowIndex(int value) {
            this.value = value;
        }

        public void decreaseValue() {
            --this.value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int compareTo(RowIndex other) {
            if (other == null) {
                return 1;
            }
            if (this.value > other.value) {
                return 1;
            }
            if (this.value < other.value) {
                return -1;
            }
            return 0;
        }
    }
}

