/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.widgets;

import com.stackhawk.hste.extension.users.ExtensionUserManagement;
import com.stackhawk.hste.extension.users.UsersTableModel;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.view.renderer.UserListCellRenderer;
import com.stackhawk.hste.view.widgets.UsersListModel;
import javax.swing.JComboBox;
import org.parosproxy.paros.control.Control;

public class ContextPanelUsersSelectComboBox
extends JComboBox<User> {
    private static final long serialVersionUID = 7254245073685076020L;
    private static ExtensionUserManagement usersExtension;
    private final UsersListModel usersListModel;

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public ContextPanelUsersSelectComboBox(int contextId) {
        ContextPanelUsersSelectComboBox.loadUsersManagementExtension();
        UsersTableModel usersTableModel = usersExtension.getUIConfiguredUsersModel(contextId);
        this.usersListModel = new UsersListModel(usersTableModel);
        this.setModel(this.usersListModel);
        this.setRenderer(new UserListCellRenderer());
    }

    public void unload() {
        this.usersListModel.unload();
    }

    public User getSelectedUser() {
        return (User)this.getSelectedItem();
    }

    public void setCustomUsers(User[] customUsers) {
        ((UsersListModel)this.getModel()).setCustomUsers(customUsers);
    }

    public void setSelectedInternalItem(User user) {
        ((UsersListModel)this.getModel()).setSelectedInternalItem(user);
    }
}

