/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.widgets;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class PopupButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private ActionListener actionListener;

    public PopupButton() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PopupButton.this.getPopupMenu().show(PopupButton.this, 0, PopupButton.this.getHeight());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PopupButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PopupButton.this.repaint();
            }
        });
    }

    private ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = e -> {
                Object o = e.getSource();
                if (o instanceof JMenuItem) {
                    this.menuItemSelected(((JMenuItem)o).getText());
                }
            };
        }
        return this.actionListener;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        String selected = this.getSelectedMenuItem();
        for (String option : this.getMenuItemNames()) {
            JMenuItem item = new JMenuItem(option);
            item.addActionListener(this.getActionListener());
            if (option.equals(selected)) {
                item.setSelected(true);
                item.setEnabled(false);
                item.setIcon(new ImageIcon(this.getClass().getResource("/resource/icon/105_gray.png")));
            }
            popupMenu.add(item);
        }
        return popupMenu;
    }

    public abstract List<String> getMenuItemNames();

    public abstract void menuItemSelected(String var1);

    public abstract String getSelectedMenuItem();
}

