/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.view.widgets;

import com.stackhawk.hste.extension.users.ExtensionUserManagement;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.view.renderer.UserListCellRenderer;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import org.parosproxy.paros.control.Control;

public class UsersMultiSelectList
extends JList<User> {
    private static final long serialVersionUID = 7473652413044348214L;
    private static ExtensionUserManagement usersExtension;

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public UsersMultiSelectList(int contextId, int selectionModel) {
        UsersMultiSelectList.loadUsersManagementExtension();
        this.reloadUsers(contextId);
        this.setSelectionMode(selectionModel);
        this.setCellRenderer(new UserListCellRenderer());
    }

    public void reloadUsers(int contextId) {
        List<User> users = usersExtension.getContextUserAuthManager(contextId).getUsers();
        User[] usersArray = users.toArray(new User[users.size()]);
        DefaultComboBoxModel<User> usersModel = new DefaultComboBoxModel<User>(usersArray);
        this.setModel(usersModel);
    }
}

