/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import com.stackhawk.hste.control.ControlOverrides;
import com.stackhawk.hste.utils.HsteXmlConfiguration;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractParam
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger(AbstractParam.class);
    private FileConfiguration config = null;

    public void load(FileConfiguration config) {
        this.config = config;
        try {
            this.parse();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void load(String filePath) {
        this.load(filePath, null);
    }

    public void load(String filePath, ControlOverrides overrides) {
        try {
            this.config = new HsteXmlConfiguration(filePath);
            if (overrides != null) {
                for (Map.Entry<String, String> entry : overrides.getOrderedConfigs().entrySet()) {
                    LOGGER.info("Setting config {} = {} was {}", (Object)entry.getKey(), (Object)entry.getValue(), (Object)this.config.getString(entry.getKey()));
                    this.config.setProperty(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.parse();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public AbstractParam clone() {
        try {
            AbstractParam clone = (AbstractParam)super.clone();
            clone.load((FileConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)this.config));
            return clone;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract void parse();

    public void reset() {
    }

    protected String getString(String key, String defaultValue) {
        try {
            return this.getConfig().getString(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected static void logConversionException(String key, ConversionException e) {
        LOGGER.warn("Failed to read '{}'", (Object)key, (Object)e);
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getConfig().getBoolean(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected int getInt(String key, int defaultValue) {
        try {
            return this.getConfig().getInt(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected Integer getInteger(String key, Integer defaultValue) {
        try {
            return this.getConfig().getInteger(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected <T extends Enum<T>> T getEnum(String key, T defaultValue) {
        String value = this.getString(key, defaultValue.name());
        Class<?> enumType = defaultValue.getClass();
        try {
            return (T)Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to create enum for '{}' using '{}'. Valid values: {}", (Object)key, (Object)value, AbstractParam.getValues(enumType));
            return defaultValue;
        }
    }

    private static <T extends Enum<T>> List<String> getValues(Class<T> enumType) {
        try {
            Method valuesMethod = enumType.getDeclaredMethod("values", new Class[0]);
            Enum[] values = (Enum[])valuesMethod.invoke(enumType, new Object[0]);
            return Stream.of(values).map(Enum::name).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Error getting enum values:", (Throwable)e);
            return List.of();
        }
    }
}

