/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class ThreadPool {
    private Thread[] pool = null;
    private final String threadsBaseName;
    private static final Logger LOGGER = LogManager.getLogger(AbstractParam.class);

    public ThreadPool(int maxThreadCount) {
        this(maxThreadCount, null);
    }

    public ThreadPool(int maxThreadCount, String threadsBaseName) {
        this.pool = new Thread[maxThreadCount];
        this.threadsBaseName = threadsBaseName;
    }

    public synchronized Thread getFreeThreadAndRun(Runnable runnable) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] != null && this.pool[i].isAlive()) continue;
            this.pool[i] = new Thread(runnable);
            if (this.threadsBaseName != null) {
                this.pool[i].setName(this.threadsBaseName + i);
            }
            this.pool[i].setDaemon(true);
            this.pool[i].start();
            return this.pool[i];
        }
        return null;
    }

    public void waitAllThreadComplete(int waitInMillis) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null || !this.pool[i].isAlive()) continue;
            try {
                LOGGER.debug("Trying to join Thread " + this.pool[i].getName());
                this.pool[i].join(waitInMillis);
                if (!this.pool[i].isAlive()) continue;
                LOGGER.debug("Thread " + this.pool[i].getName() + " is still alive. Killing now");
                this.pool[i].interrupt();
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.debug("Thread threw interrupt exeeption " + this.pool[i].getName());
            }
        }
    }

    public boolean isAllThreadComplete() {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null || !this.pool[i].isAlive()) continue;
            return false;
        }
        return true;
    }
}

