/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import com.stackhawk.hste.control.AddOnLoader;
import com.stackhawk.hste.control.ControlOverrides;
import com.stackhawk.hste.control.ExtensionFactory;
import com.stackhawk.hste.utils.HsteHtmlLabel;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.AbstractControl;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WaitMessageDialog;

public class Control
extends AbstractControl
implements SessionListener {
    private static final Logger LOGGER = LogManager.getLogger(Control.class);
    private static Control control = null;
    private MenuFileControl menuFileControl = null;
    private MenuToolsControl menuToolsControl = null;
    private SessionListener lastCallback = null;
    private Mode mode = null;
    private int exitStatus = 0;
    protected Supplier<Set<Extension>> extensionSupplier = null;

    private Control(Model model, View view) {
        super(model, view);
    }

    private Control() {
        super(null, null);
    }

    private boolean init(ControlOverrides overrides) {
        if (this.extensionSupplier == null) {
            AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader(this.model.getOptionsParam().getCheckForUpdatesParam().getAddonDirectories());
            if (overrides != null) {
                addOnLoader.getAddOnCollection().setMandatoryAddOns(overrides.getMandatoryAddOns());
            }
        }
        this.loadExtension();
        if (this.hasView()) {
            this.getExtensionLoader().hookSiteMapListener(this.view.getSiteTreePanel());
        }
        this.model.postInit();
        return false;
    }

    private boolean hasView() {
        return this.view != null;
    }

    @Deprecated
    public Proxy getProxy() {
        return this.getProxy(null);
    }

    @Deprecated
    public Proxy getProxy(ControlOverrides overrides) {
        return new Proxy(this.model, overrides);
    }

    @Override
    protected void addExtension() {
        ExtensionFactory.loadAllExtension(this.getExtensionLoader(), this.model.getOptionsParam(), this.extensionSupplier);
    }

    public MenuFileControl getMenuFileControl() {
        if (this.menuFileControl == null) {
            this.menuFileControl = new MenuFileControl(this.model, this.view, this);
        }
        return this.menuFileControl;
    }

    public MenuToolsControl getMenuToolsControl() {
        if (this.menuToolsControl == null) {
            this.menuToolsControl = new MenuToolsControl(this.model, this.view, this);
        }
        return this.menuToolsControl;
    }

    @Override
    public void shutdown(boolean compact) {
        try {
            if (this.hasView()) {
                this.view.getRequestPanel().saveConfig(this.model.getOptionsParam().getConfig());
                this.view.getResponsePanel().saveConfig(this.model.getOptionsParam().getConfig());
            }
            super.shutdown(compact);
        }
        finally {
            this.saveConfigurations();
        }
    }

    private void saveConfigurations() {
        try {
            this.model.getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Error saving configurations:", (Throwable)e);
        }
    }

    public void exit(boolean noPrompt, final File openOnExit) {
        boolean sessionUnsaved;
        boolean isNewState = this.model.getSession().isNewState();
        int rootCount = 0;
        if (!Constant.isLowMemoryOptionSet()) {
            rootCount = this.model.getSession().getSiteTree().getChildCount(this.model.getSession().getSiteTree().getRoot());
        }
        boolean askOnExit = this.hasView() && Model.getSingleton().getOptionsParam().getViewParam().getAskOnExitOption() > 0;
        boolean bl = sessionUnsaved = isNewState && rootCount > 0;
        if (!noPrompt) {
            List<String> list = this.getExtensionLoader().getUnsavedResources();
            if (sessionUnsaved && askOnExit) {
                list.add(0, Constant.messages.getString("menu.file.exit.message.sessionResNotSaved"));
            }
            String message = null;
            String activeActions = Control.wrapEntriesInLiTags(this.getExtensionLoader().getActiveActions());
            if (list.size() > 0) {
                String unsavedResources = Control.wrapEntriesInLiTags(list);
                message = activeActions.isEmpty() ? Constant.messages.getString("menu.file.exit.message.resourcesNotSaved", unsavedResources) : Constant.messages.getString("menu.file.exit.message.resourcesNotSavedAndActiveActions", unsavedResources, activeActions);
            } else if (!activeActions.isEmpty()) {
                message = Constant.messages.getString("menu.file.exit.message.activeActions", activeActions);
            }
            if (message != null && this.view.showConfirmDialog(new HsteHtmlLabel(message)) != 0) {
                return;
            }
        }
        if (sessionUnsaved) {
            control.discardSession();
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    control.shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
                    LOGGER.info("{} terminated.", (Object)Constant.PROGRAM_TITLE);
                    if (openOnExit != null && Desktop.isDesktopSupported()) {
                        try {
                            LOGGER.info("Opening file {}", (Object)openOnExit.getAbsolutePath());
                            Desktop.getDesktop().open(openOnExit);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to open file {}", (Object)openOnExit.getAbsolutePath(), (Object)e);
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred while shutting down:", e);
                }
                finally {
                    System.exit(Control.this.exitStatus);
                }
            }
        }, "HSTE-Shutdown");
        if (this.hasView()) {
            WaitMessageDialog dialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.shuttingDown"));
            t.start();
            dialog.setVisible(true);
        } else {
            t.start();
        }
    }

    public void setExitStatus(int exitStatus, String logMessage) {
        if (exitStatus == 0) {
            LOGGER.error("Not setting the exit status to zero - culprit: {}", (Object)logMessage);
        } else {
            this.exitStatus = exitStatus;
            LOGGER.info(logMessage);
        }
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    private static String wrapEntriesInLiTags(List<String> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder(entries.size() * 15);
        for (String entry : entries) {
            strBuilder.append("<li>");
            strBuilder.append(entry);
            strBuilder.append("</li>");
        }
        return strBuilder.toString();
    }

    public void exitAndDeleteSession(String sessionName) {
        this.shutdown(false);
        Model.getSingleton().getDb().deleteSession(sessionName);
        LOGGER.info("{} terminated.", (Object)Constant.PROGRAM_TITLE);
        System.exit(this.getExitStatus());
    }

    public static Control getSingleton() {
        return control;
    }

    public static boolean initSingletonWithView(ControlOverrides overrides) {
        control = new Control(Model.getSingleton(), View.getSingleton());
        return control.init(overrides);
    }

    public static boolean initSingletonWithoutView(ControlOverrides overrides) {
        control = new Control(Model.getSingleton(), null);
        return control.init(overrides);
    }

    public static boolean initSingletonWithoutView(ControlOverrides overrides, Supplier<Set<Extension>> extensionSupplier) {
        control = new Control(Model.getSingleton(), null);
        Control.control.extensionSupplier = extensionSupplier;
        return control.init(overrides);
    }

    @Deprecated
    public static void initSingletonWithoutViewAndProxy(ControlOverrides overrides) {
        Control.initSingletonWithoutView(overrides);
    }

    public static void initSingletonForTesting() {
        control = new Control();
    }

    public static void initSingletonForTesting(Model model) {
        control = new Control(model, null);
    }

    public static void initSingletonForTesting(Model model, ExtensionLoader extensionLoader) {
        Control.initSingletonForTesting(model);
        Control.control.loader = extensionLoader;
    }

    public void runCommandLine() throws Exception {
        LOGGER.debug("runCommand");
        this.getExtensionLoader().runCommandLine();
    }

    public void runCommandLineNewSession(String fileName) throws Exception {
        LOGGER.debug("runCommandLineNewSession {}", (Object)fileName);
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.createAndOpenUntitledDb();
        final Session session = this.createNewSession();
        this.model.saveSession(fileName);
        if (this.hasView()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Control.this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
                    Control.this.view.getOutputPanel().clear();
                }
            });
        }
        LOGGER.info("New session file created: {}", (Object)Paths.get(fileName, new String[0]).toRealPath(new LinkOption[0]));
        control.getExtensionLoader().databaseOpen(this.model.getDb());
        control.getExtensionLoader().sessionChangedAllPlugin(session);
    }

    private Session createNewSession() {
        return this.model.newSession();
    }

    public void runCommandLineOpenSession(String fileName) throws Exception {
        LOGGER.debug("runCommandLineOpenSession {}", (Object)fileName);
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        Session session = Model.getSingleton().getSession();
        Model.getSingleton().openSession(fileName);
        LOGGER.info("Session file opened");
        control.getExtensionLoader().databaseOpen(this.model.getDb());
        control.getExtensionLoader().sessionChangedAllPlugin(session);
    }

    @Deprecated
    public void setExcludeFromProxyUrls(List<String> urls) {
    }

    public void openSession(File file, SessionListener callback) {
        LOGGER.info("Open Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = callback;
        this.model.openSession(file, (SessionListener)this);
    }

    public void openSession(String fileName, SessionListener callback) {
        LOGGER.info("Open Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = callback;
        this.model.openSession(fileName, (SessionListener)this);
    }

    public Session newSession() throws Exception {
        LOGGER.info("New Session");
        this.closeSessionAndCreateAndOpenUntitledDb();
        final Session session = this.createNewSession();
        this.getExtensionLoader().databaseOpen(this.model.getDb());
        this.getExtensionLoader().sessionChangedAllPlugin(session);
        if (this.hasView()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Control.this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
                    Control.this.view.getSiteTreePanel().reloadContextTree();
                }
            });
            this.view.getOutputPanel().clear();
        }
        try {
            this.model.getDb().getTableSession().insert(session.getSessionId(), session.getSessionName());
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return session;
    }

    private void closeSessionAndCreateAndOpenUntitledDb() throws Exception {
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.closeSession();
        LOGGER.info("Create and Open Untitled Db");
        this.model.createAndOpenUntitledDb();
    }

    public void newSession(String fileName, SessionListener callback) {
        block2: {
            LOGGER.info("New Session");
            try {
                this.closeSessionAndCreateAndOpenUntitledDb();
                this.lastCallback = callback;
                this.createNewSession();
                this.model.saveSession(fileName, this);
            }
            catch (Exception e) {
                if (this.lastCallback == null) break block2;
                this.lastCallback.sessionSaved(e);
                this.lastCallback = null;
            }
        }
    }

    public void saveSession(String fileName) {
        this.saveSession(fileName, null);
    }

    public void saveSession(String fileName, SessionListener callback) {
        LOGGER.info("Save Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.lastCallback = callback;
        this.model.saveSession(fileName, this);
    }

    public void persistSessionProperties() throws Exception {
        this.model.persistSessionProperties();
        this.getExtensionLoader().sessionPropertiesChangedAllPlugin(this.model.getSession());
    }

    public void snapshotSession(String fileName, SessionListener callback) {
        LOGGER.info("Snapshot Session");
        this.lastCallback = callback;
        this.model.snapshotSession(fileName, this);
    }

    public void discardSession() {
        LOGGER.info("Discard Session");
        this.getExtensionLoader().sessionAboutToChangeAllPlugin(null);
        this.model.discardSession();
        this.getExtensionLoader().sessionChangedAllPlugin(null);
    }

    @Override
    public void sessionOpened(File file, Exception e) {
        this.notifyExtensionsSessionChanged(e);
        if (this.lastCallback != null) {
            this.lastCallback.sessionOpened(file, e);
            this.lastCallback = null;
        }
    }

    private void notifyExtensionsSessionChanged(Exception exception) {
        if (exception == null) {
            this.getExtensionLoader().databaseOpen(this.model.getDb());
            this.getExtensionLoader().sessionChangedAllPlugin(this.model.getSession());
        }
    }

    @Override
    public void sessionSaved(Exception e) {
        this.notifyExtensionsSessionChanged(e);
        if (this.lastCallback != null) {
            this.lastCallback.sessionSaved(e);
            this.lastCallback = null;
        }
    }

    @Override
    public void sessionSnapshot(Exception e) {
        if (this.lastCallback != null) {
            this.lastCallback.sessionSnapshot(e);
            this.lastCallback = null;
        }
    }

    public void sessionScopeChanged() {
        this.getExtensionLoader().sessionScopeChangedAllPlugin(this.model.getSession());
    }

    public Mode getMode() {
        if (this.mode == null) {
            this.mode = Mode.valueOf(this.model.getOptionsParam().getViewParam().getMode());
        }
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.getExtensionLoader().sessionModeChangedAllPlugin(mode);
            this.model.getOptionsParam().getViewParam().setMode(mode.name());
        }
    }

    public static enum Mode {
        safe,
        protect,
        standard,
        attack;

    }
}

