/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import com.stackhawk.hste.extension.alert.ExtensionAlert;
import com.stackhawk.hste.extension.ascan.ScanPolicy;
import com.stackhawk.hste.extension.ascan.filters.FilterResult;
import com.stackhawk.hste.extension.ascan.filters.ScanFilter;
import com.stackhawk.hste.extension.custompages.CustomPage;
import com.stackhawk.hste.extension.ruleconfig.RuleConfig;
import com.stackhawk.hste.extension.ruleconfig.RuleConfigParam;
import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.model.SessionStructure;
import com.stackhawk.hste.model.StructuralNode;
import com.stackhawk.hste.model.TechSet;
import com.stackhawk.hste.network.HttpRedirectionValidator;
import com.stackhawk.hste.network.HttpRequestConfig;
import com.stackhawk.hste.users.User;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractHostPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.core.scanner.PluginStats;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class HostProcess
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(HostProcess.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private List<StructuralNode> startNodes;
    private boolean isStop = false;
    private PluginFactory pluginFactory;
    private ScannerParam scannerParam = null;
    private HttpSender httpSender = null;
    private ThreadPool threadPool = null;
    private Scanner parentScanner = null;
    private String hostAndPort = "";
    private Analyser analyser = null;
    private Kb kb = null;
    private User user = null;
    private TechSet techSet;
    private RuleConfigParam ruleConfigParam;
    private String stopReason = null;
    private Context context;
    private int scanTimeoutInMillis;
    private final Map<Integer, PluginStats> mapPluginStats = new HashMap<Integer, PluginStats>();
    private long hostProcessStartTime = 0L;
    private int nodeInScopeCount = 0;
    private int percentage = 0;
    private int requestCount;
    private int alertCount;
    private int newAlertCount = 0;
    private int messageIdToHostScan;
    private List<Integer> messagesIdsToAppScan;
    private HttpRequestConfig redirectRequestConfig;
    private HttpRedirectionValidator redirectionValidator;

    @Deprecated
    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        this(hostAndPort, parentScanner, scannerParam, connectionParam, scanPolicy, null);
    }

    @Deprecated
    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this(hostAndPort, parentScanner, scannerParam, scanPolicy, ruleConfigParam);
    }

    public HostProcess(String hostAndPort, Scanner parentScanner, ScannerParam scannerParam, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this.hostAndPort = hostAndPort;
        this.parentScanner = parentScanner;
        this.scannerParam = scannerParam;
        this.pluginFactory = scanPolicy.getPluginFactory().clone();
        this.ruleConfigParam = ruleConfigParam;
        this.messageIdToHostScan = -1;
        this.messagesIdsToAppScan = new ArrayList<Integer>();
        this.startNodes = new ArrayList<StructuralNode>();
        this.scanTimeoutInMillis = scannerParam.getThreadTimeoutInMillis();
        this.httpSender = new HttpSender(2);
        this.httpSender.setUser(this.user);
        this.httpSender.setRemoveUserDefinedAuthHeaders(true);
        this.threadPool = new ThreadPool(scannerParam.getThreadPerHost(), "HSTE-ActiveScanner-");
        this.techSet = TechSet.getAllTech();
    }

    public void setStartNode(StructuralNode startNode) {
        this.startNodes.clear();
        this.startNodes.add(startNode);
    }

    public void addStartNode(StructuralNode startNode) {
        this.startNodes.add(startNode);
    }

    public void stop() {
        this.isStop = true;
        this.getAnalyser().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug("HostProcess.run");
        try {
            this.hostProcessStartTime = System.currentTimeMillis();
            this.pluginFactory.reset();
            Map<Integer, PluginStats> map = this.mapPluginStats;
            synchronized (map) {
                for (Plugin plugin : this.pluginFactory.getPending()) {
                    this.mapPluginStats.put(plugin.getId(), new PluginStats(plugin));
                }
            }
            for (StructuralNode startNode : this.startNodes) {
                LinkedHashMap historyIdsToAdd = new LinkedHashMap();
                this.traverse(startNode, true, node -> {
                    if (this.canScanNode(node)) {
                        int nodeHistoryId = node.getHistoryReference().getHistoryId();
                        if (node.getMethod().equals("GET")) {
                            boolean nodeSeen = historyIdsToAdd.containsKey(this.nodeHash(node));
                            if (!nodeSeen || !this.isTemporary(node)) {
                                historyIdsToAdd.put(this.nodeHash(node), nodeHistoryId);
                            }
                        } else {
                            this.messagesIdsToAppScan.add(nodeHistoryId);
                        }
                    }
                });
                this.messagesIdsToAppScan.addAll(historyIdsToAdd.values());
                this.getAnalyser().start(startNode);
            }
            this.nodeInScopeCount = this.messagesIdsToAppScan.size();
            if (!this.messagesIdsToAppScan.isEmpty()) {
                this.messageIdToHostScan = this.messagesIdsToAppScan.get(0);
            }
            this.logScanInfo();
            while (!this.isStop() && this.pluginFactory.existPluginToRun()) {
                this.checkPause();
                if (this.isStop()) break;
                Plugin plugin = this.pluginFactory.nextPlugin();
                if (plugin != null) {
                    HostProcess.applyDeprecatedProperties(this.scannerParam, plugin);
                    plugin.setTechSet(this.techSet);
                    this.processPlugin(plugin);
                    continue;
                }
                Util.sleep(1000);
            }
            this.threadPool.waitAllThreadComplete(300000);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while active scanning:", (Throwable)e);
            this.stop();
        }
        finally {
            this.notifyHostProgress(null);
            this.notifyHostComplete();
        }
    }

    private String nodeHash(StructuralNode node) {
        String nodeMethod = node.getMethod();
        String nodeURI = node.getURI().getEscapedURI();
        return nodeMethod + nodeURI;
    }

    private boolean isTemporary(StructuralNode node) {
        return node.getHistoryReference().getHistoryType() == 0;
    }

    private void logScanInfo() {
        StringBuilder strBuilder = new StringBuilder(150);
        if (this.nodeInScopeCount != 0) {
            strBuilder.append("Scanning ");
            strBuilder.append(this.nodeInScopeCount);
            strBuilder.append(" node(s) ");
        } else {
            strBuilder.append("No nodes to scan ");
        }
        if (this.parentScanner.getJustScanInScope()) {
            strBuilder.append("[just in scope] ");
        }
        strBuilder.append("from ").append(this.hostAndPort);
        if (this.user != null) {
            strBuilder.append(" as ");
            strBuilder.append(this.user.getName());
        }
        if (this.nodeInScopeCount == 0) {
            strBuilder.append(", skipping all plugins.");
        }
        LOGGER.info(strBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlugin(Plugin plugin) {
        this.mapPluginStats.get(plugin.getId()).start();
        if (this.nodeInScopeCount == 0) {
            this.pluginSkipped(plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.nonodes"));
            this.pluginCompleted(plugin);
            return;
        }
        if (!plugin.targets(this.techSet)) {
            this.pluginSkipped(plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.techs"));
            this.pluginCompleted(plugin);
            return;
        }
        LOGGER.info("start host {} | {} strength {} threshold {}", (Object)this.hostAndPort, (Object)plugin.getCodeName(), (Object)plugin.getAttackStrength(), (Object)plugin.getAlertThreshold());
        if (plugin instanceof AbstractHostPlugin) {
            this.checkPause();
            if (this.isStop() || this.isSkipped(plugin) || !this.scanMessage(plugin, this.messageIdToHostScan)) {
                this.pluginCompleted(plugin);
            }
        } else if (plugin instanceof AbstractAppPlugin) {
            try {
                for (int messageId : this.messagesIdsToAppScan) {
                    this.checkPause();
                    if (this.isStop() || this.isSkipped(plugin)) {
                        return;
                    }
                    this.scanMessage(plugin, messageId);
                }
                this.threadPool.waitAllThreadComplete(this.scanTimeoutInMillis);
            }
            finally {
                this.pluginCompleted(plugin);
            }
        }
    }

    private void traverse(StructuralNode node, boolean incRelatedSiblings, TraverseAction action) {
        if (node == null || this.isStop()) {
            return;
        }
        HashSet<StructuralNode> parentNodes = new HashSet<StructuralNode>();
        parentNodes.add(node);
        action.apply(node);
        if (this.parentScanner.scanChildren()) {
            if (incRelatedSiblings) {
                try {
                    Iterator<StructuralNode> iter = node.getParent().getChildIterator();
                    String nodeName = SessionStructure.getCleanRelativeName(node, false);
                    while (iter.hasNext()) {
                        StructuralNode sibling = iter.next();
                        if (node.isSameAs(sibling) || !nodeName.equals(SessionStructure.getCleanRelativeName(sibling, false))) continue;
                        LOGGER.debug("traverse: including related sibling {}", (Object)sibling.getName());
                        parentNodes.add(sibling);
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            for (StructuralNode pNode : parentNodes) {
                Iterator<StructuralNode> iter = pNode.getChildIterator();
                while (iter.hasNext() && !this.isStop()) {
                    this.checkPause();
                    try {
                        this.traverse(iter.next(), false, action);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean nodeInScope(String nodeName) {
        return this.parentScanner.isInScope(nodeName);
    }

    private boolean filterNode(StructuralNode node) {
        for (ScanFilter scanFilter : this.parentScanner.getScanFilters()) {
            try {
                FilterResult filterResult = scanFilter.isFiltered(node);
                if (!filterResult.isFiltered()) continue;
                try {
                    HttpMessage msg = node.getHistoryReference().getHttpMessage();
                    this.parentScanner.notifyFilteredMessage(msg, filterResult.getReason());
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    LOGGER.warn("Error while getting httpmessage from history reference: {}", (Object)e.getMessage(), (Object)e);
                }
                LOGGER.debug("Ignoring filtered node: {} Reason: {}", (Object)node.getName(), (Object)filterResult.getReason());
                return true;
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    private boolean scanMessage(Plugin plugin, int messageId) {
        Thread thread;
        Plugin test;
        HttpMessage msg;
        HistoryReference historyReference;
        try {
            historyReference = new HistoryReference(messageId, true);
            msg = historyReference.getHttpMessage();
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.warn("Failed to read message with ID [{}], cause: {}", (Object)messageId, (Object)e.getMessage());
            return false;
        }
        try {
            if (msg.getResponseHeader().isEmpty() && !this.obtainResponse(historyReference, msg = msg.cloneRequest())) {
                return false;
            }
            LOGGER.debug("scanSingleNode node plugin={} node={}", (Object)plugin.getName(), (Object)historyReference.getURI());
            test = (Plugin)plugin.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            test.setConfig(plugin.getConfig());
            if (this.ruleConfigParam != null) {
                for (RuleConfig rc : this.ruleConfigParam.getAllRuleConfigs()) {
                    test.getConfig().setProperty(rc.getKey(), (Object)rc.getValue());
                }
            }
            HostProcess.applyDeprecatedProperties(plugin, test);
            test.setDefaultAlertThreshold(plugin.getAlertThreshold());
            test.setDefaultAttackStrength(plugin.getAttackStrength());
            test.setTechSet(this.getTechSet());
            test.init(msg, this);
            this.notifyHostProgress(plugin.getName() + ": " + msg.getRequestHeader().getURI().toString());
        }
        catch (Exception e) {
            LOGGER.error("{} {}", (Object)e.getMessage(), (Object)historyReference.getURI(), (Object)e);
            return false;
        }
        do {
            if (this.isStop()) {
                return false;
            }
            thread = this.threadPool.getFreeThreadAndRun(test);
            if (thread != null) continue;
            Util.sleep(200);
        } while (thread == null);
        this.mapPluginStats.get(plugin.getId()).incProgress();
        return true;
    }

    private static void applyDeprecatedProperties(ScannerParam source, Plugin dest) {
        dest.setDelayInMs(source.getDelayInMs());
    }

    private static void applyDeprecatedProperties(Plugin source, Plugin dest) {
        dest.setDelayInMs(source.getDelayInMs());
    }

    private boolean obtainResponse(HistoryReference hRef, HttpMessage message) {
        try {
            this.getHttpSender().sendAndReceive(message);
            this.notifyNewMessage(message);
            ++this.requestCount;
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to obtain the HTTP response for href [id={}, type={}, URL={}]: {}", (Object)hRef.getHistoryId(), (Object)hRef.getHistoryType(), (Object)hRef.getURI(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean canScanNode(StructuralNode node) {
        if (node == null) {
            LOGGER.debug("Ignoring null node");
            return false;
        }
        HistoryReference hRef = node.getHistoryReference();
        if (hRef == null) {
            LOGGER.debug("Ignoring null history reference for node: {}", (Object)node.getName());
            return false;
        }
        if (3 == hRef.getHistoryType()) {
            LOGGER.debug("Ignoring \"scanner\" type href [id={}, URL={}]", (Object)hRef.getHistoryId(), (Object)hRef.getURI());
            return false;
        }
        if (!this.nodeInScope(node.getName())) {
            LOGGER.debug("Ignoring node not in scope: {}", (Object)node.getName());
            return false;
        }
        return !this.filterNode(node);
    }

    public int getTestTotalCount() {
        return this.nodeInScopeCount;
    }

    public int getTestCurrentCount(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return 0;
        }
        return pluginStats.getProgress();
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public boolean isStop() {
        if (this.scannerParam.getMaxScanDurationInMins() > 0 && System.currentTimeMillis() - this.hostProcessStartTime > TimeUnit.MINUTES.toMillis(this.scannerParam.getMaxScanDurationInMins())) {
            this.stopReason = Constant.messages.getString("ascan.progress.label.skipped.reason.maxScan");
            this.stop();
        }
        return this.isStop || this.parentScanner.isStop();
    }

    public boolean isPaused() {
        return this.parentScanner.isPaused();
    }

    private void checkPause() {
        while (this.parentScanner.isPaused() && !this.isStop()) {
            Util.sleep(500);
        }
    }

    public int getPercentageComplete() {
        return this.percentage;
    }

    private void notifyHostProgress(String msg) {
        if (this.pluginFactory.totalPluginToRun() == 0) {
            this.percentage = 100;
        } else {
            int numberRunning = 0;
            double progressRunning = 0.0;
            for (Plugin plugin : this.pluginFactory.getRunning()) {
                int scannedNodes = this.getTestCurrentCount(plugin);
                double pluginPercentage = (double)scannedNodes * 100.0 / (double)this.getTestTotalCount();
                if (pluginPercentage >= 100.0) {
                    this.nodeInScopeCount = scannedNodes;
                    pluginPercentage = 99.0;
                }
                progressRunning += pluginPercentage;
                ++numberRunning;
            }
            int avgRunning = (int)(progressRunning / (double)numberRunning);
            this.percentage = (100 * this.pluginFactory.totalPluginCompleted() + avgRunning) / this.pluginFactory.totalPluginToRun();
        }
        this.parentScanner.notifyHostProgress(this.hostAndPort, msg, this.percentage);
    }

    private void notifyHostComplete() {
        long diffTimeMillis = System.currentTimeMillis() - this.hostProcessStartTime;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0) + "s";
        LOGGER.info("completed host {} in {} with {} alert(s) raised.", (Object)this.hostAndPort, (Object)diffTimeString, (Object)this.getAlertCount());
        this.parentScanner.notifyHostComplete(this.hostAndPort);
    }

    public void notifyNewMessage(HttpMessage msg) {
        this.parentScanner.notifyNewMessage(msg);
    }

    public void notifyNewMessage(Plugin plugin, HttpMessage message) {
        this.parentScanner.notifyNewMessage(message);
        this.notifyNewMessage(plugin);
    }

    public void notifyNewMessage(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Parameter plugin must not be null.");
        }
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null) {
            pluginStats.incMessageCount();
        }
    }

    public void alertFound(Alert alert) {
        ExtensionAlert extensionAlertRef = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
        if (extensionAlertRef.isNewAlert(alert)) {
            ++this.newAlertCount;
        }
        this.parentScanner.notifyAlertFound(alert);
        PluginStats pluginStats = this.mapPluginStats.get(alert.getPluginId());
        if (pluginStats != null) {
            pluginStats.incAlertCount();
            int maxAlertsPerRule = this.scannerParam.getMaxAlertsPerRule();
            if (maxAlertsPerRule > 0 && pluginStats.getAlertCount() >= maxAlertsPerRule) {
                this.pluginSkipped(alert.getPluginId(), Constant.messages.getString("ascan.progress.label.skipped.reason.maxAlertsPerRule"));
            }
        }
        ++this.alertCount;
    }

    public int getNewAlertCount() {
        return this.newAlertCount;
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    public Analyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = new Analyser(this.getHttpSender(), this);
        }
        return this.analyser;
    }

    HttpRequestConfig getRedirectRequestConfig() {
        if (this.redirectRequestConfig == null) {
            this.redirectRequestConfig = HttpRequestConfig.builder().setRedirectionValidator(this.getRedirectionValidator()).build();
        }
        return this.redirectRequestConfig;
    }

    HttpRedirectionValidator getRedirectionValidator() {
        if (this.redirectionValidator == null) {
            this.redirectionValidator = redirection -> {
                if (!this.nodeInScope(redirection.getEscapedURI())) {
                    LOGGER.debug("Skipping redirection out of scan's scope: {}", (Object)redirection);
                    return false;
                }
                return true;
            };
        }
        return this.redirectionValidator;
    }

    public boolean handleAntiCsrfTokens() {
        return this.scannerParam.getHandleAntiCSRFTokens();
    }

    public void pluginSkipped(Plugin plugin) {
        this.pluginSkipped(plugin, null);
    }

    public void pluginSkipped(int pluginId, String reason) {
        Plugin plugin = this.pluginFactory.getPlugin(pluginId);
        if (plugin == null) {
            return;
        }
        this.pluginSkipped(plugin, reason);
    }

    public void pluginSkipped(Plugin plugin, String reason) {
        if (this.isStop()) {
            return;
        }
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null || pluginStats.isSkipped() || this.pluginFactory.getCompleted().contains(plugin)) {
            return;
        }
        pluginStats.skip();
        pluginStats.setSkippedReason(reason);
        for (Plugin dependent : this.pluginFactory.getDependentPlugins(plugin)) {
            pluginStats = this.mapPluginStats.get(dependent.getId());
            if (pluginStats == null || pluginStats.isSkipped() || this.pluginFactory.getCompleted().contains(dependent)) continue;
            pluginStats.skip();
            pluginStats.setSkippedReason(Constant.messages.getString("ascan.progress.label.skipped.reason.dependency"));
        }
    }

    public boolean isSkipped(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null && pluginStats.isSkipped()) {
            return true;
        }
        if (plugin.getTimeFinished() == null && this.stopReason != null) {
            this.pluginSkipped(plugin, this.stopReason);
            return true;
        }
        if (this.scannerParam.getMaxRuleDurationInMins() > 0 && plugin.getTimeStarted() != null) {
            long endtime = System.currentTimeMillis();
            if (plugin.getTimeFinished() != null) {
                endtime = plugin.getTimeFinished().getTime();
            }
            if (endtime - plugin.getTimeStarted().getTime() > TimeUnit.MINUTES.toMillis(this.scannerParam.getMaxRuleDurationInMins())) {
                this.pluginSkipped(plugin, Constant.messages.getString("ascan.progress.label.skipped.reason.maxRule"));
                return true;
            }
        }
        return false;
    }

    public String getSkippedReason(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return this.stopReason;
        }
        return pluginStats.getSkippedReason();
    }

    void pluginCompleted(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return;
        }
        pluginStats.stopped();
        StringBuilder sb = new StringBuilder();
        if (this.isStop()) {
            sb.append("stopped host/plugin ");
        } else if (pluginStats.isSkipped()) {
            sb.append("skipped plugin ");
            String reason = pluginStats.getSkippedReason();
            if (reason != null) {
                sb.append('[').append(reason).append("] ");
            }
        } else {
            sb.append("completed host/plugin ");
        }
        sb.append(this.hostAndPort).append(" | ").append(plugin.getCodeName());
        String diffTimeString = decimalFormat.format((double)pluginStats.getTotalTime() / 1000.0);
        sb.append(" in ").append(diffTimeString).append('s');
        sb.append(" with ").append(pluginStats.getMessageCount()).append(" message(s) sent");
        sb.append(" and ").append(pluginStats.getAlertCount()).append(" alert(s) raised.");
        LOGGER.info(sb.toString());
        this.pluginFactory.setRunningPluginCompleted(plugin);
        this.notifyHostProgress(null);
        pluginStats.setProgress(this.nodeInScopeCount);
    }

    Kb getKb() {
        if (this.kb == null) {
            this.kb = new Kb();
        }
        return this.kb;
    }

    public ScannerParam getScannerParam() {
        return this.scannerParam;
    }

    public List<Plugin> getPending() {
        return this.pluginFactory.getPending();
    }

    public List<Plugin> getRunning() {
        return this.pluginFactory.getRunning();
    }

    public List<Plugin> getCompleted() {
        return this.pluginFactory.getCompleted();
    }

    public void setUser(User user) {
        this.user = user;
        if (this.httpSender != null) {
            this.httpSender.setUser(user);
        }
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        if (techSet == null) {
            throw new IllegalArgumentException("Parameter techSet must not be null.");
        }
        this.techSet = techSet;
    }

    protected synchronized void performScannerHookBeforeScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.beforeScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                LOGGER.info("An exception occurred while trying to call beforeScan(msg, plugin) for one of the ScannerHooks: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected synchronized void performScannerHookAfterScan(HttpMessage msg, AbstractPlugin plugin) {
        for (ScannerHook hook : this.parentScanner.getScannerHooks()) {
            if (hook == null) continue;
            try {
                hook.afterScan(msg, plugin, this.parentScanner);
            }
            catch (Exception e) {
                LOGGER.info("An exception occurred while trying to call afterScan(msg, plugin) for one of the ScannerHooks: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public int getPluginRequestCount(int pluginId) {
        PluginStats pluginStats = this.mapPluginStats.get(pluginId);
        if (pluginStats != null) {
            return pluginStats.getMessageCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            int count = this.requestCount + this.getAnalyser().getRequestCount();
            for (PluginStats stats : this.mapPluginStats.values()) {
                count += stats.getMessageCount();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginStats getPluginStats(int pluginId) {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            return this.mapPluginStats.get(pluginId);
        }
    }

    protected boolean isCustomPage(HttpMessage msg, CustomPage.Type cpType) {
        if (this.getContext() != null) {
            return this.getContext().isCustomPage(msg, cpType);
        }
        return false;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @FunctionalInterface
    private static interface TraverseAction {
        public void apply(StructuralNode var1);
    }
}

