/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import com.stackhawk.hste.extension.ascan.ActiveScanEventPublisher;
import com.stackhawk.hste.extension.ascan.ScanPolicy;
import com.stackhawk.hste.extension.ascan.filters.ScanFilter;
import com.stackhawk.hste.extension.ruleconfig.RuleConfigParam;
import com.stackhawk.hste.extension.script.ScriptCollection;
import com.stackhawk.hste.model.StructuralNode;
import com.stackhawk.hste.model.StructuralSiteNode;
import com.stackhawk.hste.model.Target;
import com.stackhawk.hste.model.TechSet;
import com.stackhawk.hste.users.User;
import com.stackhawk.hste.utils.Stats;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;

public class Scanner
implements Runnable {
    public static final String ASCAN_SCAN_STARTED_STATS = "stats.ascan.started";
    public static final String ASCAN_SCAN_STOPPED_STATS = "stats.ascan.stopped";
    public static final String ASCAN_SCAN_TIME_STATS = "stats.ascan.time";
    public static final String ASCAN_URLS_STATS = "stats.ascan.urls";
    public static final String ASCAN_RULE_PREFIX = "stats.ascan.";
    public static final String ALERTS_POSTFIX = ".alerts";
    public static final String SKIPPED_POSTFIX = ".skipped";
    public static final String STARTED_POSTFIX = ".started";
    public static final String TIME_POSTFIX = ".time";
    public static final String URLS_POSTFIX = ".urls";
    private static final Logger LOGGER = LogManager.getLogger(Scanner.class);
    private static DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private Vector<ScannerListener> listenerList = new Vector();
    private Vector<ScannerHook> hookList = new Vector();
    private ScannerParam scannerParam = null;
    private ScanPolicy scanPolicy;
    private RuleConfigParam ruleConfigParam;
    private boolean isStop = false;
    private ThreadPool pool = null;
    private Target target = null;
    private long startTimeMillis = 0L;
    private List<Pattern> excludeUrls = null;
    private boolean justScanInScope = false;
    private boolean scanChildren = true;
    private User user = null;
    private TechSet techSet;
    private Set<ScriptCollection> scriptCollections = new HashSet<ScriptCollection>();
    private List<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
    private int id;
    private boolean pause = false;
    private List<HostProcess> hostProcesses = new ArrayList<HostProcess>();

    @Deprecated
    public Scanner(ScannerParam scannerParam, ConnectionParam param, ScanPolicy scanPolicy) {
        this(scannerParam, param, scanPolicy, null);
    }

    @Deprecated
    public Scanner(ScannerParam scannerParam, ConnectionParam param, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this(scannerParam, scanPolicy, ruleConfigParam);
    }

    public Scanner(ScannerParam scannerParam, ScanPolicy scanPolicy, RuleConfigParam ruleConfigParam) {
        this.scannerParam = scannerParam;
        this.scanPolicy = scanPolicy;
        this.ruleConfigParam = ruleConfigParam;
        this.pool = new ThreadPool(scannerParam.getHostPerScan(), "HSTE-Scanner-");
        Control.getSingleton().getExtensionLoader().hookScannerHook(this);
        this.techSet = TechSet.getAllTech();
    }

    public void start(SiteNode startNode) {
        this.start(new Target(startNode));
    }

    public void start(Target target) {
        this.isStop = false;
        LOGGER.info("scanner started");
        this.startTimeMillis = System.currentTimeMillis();
        this.target = target;
        Thread thread = new Thread(this);
        thread.setPriority(3);
        thread.start();
        ActiveScanEventPublisher.publishScanEvent("scan.started", this.getId(), target, this.user);
        Stats.incCounter(ASCAN_SCAN_STARTED_STATS);
    }

    public void stop() {
        if (!this.isStop) {
            LOGGER.info("scanner stopped");
            this.isStop = true;
            this.hostProcesses.stream().forEach(HostProcess::stop);
            ActiveScanEventPublisher.publishScanEvent("scan.stopped", this.getId());
            Stats.incCounter(ASCAN_SCAN_STOPPED_STATS);
        }
    }

    public void addScannerListener(ScannerListener listener) {
        this.listenerList.add(listener);
    }

    public void removeScannerListener(ScannerListener listener) {
        this.listenerList.remove(listener);
    }

    public void addScannerHook(ScannerHook scannerHook) {
        this.hookList.add(scannerHook);
    }

    public void removerScannerHook(ScannerHook scannerHook) {
        this.hookList.remove(scannerHook);
    }

    protected Vector<ScannerHook> getScannerHooks() {
        return this.hookList;
    }

    @Override
    public void run() {
        try {
            this.scan(this.target);
            this.pool.waitAllThreadComplete(0);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while active scanning:", (Throwable)e);
        }
        finally {
            this.notifyScannerComplete();
        }
    }

    public void scan(Target target) {
        block14: {
            Thread thread;
            block13: {
                thread = null;
                this.setScanChildren(target.isRecurse());
                this.setJustScanInScope(target.isInScopeOnly());
                if (target.getStartNodes() == null) break block13;
                HostProcess hostProcess = null;
                List<StructuralNode> nodes = target.getStartNodes();
                if (nodes.size() == 1 && nodes.get(0).isRoot()) {
                    Iterator<StructuralNode> iter = nodes.get(0).getChildIterator();
                    while (iter.hasNext()) {
                        StructuralNode child = iter.next();
                        String string = this.getHostAndPort(child);
                        hostProcess = this.createHostProcess(string, child);
                        this.hostProcesses.add(hostProcess);
                        do {
                            if ((thread = this.pool.getFreeThreadAndRun(hostProcess)) != null) continue;
                            Util.sleep(500);
                        } while (thread == null && !this.isStop());
                        if (thread == null) continue;
                        this.notifyHostNewScan(string, hostProcess);
                    }
                } else {
                    HashMap<String, HostProcess> processMap = new HashMap<String, HostProcess>();
                    for (StructuralNode structuralNode : nodes) {
                        String hostAndPort = this.getHostAndPort(structuralNode);
                        hostProcess = (HostProcess)processMap.get(hostAndPort);
                        if (hostProcess == null) {
                            hostProcess = this.createHostProcess(hostAndPort, structuralNode);
                            processMap.put(hostAndPort, hostProcess);
                            continue;
                        }
                        hostProcess.addStartNode(structuralNode);
                    }
                    for (Map.Entry entry : processMap.entrySet()) {
                        this.hostProcesses.add((HostProcess)entry.getValue());
                        thread = this.pool.getFreeThreadAndRun((Runnable)entry.getValue());
                        this.notifyHostNewScan((String)entry.getKey(), (HostProcess)entry.getValue());
                    }
                }
                break block14;
            }
            if (target.getContext() == null && !target.isInScopeOnly()) break block14;
            if (Constant.isLowMemoryOptionSet()) {
                throw new InvalidParameterException("Not yet supported for the low memory option :(");
            }
            List<Object> nodes = Collections.emptyList();
            if (target.isInScopeOnly()) {
                this.justScanInScope = true;
                nodes = Model.getSingleton().getSession().getTopNodesInScopeFromSiteTree();
            } else if (target.getContext() != null) {
                nodes = target.getContext().getTopNodesInContextFromSiteTree();
            }
            for (SiteNode node : nodes) {
                String hostAndPort = this.getHostAndPort(node);
                HostProcess hostProcess = this.createHostProcess(hostAndPort, new StructuralSiteNode(node));
                this.hostProcesses.add(hostProcess);
                do {
                    if ((thread = this.pool.getFreeThreadAndRun(hostProcess)) != null) continue;
                    Util.sleep(500);
                } while (thread == null && !this.isStop());
                if (thread == null) continue;
                this.notifyHostNewScan(hostAndPort, hostProcess);
            }
        }
    }

    private HostProcess createHostProcess(String hostAndPort, StructuralNode node) {
        HostProcess hostProcess = new HostProcess(hostAndPort, this, this.scannerParam, this.scanPolicy, this.ruleConfigParam);
        hostProcess.setStartNode(node);
        hostProcess.setUser(this.user);
        hostProcess.setTechSet(this.techSet);
        hostProcess.setContext(this.target.getContext());
        return hostProcess;
    }

    public boolean isStop() {
        return this.isStop;
    }

    private String getHostAndPort(SiteNode node) {
        String result = "";
        SiteNode parent = null;
        if (node == null || node.isRoot()) {
            result = "";
        } else {
            SiteNode curNode = node;
            parent = node.getParent();
            while (!parent.isRoot()) {
                curNode = parent;
                parent = curNode.getParent();
            }
            result = curNode.getNodeName();
        }
        return result;
    }

    private String getHostAndPort(StructuralNode node) {
        String url;
        int idx;
        String result = "";
        result = node == null || node.isRoot() ? "" : ((idx = (url = node.getName()).indexOf("/", url.indexOf("//") + 2)) > 0 ? url.substring(0, idx) : url);
        return result;
    }

    void notifyHostComplete(String hostAndPort) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.hostComplete(this.id, hostAndPort);
        }
    }

    void notifyHostProgress(String hostAndPort, String msg, int percentage) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.hostProgress(this.id, hostAndPort, msg, percentage);
        }
    }

    void notifyScannerComplete() {
        int i;
        long diffTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
        String diffTimeString = decimalFormat.format((double)diffTimeMillis / 1000.0) + "s";
        LOGGER.info("scanner completed in {}", (Object)diffTimeString);
        this.isStop = true;
        ActiveScanEventPublisher.publishScanEvent("scan.completed", this.getId());
        Stats.incCounter(ASCAN_SCAN_TIME_STATS, diffTimeMillis);
        for (i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.scannerComplete(this.id);
        }
        for (i = 0; i < this.hookList.size(); ++i) {
            try {
                ScannerHook hook = this.hookList.get(i);
                hook.scannerComplete();
                continue;
            }
            catch (Exception e) {
                LOGGER.info("An exception occurred while notifying a ScannerHook about scanner completion: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    void notifyFilteredMessage(HttpMessage msg, String reason) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.filteredMessage(msg, reason);
        }
    }

    void notifyAlertFound(Alert alert) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.alertFound(alert);
        }
    }

    void notifyHostNewScan(String hostAndPort, HostProcess hostThread) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.hostNewScan(this.id, hostAndPort, hostThread);
        }
    }

    public void pause() {
        this.pause = true;
        ActiveScanEventPublisher.publishScanEvent("scan.paused", this.getId());
    }

    public void resume() {
        this.pause = false;
        ActiveScanEventPublisher.publishScanEvent("scan.resumed", this.getId());
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void notifyNewMessage(HttpMessage msg) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener listener = this.listenerList.get(i);
            listener.notifyNewMessage(msg);
        }
    }

    public void setExcludeList(List<String> urls) {
        if (urls != null) {
            this.excludeUrls = new ArrayList<Pattern>(urls.size());
            for (String url : urls) {
                Pattern p = Pattern.compile(url, 2);
                this.excludeUrls.add(p);
            }
        } else {
            this.excludeUrls = new ArrayList<Pattern>(0);
        }
    }

    public boolean isInScope(String nodeName) {
        if (this.justScanInScope && !Model.getSingleton().getSession().isInScope(nodeName)) {
            return false;
        }
        if (this.target.getContext() != null && !this.target.getContext().isInContext(nodeName)) {
            return false;
        }
        if (this.excludeUrls != null) {
            for (Pattern p : this.excludeUrls) {
                if (!p.matcher(nodeName).matches()) continue;
                LOGGER.debug("URL excluded: {} Regex: {}", (Object)nodeName, (Object)p.pattern());
                return false;
            }
        }
        return true;
    }

    public void setStartNode(SiteNode startNode) {
        this.target = new Target(startNode);
    }

    public SiteNode getStartNode() {
        if (this.target != null) {
            return this.target.getStartNode();
        }
        return null;
    }

    public void setJustScanInScope(boolean scanInScope) {
        this.justScanInScope = scanInScope;
    }

    public boolean getJustScanInScope() {
        return this.justScanInScope;
    }

    public void setScanChildren(boolean scanChildren) {
        this.scanChildren = scanChildren;
    }

    public boolean scanChildren() {
        return this.scanChildren;
    }

    public List<HostProcess> getHostProcesses() {
        return this.hostProcesses;
    }

    public void setScannerParam(ScannerParam scannerParam) {
        this.scannerParam = scannerParam;
    }

    public void setScanPolicy(ScanPolicy scanPolicy) {
        this.scanPolicy = scanPolicy;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        if (techSet == null) {
            throw new IllegalArgumentException("Parameter techSet must not be null.");
        }
        this.techSet = techSet;
    }

    public void addScriptCollection(ScriptCollection sc) {
        this.scriptCollections.add(sc);
    }

    public Set<ScriptCollection> getScriptCollections() {
        return this.scriptCollections;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    List<ScanFilter> getScanFilters() {
        return this.scanFilters;
    }

    public void addScanFilter(ScanFilter scanFilter) {
        this.scanFilters.add(Objects.requireNonNull(scanFilter));
    }
}

