/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import com.stackhawk.hste.extension.script.ExtensionScript;
import com.stackhawk.hste.extension.script.ScriptWrapper;
import com.stackhawk.hste.model.SessionStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantScript;
import org.parosproxy.paros.network.HttpMessage;

public class VariantCustom
implements Variant {
    ExtensionScript extension = null;
    private ScriptWrapper wrapper = null;
    private VariantScript script = null;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private NameValuePair currentParam;
    private static final Pattern BASE64_PATTERN = Pattern.compile("^[a-zA-Z0-9/+]+={0,2}$");
    private static final String SHORT_NAME = "script";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public VariantCustom(ScriptWrapper wrapper, ExtensionScript extension) {
        this.wrapper = wrapper;
        this.extension = extension;
        if (wrapper != null && extension != null && wrapper.isEnabled()) {
            try {
                this.script = extension.getInterface(wrapper, VariantScript.class);
                if (this.script == null) {
                    extension.handleFailedScriptInterface(wrapper, Constant.messages.getString("variant.scripts.interface.variant.error", wrapper.getName()));
                }
            }
            catch (Exception ex) {
                this.extension.handleScriptException(wrapper, ex);
            }
        }
    }

    public VariantCustom(ScriptWrapper wrapper, VariantScript script, ExtensionScript extension) {
        this.wrapper = wrapper;
        this.script = script;
        this.extension = extension;
    }

    @Override
    public void setMessage(HttpMessage msg) {
        try {
            if (this.script != null) {
                this.script.parseParameters(this, msg);
            }
        }
        catch (Exception e) {
            this.extension.handleScriptException(this.wrapper, e);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    public String getParamName(int index) {
        return index < this.params.size() ? this.params.get(index).getName() : null;
    }

    public String getParamValue(int index) {
        return index < this.params.size() ? this.params.get(index).getValue() : null;
    }

    public int getParamNumber() {
        return this.params.size();
    }

    public NameValuePair getCurrentParam() {
        return this.currentParam;
    }

    public void addParam(String name, String value, int type) {
        this.params.add(new NameValuePair(type, name, value, this.params.size()));
    }

    public void addParamQuery(String name, String value) {
        this.addParam(name, value, 1);
    }

    public void addParamPost(String name, String value) {
        this.addParam(name, value, 2);
    }

    public void addParamHeader(String name, String value) {
        this.addParam(name, value, 8);
    }

    public String encodeBase64(String value) {
        return Base64.encodeBase64String(value.getBytes());
    }

    public String decodeBase64(String value) {
        return new String(Base64.decodeBase64(value));
    }

    public boolean isBase64(String value) {
        return BASE64_PATTERN.matcher(value).matches() && value.length() % 4 == 0;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value, true);
    }

    public String getStandardLeafName(String nodeName, HttpMessage msg, List<NameValuePair> params) {
        return SessionStructure.getLeafName(nodeName, msg, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setParameter(HttpMessage msg, NameValuePair originalPair, String paramName, String value, boolean escaped) {
        try {
            if (this.script != null) {
                this.currentParam = originalPair;
                this.script.setParameter(this, msg, paramName, value, escaped);
            }
        }
        catch (Exception e) {
            this.extension.handleScriptException(this.wrapper, e);
        }
        finally {
            this.currentParam = null;
        }
        return value;
    }

    @Override
    public String getLeafName(String nodeName, HttpMessage msg) {
        if (this.script != null) {
            try {
                return this.script.getLeafName(this, nodeName, msg);
            }
            catch (Exception e) {
                this.extension.handleScriptException(this.wrapper, e);
            }
        }
        return null;
    }

    @Override
    public List<String> getTreePath(HttpMessage msg) {
        if (this.script != null) {
            try {
                return this.script.getTreePath(this, msg);
            }
            catch (Exception e) {
                this.extension.handleScriptException(this.wrapper, e);
            }
        }
        return null;
    }
}

