/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import com.stackhawk.hste.model.SessionStructure;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;

public class VariantDdnPath
implements Variant {
    private static final Logger LOGGER = LogManager.getLogger(VariantDdnPath.class);
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();
    private static final String SHORT_NAME = "datadrivennode";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void setMessage(HttpMessage msg) {
        try {
            List<String> treePath = SessionStructure.getTreePath(Model.getSingleton(), msg);
            String actualPath = msg.getRequestHeader().getURI().getPath();
            this.addParamsFromTreePath(treePath, actualPath);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    void addParamsFromTreePath(List<String> treePath, String actualPath) {
        int position = 0;
        boolean useActualValue = false;
        String[] actualPathParts = null;
        for (String nodeName : treePath) {
            if (nodeName.startsWith("\u00ab")) {
                if (actualPathParts == null && actualPath != null) {
                    actualPathParts = actualPath.split("/");
                    useActualValue = treePath.size() == actualPathParts.length;
                }
                String value = useActualValue ? actualPathParts[position] : nodeName;
                this.stringParam.add(new NameValuePair(16, nodeName, value, position));
            }
            ++position;
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String getEscapedValue(String value) {
        if (value != null) {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        URI uri = msg.getRequestHeader().getURI();
        CharSequence[] paths = uri.getEscapedPath().split("/");
        if (originalPair.getPosition() < paths.length) {
            String encodedValue;
            paths[originalPair.getPosition()] = encodedValue = escaped ? value : this.getEscapedValue(value);
            String path = String.join((CharSequence)"/", paths);
            try {
                uri.setEscapedPath(path);
            }
            catch (URIException e) {
                try {
                    uri.setPath(path);
                }
                catch (URIException e1) {
                    LOGGER.debug(e1.getMessage(), (Throwable)e1);
                }
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }
}

