/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import com.stackhawk.hste.utils.DisplayUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.parosproxy.paros.model.Model;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = -3951504408180103696L;
    protected AbstractDialog thisDialog = null;

    public AbstractDialog() throws HeadlessException {
        this.initialize();
    }

    public AbstractDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    public AbstractDialog(Window owner, boolean modal) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(modal);
        this.initialize();
    }

    private void initialize() {
        this.setVisible(false);
        this.setIconImages(DisplayUtils.getHsteIconImages());
        this.setDefaultCloseOperation(2);
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(300, 200);
        }
        this.setTitle("HSTE");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 3516424501887406165L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.dispatchEvent(new WindowEvent(AbstractDialog.this, 201));
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public void centreDialog() {
        this.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
    }

    @Override
    public void setVisible(boolean show) {
        if (show && Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.centreDialog();
        }
        super.setVisible(show);
    }
}

