/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import com.stackhawk.hste.view.TabbedPanel2;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.parosproxy.paros.model.Model;

public class AbstractPanel
extends JPanel {
    private static final long serialVersionUID = 4076608955743534659L;
    private Icon icon = null;
    private int tabIndex = -1;
    private TabbedPanel2 parent = null;
    private boolean hideable = true;
    private boolean pinned = false;
    private boolean locked = false;
    private boolean showByDefault = false;
    private KeyStroke defaultAccelerator;
    private char mnemonic;

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public AbstractPanel() {
        this.initialize();
    }

    private void initialize() {
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(300, 200);
        }
    }

    public void setTabFocus() {
        Container c;
        if (this.parent != null) {
            this.parent.setVisible(this, true);
        }
        if ((c = this.getParent()) instanceof JTabbedPane) {
            JTabbedPane tab = (JTabbedPane)c;
            tab.setSelectedComponent(this);
        } else {
            AbstractPanel ancestorPanel = (AbstractPanel)SwingUtilities.getAncestorOfClass(AbstractPanel.class, this);
            if (ancestorPanel != null) {
                ancestorPanel.setTabFocus();
            }
        }
    }

    public boolean isTabVisible() {
        if (this.parent != null) {
            return this.parent.isTabVisible(this);
        }
        return this.isVisible();
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void setParent(TabbedPanel2 parent) {
        this.parent = parent;
    }

    public void tabSelected() {
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public void setHideable(boolean hideable) {
        this.hideable = hideable;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public void setShowByDefault(boolean showByDefault) {
        this.showByDefault = showByDefault;
    }

    public KeyStroke getDefaultAccelerator() {
        return this.defaultAccelerator;
    }

    public void setDefaultAccelerator(KeyStroke defaultAccelerator) {
        this.defaultAccelerator = defaultAccelerator;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
    }
}

