/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.edit;

import com.stackhawk.hste.view.HsteMenuItem;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.edit.PopupFindMenu;
import org.parosproxy.paros.view.FindDialog;
import org.parosproxy.paros.view.View;

public class ExtensionEdit
extends ExtensionAdaptor {
    private static final String NAME = "ExtensionEdit";
    private static KeyStroke findDefaultKeyStroke;
    private HsteMenuItem menuFind = null;
    private PopupFindMenu popupFindMenu = null;

    public ExtensionEdit() {
        super(NAME);
        this.setOrder(4);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("edit.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuFind());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuFind());
        }
    }

    private void showFindDialog(Window window, JTextComponent lastInvoker) {
        FindDialog findDialog = FindDialog.getDialog(window, false);
        findDialog.setLastInvoker(lastInvoker);
        findDialog.setVisible(true);
    }

    private HsteMenuItem getMenuFind() {
        if (this.menuFind == null) {
            this.menuFind = new HsteMenuItem("menu.edit.find", ExtensionEdit.getFindDefaultKeyStroke());
            this.menuFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextComponent invoker = null;
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (owner instanceof JTextComponent) {
                        invoker = (JTextComponent)owner;
                    }
                    ExtensionEdit.this.showFindDialog(ExtensionEdit.this.getView().getMainFrame(), invoker);
                }
            });
        }
        return this.menuFind;
    }

    public static KeyStroke getFindDefaultKeyStroke() {
        if (findDefaultKeyStroke == null) {
            findDefaultKeyStroke = View.getSingleton().getMenuShortcutKeyStroke(70, 0, false);
        }
        return findDefaultKeyStroke;
    }

    private PopupFindMenu getPopupMenuFind() {
        if (this.popupFindMenu == null) {
            this.popupFindMenu = new PopupFindMenu();
            this.popupFindMenu.setText(Constant.messages.getString("edit.find.popup"));
            this.popupFindMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextComponent component = ExtensionEdit.this.popupFindMenu.getLastInvoker();
                    Window window = ExtensionEdit.getWindowAncestor(component);
                    if (window != null) {
                        ExtensionEdit.this.showFindDialog(window, component);
                    }
                }
            });
        }
        return this.popupFindMenu;
    }

    private static Window getWindowAncestor(JTextComponent component) {
        if (component == null) {
            return null;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

