/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import com.stackhawk.hste.model.SessionStructure;
import java.awt.EventQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.ProxyListenerLogEventPublisher;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class ProxyListenerLog
implements ProxyListener,
ConnectRequestProxyListener {
    private static final Logger LOGGER = LogManager.getLogger(ProxyListenerLog.class);
    public static final int PROXY_LISTENER_ORDER = 5000;
    private ViewDelegate view = null;
    private Model model = null;
    private boolean isFirstAccess = true;
    private ExtensionHistory extension = null;

    public ProxyListenerLog(Model model, ViewDelegate view, ExtensionHistory extension) {
        this.model = model;
        this.view = view;
        this.extension = extension;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5000;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        int type = 1;
        if (this.isSkipImage(msg.getRequestHeader()) || this.isSkipImage(msg.getResponseHeader())) {
            if (msg.getResponseHeader().getStatusCode() == 200) {
                type = 6;
            } else {
                return true;
            }
        }
        final int finalType = type;
        final HistoryReference href = this.createHistoryReference(msg, type);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ProxyListenerLog.this.createAndAddMessage(href, finalType);
            }
        });
        t.start();
        return true;
    }

    public boolean isSkipImage(HttpHeader header) {
        return header.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }

    private void createAndAddMessage(HistoryReference historyRef, int type) {
        if (historyRef == null || type != 1 && type != 6) {
            return;
        }
        this.extension.addHistory(historyRef);
        try {
            this.addToSiteMap(historyRef, historyRef.getHttpMessage());
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.warn("Failed to add the message to Sites tree:", (Throwable)e);
        }
        ProxyListenerLogEventPublisher.getPublisher().publishHrefAddedEvent(historyRef);
    }

    private HistoryReference createHistoryReference(HttpMessage message, int type) {
        try {
            return new HistoryReference(this.model.getSession(), type, message);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void addToSiteMap(final HistoryReference ref, final HttpMessage msg) {
        if (this.hasView() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProxyListenerLog.this.addToSiteMap(ref, msg);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            return;
        }
        SessionStructure.addPath(this.model, ref, msg);
        if (this.isFirstAccess && !Constant.isLowMemoryOptionSet()) {
            this.isFirstAccess = false;
            if (this.hasView()) {
                this.view.getSiteTreePanel().expandRoot();
            }
        }
    }

    private boolean hasView() {
        return this.view != null;
    }

    @Override
    public void receivedConnectRequest(final HttpMessage connectMessage) {
        if (!this.model.getOptionsParam().getViewParam().isShowLocalConnectRequests()) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HistoryReference historyRef = ProxyListenerLog.this.createHistoryReference(connectMessage, 16);
                if (historyRef != null) {
                    ProxyListenerLog.this.extension.addHistory(historyRef);
                }
            }
        });
        t.start();
    }
}

