/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import ch.csnc.extension.httpclient.PKCS11Configuration;
import ch.csnc.extension.httpclient.SSLContextManager;
import ch.csnc.extension.ui.AliasTableModel;
import ch.csnc.extension.ui.CertificateView;
import ch.csnc.extension.ui.DriversView;
import ch.csnc.extension.util.DriverConfiguration;
import com.stackhawk.hste.utils.HsteTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.cert.Certificate;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.OptionsParamCertificate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;

@Deprecated
public class OptionsCertificatePanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 4350957038174673492L;
    private static final int MAX_LOGIN_ATTEMPTS = 3;
    private JButton addPkcs11Button;
    private JButton addPkcs12Button;
    private JScrollPane aliasScrollPane;
    private JTable aliasTable;
    private JButton browseButton;
    private JLabel certificateLabel;
    private JPanel certificatePanel;
    private HsteTextField certificateTextField;
    private JTabbedPane certificatejTabbedPane;
    private JButton deleteButton;
    private JButton driverButton;
    private JComboBox<String> driverComboBox;
    private JLabel driverLabel;
    private JLabel fileLabel;
    private HsteTextField fileTextField;
    private JList<String> keyStoreList;
    private JPanel keyStorePanel;
    private JScrollPane keyStoreScrollPane;
    private JLabel passwordPkcs11Label;
    private JLabel passwordPkcs12Label;
    private JPanel pkcs11Panel;
    private JPasswordField pkcs11PasswordField;
    private JPanel pkcs12Panel;
    private JPasswordField pkcs12PasswordField;
    private JButton setActiveButton;
    private JButton showActiveCertificateButton;
    private JButton showAliasButton;
    private JLabel textLabel;
    private JCheckBox useClientCertificateCheckBox;
    private JCheckBox usePkcs11ExperimentalSliSupportCheckBox;
    private SSLContextManager contextManager;
    private DefaultListModel<String> keyStoreListModel;
    private AliasTableModel aliasTableModel;
    private DriverConfiguration driverConfig;
    private boolean retry = true;
    private boolean overrideEnableClientCertificate = false;
    private static int login_attempts = 0;
    private static final Logger logger = LogManager.getLogger(OptionsCertificatePanel.class);

    public OptionsCertificatePanel() {
        this.initialize();
    }

    private void initialize() {
        this.contextManager = Model.getSingleton().getOptionsParam().getCertificateParam().getSSLContextManager();
        this.keyStoreListModel = new DefaultListModel();
        this.aliasTableModel = new AliasTableModel(this.contextManager);
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("options.cert.title"));
        JPanel certificatePanel = this.getPanelCertificate();
        this.add((Component)certificatePanel, certificatePanel.getName());
        this.driverConfig = OptionsCertificatePanel.createDriverConfiguration();
        this.updateDriverComboBox();
        this.driverConfig.addChangeListener(e -> this.updateDriverComboBox());
        Certificate cert = this.contextManager.getDefaultCertificate();
        if (cert != null) {
            this.certificateTextField.setText(cert.toString());
        }
        if (this.contextManager.getKeyStoreCount() != 0) {
            this.overrideEnableClientCertificate = true;
        }
    }

    private static DriverConfiguration createDriverConfiguration() {
        String fileName = "drivers.xml";
        Path path = Paths.get(Constant.getHsteInstall(), "xml", fileName);
        if (Files.exists(path, new LinkOption[0])) {
            return new DriverConfiguration(path.toFile());
        }
        return new DriverConfiguration(OptionsCertificatePanel.class.getResource("/com/stackhawk/hste/resources/" + fileName));
    }

    private void updateDriverComboBox() {
        this.driverComboBox.removeAllItems();
        for (String name : this.driverConfig.getNames()) {
            this.driverComboBox.addItem(name);
        }
        this.driverComboBox.repaint();
    }

    private JPanel getPanelCertificate() {
        if (this.certificatePanel == null) {
            this.certificatePanel = new JPanel();
            this.certificatejTabbedPane = new JTabbedPane();
            this.keyStorePanel = new JPanel();
            this.setActiveButton = new JButton();
            this.showAliasButton = new JButton();
            this.aliasScrollPane = new JScrollPane();
            this.aliasTable = new JTable();
            this.deleteButton = new JButton();
            this.keyStoreScrollPane = new JScrollPane();
            this.keyStoreList = new JList();
            this.pkcs12Panel = new JPanel();
            this.fileLabel = new JLabel();
            this.fileTextField = new HsteTextField();
            this.browseButton = new JButton();
            this.passwordPkcs12Label = new JLabel();
            this.addPkcs12Button = new JButton();
            this.pkcs12PasswordField = new JPasswordField();
            this.pkcs11Panel = new JPanel();
            this.driverLabel = new JLabel();
            this.driverComboBox = new JComboBox();
            this.driverButton = new JButton();
            this.passwordPkcs11Label = new JLabel();
            this.addPkcs11Button = new JButton();
            this.pkcs11PasswordField = new JPasswordField();
            this.useClientCertificateCheckBox = new JCheckBox();
            this.textLabel = new JLabel();
            this.certificateLabel = new JLabel();
            this.certificateTextField = new HsteTextField();
            this.showActiveCertificateButton = new JButton();
            this.usePkcs11ExperimentalSliSupportCheckBox = new JCheckBox();
            this.certificatejTabbedPane.setEnabled(false);
            this.setActiveButton.setText(Constant.messages.getString("options.cert.button.setactive"));
            this.setActiveButton.setEnabled(false);
            this.setActiveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        OptionsCertificatePanel.this.setActiveButtonActionPerformed(evt);
                    }
                    catch (ProviderException e) {
                        OptionsCertificatePanel.showKeyStoreCertError(e.toString());
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            this.showAliasButton.setText("->");
            this.showAliasButton.setEnabled(false);
            this.showAliasButton.setMargin(new Insets(2, 2, 2, 2));
            this.showAliasButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.showAliasButtonActionPerformed(evt);
                }
            });
            this.aliasTable.setModel(this.aliasTableModel);
            this.aliasTable.setTableHeader(null);
            this.aliasScrollPane.setViewportView(this.aliasTable);
            this.deleteButton.setText(Constant.messages.getString("options.cert.button.delete"));
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.deleteButtonActionPerformed(evt);
                }
            });
            this.keyStoreList.setModel(this.keyStoreListModel);
            this.keyStoreList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    OptionsCertificatePanel.this.keyStoreListSelectionChanged();
                }
            });
            this.keyStoreScrollPane.setViewportView(this.keyStoreList);
            GroupLayout keyStorePanelLayout = new GroupLayout(this.keyStorePanel);
            this.keyStorePanel.setLayout(keyStorePanelLayout);
            keyStorePanelLayout.setHorizontalGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, keyStorePanelLayout.createSequentialGroup().addGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deleteButton).addComponent(this.keyStoreScrollPane, -1, 181, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(keyStorePanelLayout.createSequentialGroup().addComponent(this.setActiveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 100, Short.MAX_VALUE).addComponent(this.showAliasButton)).addComponent(this.aliasScrollPane, -1, 202, Short.MAX_VALUE))));
            keyStorePanelLayout.setVerticalGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, keyStorePanelLayout.createSequentialGroup().addGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aliasScrollPane, 0, 0, Short.MAX_VALUE).addComponent(this.keyStoreScrollPane, -1, 95, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(keyStorePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.setActiveButton, -2, 18, -2).addComponent(this.showAliasButton))));
            keyStorePanelLayout.linkSize(1, this.deleteButton, this.setActiveButton, this.showAliasButton);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.keystore"), this.keyStorePanel);
            this.fileLabel.setText(Constant.messages.getString("options.cert.label.file"));
            this.browseButton.setText(Constant.messages.getString("options.cert.button.browse"));
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.browseButtonActionPerformed(evt);
                }
            });
            this.passwordPkcs12Label.setText(Constant.messages.getString("options.cert.label.password"));
            this.addPkcs12Button.setText(Constant.messages.getString("options.cert.button.keystore"));
            this.addPkcs12Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.addPkcs12ButtonActionPerformed(evt);
                }
            });
            GroupLayout pkcs12PanelLayout = new GroupLayout(this.pkcs12Panel);
            this.pkcs12Panel.setLayout(pkcs12PanelLayout);
            pkcs12PanelLayout.setHorizontalGroup(pkcs12PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pkcs12PanelLayout.createSequentialGroup().addGroup(pkcs12PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pkcs12PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileTextField, -1, 296, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(pkcs12PanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.fileLabel)).addGroup(pkcs12PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.passwordPkcs12Label)).addGroup(GroupLayout.Alignment.TRAILING, pkcs12PanelLayout.createSequentialGroup().addContainerGap(270, Short.MAX_VALUE).addComponent(this.addPkcs12Button)).addGroup(pkcs12PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pkcs12PasswordField, -1, 369, Short.MAX_VALUE))).addContainerGap()));
            pkcs12PanelLayout.setVerticalGroup(pkcs12PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pkcs12PanelLayout.createSequentialGroup().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pkcs12PanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordPkcs12Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkcs12PasswordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addPkcs12Button).addGap(70, 70, 70)));
            pkcs12PanelLayout.linkSize(1, this.addPkcs12Button, this.browseButton, this.fileTextField, this.pkcs12PasswordField);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.pkcs"), this.pkcs12Panel);
            this.driverLabel.setText(Constant.messages.getString("options.cert.label.driver"));
            this.driverButton.setText("...");
            this.driverButton.setMargin(new Insets(2, 5, 2, 5));
            this.driverButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.driverButtonActionPerformed(evt);
                }
            });
            this.passwordPkcs11Label.setText(Constant.messages.getString("options.cert.label.pincode"));
            this.addPkcs11Button.setText(Constant.messages.getString("options.cert.button.pkcs11"));
            this.addPkcs11Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.addPkcs11ButtonActionPerformed(evt);
                }
            });
            this.usePkcs11ExperimentalSliSupportCheckBox.setText(Constant.messages.getString("certificates.pkcs11.label.experimentalSliSupport"));
            this.usePkcs11ExperimentalSliSupportCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.usePkcs11ExperimentalSliSupportCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.usePkcs11ExperimentalSliSupportCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.usePkcs11ExperimentalSliSupportCheckBoxActionPerformed(evt);
                }
            });
            GroupLayout pkcs11PanelLayout = new GroupLayout(this.pkcs11Panel);
            this.pkcs11Panel.setLayout(pkcs11PanelLayout);
            pkcs11PanelLayout.setHorizontalGroup(pkcs11PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pkcs11PanelLayout.createSequentialGroup().addContainerGap().addGroup(pkcs11PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pkcs11PasswordField, -1, 369, Short.MAX_VALUE).addComponent(this.driverLabel).addComponent(this.passwordPkcs11Label).addGroup(pkcs11PanelLayout.createSequentialGroup().addComponent(this.driverComboBox, 0, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.driverButton)).addComponent(this.usePkcs11ExperimentalSliSupportCheckBox).addComponent(this.addPkcs11Button, GroupLayout.Alignment.TRAILING)).addContainerGap()));
            pkcs11PanelLayout.setVerticalGroup(pkcs11PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pkcs11PanelLayout.createSequentialGroup().addComponent(this.driverLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pkcs11PanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.driverButton).addComponent(this.driverComboBox, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordPkcs11Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkcs11PasswordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usePkcs11ExperimentalSliSupportCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addPkcs11Button).addGap(58, 58, 58)));
            pkcs11PanelLayout.linkSize(1, this.addPkcs11Button, this.driverButton, this.driverComboBox, this.pkcs11PasswordField);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.pkcs11"), this.pkcs11Panel);
            this.useClientCertificateCheckBox.setText(Constant.messages.getString("options.cert.label.useclientcert"));
            this.useClientCertificateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.useClientCertificateCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.useClientCertificateCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.useClientCertificateCheckBoxActionPerformed(evt);
                }
            });
            this.textLabel.setText(Constant.messages.getString("options.cert.label.addkeystore"));
            this.certificateLabel.setText(Constant.messages.getString("options.cert.label.activecerts"));
            this.certificateTextField.setEnabled(false);
            this.certificateTextField.setEditable(false);
            this.showActiveCertificateButton.setText("->");
            this.showActiveCertificateButton.setActionCommand(">");
            this.showActiveCertificateButton.setEnabled(false);
            this.showActiveCertificateButton.setMargin(new Insets(2, 2, 2, 2));
            this.showActiveCertificateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OptionsCertificatePanel.this.showActiveCertificateButtonActionPerformed(evt);
                }
            });
            GroupLayout certificatePanelLayout = new GroupLayout(this.certificatePanel);
            this.certificatePanel.setLayout(certificatePanelLayout);
            certificatePanelLayout.setHorizontalGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(certificatePanelLayout.createSequentialGroup().addComponent(this.textLabel, 0, 0, Short.MAX_VALUE).addContainerGap()).addGroup(certificatePanelLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.certificatejTabbedPane, -1, 394, Short.MAX_VALUE).addGroup(certificatePanelLayout.createSequentialGroup().addGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useClientCertificateCheckBox).addComponent(this.certificateLabel).addGroup(GroupLayout.Alignment.TRAILING, certificatePanelLayout.createSequentialGroup().addComponent(this.certificateTextField, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showActiveCertificateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addContainerGap())))));
            certificatePanelLayout.setVerticalGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(certificatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.useClientCertificateCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificatejTabbedPane, -1, 152, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(certificatePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.certificateTextField, -2, -1, -2).addComponent(this.showActiveCertificateButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
            certificatePanelLayout.linkSize(1, this.certificateTextField, this.showActiveCertificateButton);
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.certificatePanel, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.certificatePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        }
        return this.certificatePanel;
    }

    private static void showKeyStoreCertError(String errorMessage) {
        OptionsCertificatePanel.showCertError("options.cert.error.accesskeystore", errorMessage);
    }

    private static void showCertError(String i18nKeyBaseMessage, String errorMessage) {
        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString(i18nKeyBaseMessage), errorMessage}, Constant.messages.getString("options.cert.error"), 0);
    }

    private void keyStoreListSelectionChanged() {
        int keystore = this.keyStoreList.getSelectedIndex();
        try {
            this.aliasTableModel.setKeystore(keystore);
        }
        catch (Exception e) {
            OptionsCertificatePanel.showKeyStoreCertError(e.toString());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void showActiveCertificateButtonActionPerformed(ActionEvent evt) {
        Certificate cert = this.contextManager.getDefaultCertificate();
        if (cert != null) {
            this.showCertificate(cert);
        }
    }

    private void addPkcs11ButtonActionPerformed(ActionEvent evt) {
        String name = null;
        try {
            int indexSelectedDriver = this.driverComboBox.getSelectedIndex();
            name = this.driverConfig.getNames().get(indexSelectedDriver);
            if (name.equals("")) {
                return;
            }
            String library = this.driverConfig.getPaths().get(indexSelectedDriver);
            if (library.equals("")) {
                return;
            }
            int slot = this.driverConfig.getSlots().get(indexSelectedDriver);
            if (slot < 0) {
                return;
            }
            int slotListIndex = this.driverConfig.getSlotIndexes().get(indexSelectedDriver);
            if (slotListIndex < 0) {
                return;
            }
            String kspass = new String(this.pkcs11PasswordField.getPassword());
            if (kspass.equals("")) {
                kspass = null;
            }
            PKCS11Configuration.PCKS11ConfigurationBuilder confBuilder = PKCS11Configuration.builder();
            confBuilder.setName(name).setLibrary(library);
            if (this.usePkcs11ExperimentalSliSupportCheckBox.isSelected()) {
                confBuilder.setSlotListIndex(slotListIndex);
            } else {
                confBuilder.setSlotId(slot);
            }
            int ksIndex = this.contextManager.initPKCS11(confBuilder.build(), kspass);
            if (ksIndex == -1) {
                logger.error("The required PKCS#11 provider is not available (sun.security.pkcs11.SunPKCS11 or com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl).");
                this.showErrorMessageSunPkcs11ProviderNotAvailable();
                return;
            }
            login_attempts = 0;
            this.keyStoreListModel.insertElementAt(this.contextManager.getKeyStoreDescription(ksIndex), ksIndex);
            this.retry = true;
            this.certificatejTabbedPane.setSelectedIndex(0);
            this.activateFirstOnlyAliasOfKeyStore(ksIndex);
            this.driverComboBox.setSelectedIndex(-1);
            this.pkcs11PasswordField.setText("");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProviderException) {
                if ("Error parsing configuration".equals(e.getCause().getMessage())) {
                    this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(false, name, e);
                } else if ("Initialization failed".equals(e.getCause().getMessage())) {
                    if (this.retry) {
                        this.retry = false;
                        this.addPkcs11ButtonActionPerformed(evt);
                    } else {
                        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.pkcs11")}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                        this.retry = true;
                        logger.warn("Couldn't add key from {}", (Object)name, (Object)e);
                    }
                } else {
                    this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(false, name, e);
                }
            } else {
                this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(false, name, e);
            }
        }
        catch (IOException e) {
            if (e.getMessage().equals("load failed") && e.getCause().getClass().getName().equals("javax.security.auth.login.FailedLoginException")) {
                String attempts = " (" + ++login_attempts + "/3) ";
                if (login_attempts == 2) {
                    JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.wrongpassword"), Constant.messages.getString("options.cert.error.wrongpasswordlast"), attempts}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                    logger.warn("PKCS#11: Incorrect PIN or password {}: {} *LAST TRY BEFORE BLOCKING*", (Object)attempts, (Object)name);
                } else {
                    JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.wrongpassword"), attempts}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                    logger.warn("PKCS#11: Incorrect PIN or password {}:{}", (Object)attempts, (Object)name);
                }
            } else {
                this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(false, name, e);
            }
        }
        catch (KeyStoreException e) {
            this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(false, name, e);
        }
        catch (Exception e) {
            this.logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(true, name, e);
        }
    }

    private void activateFirstOnlyAliasOfKeyStore(int ksIndex) {
        if (ksIndex < 0 || ksIndex >= this.keyStoreList.getModel().getSize()) {
            return;
        }
        this.keyStoreList.setSelectedIndex(ksIndex);
        if (this.aliasTable.getRowCount() != 0) {
            this.aliasTable.setRowSelectionInterval(0, 0);
            if (this.aliasTable.getRowCount() == 1 && !this.isCertActive()) {
                this.setActiveAction();
            }
        }
    }

    private boolean isCertActive() {
        String currentKey = this.contextManager.getDefaultKey();
        return currentKey != null && !currentKey.isEmpty();
    }

    private void showErrorMessageSunPkcs11ProviderNotAvailable() {
        String sunReference = Constant.messages.getString("options.cert.error.pkcs11notavailable.sun.hyperlink");
        String ibmReference = Constant.messages.getString("options.cert.error.pkcs11notavailable.ibm.hyperlink");
        Object[] hyperlinks = new Object[2];
        try {
            JXHyperlink hyperlinkLabel = new JXHyperlink();
            hyperlinkLabel.setURI(URI.create(sunReference));
            hyperlinkLabel.setText(Constant.messages.getString("options.cert.error.pkcs11notavailable.sun.hyperlink.text"));
            hyperlinks[0] = hyperlinkLabel;
            hyperlinkLabel = new JXHyperlink();
            hyperlinkLabel.setURI(URI.create(ibmReference));
            hyperlinkLabel.setText(Constant.messages.getString("options.cert.error.pkcs11notavailable.ibm.hyperlink.text"));
            hyperlinks[1] = hyperlinkLabel;
        }
        catch (UnsupportedOperationException e) {
            hyperlinks[0] = sunReference;
            hyperlinks[1] = ibmReference;
        }
        JOptionPane.showMessageDialog(null, new Object[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.pkcs11notavailable"), hyperlinks}, Constant.messages.getString("options.cert.label.client.cert"), 0);
    }

    private void logAndShowGenericErrorMessagePkcs11CouldNotBeAdded(boolean isErrorLevel, String name, Exception e) {
        if (this.pkcs11PasswordField.getPassword().length == 0) {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.password.blank")}, Constant.messages.getString("options.cert.label.client.cert"), 0);
        } else {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.password")}, Constant.messages.getString("options.cert.label.client.cert"), 0);
            if (isErrorLevel) {
                logger.error("Couldn't add key from {}", (Object)name, (Object)e);
            } else {
                logger.warn("Couldn't add key from {}", (Object)name, (Object)e);
            }
        }
    }

    private void driverButtonActionPerformed(ActionEvent evt) {
        new JDialog((Frame)new DriversView(this.driverConfig), true);
    }

    private void addPkcs12ButtonActionPerformed(ActionEvent evt) {
        int ksIndex;
        if (this.fileTextField.getText().equals("")) {
            return;
        }
        String kspass = new String(this.pkcs12PasswordField.getPassword());
        if (kspass.equals("")) {
            OptionsCertificatePanel.showCertError("options.cert.error.pkcs12nopass", Constant.messages.getString("options.cert.error.usepassfile"));
            return;
        }
        try {
            ksIndex = this.contextManager.loadPKCS12Certificate(this.fileTextField.getText(), kspass);
            this.keyStoreListModel.insertElementAt(this.contextManager.getKeyStoreDescription(ksIndex), ksIndex);
        }
        catch (Exception e) {
            OptionsCertificatePanel.showKeyStoreCertError(Constant.messages.getString("options.cert.error.password"));
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.certificatejTabbedPane.setSelectedIndex(0);
        this.activateFirstOnlyAliasOfKeyStore(ksIndex);
        this.fileTextField.setText("");
        this.pkcs12PasswordField.setText("");
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter(Constant.messages.getString("options.cert.label.client.cert") + " (*.p12, *.pfx)", "p12", "pfx"));
        int state = fc.showOpenDialog(null);
        if (state == 0) {
            this.fileTextField.setText(fc.getSelectedFile().toString());
        }
    }

    private void showAliasButtonActionPerformed(ActionEvent evt) {
        int alias;
        Certificate cert;
        int keystore = this.keyStoreList.getSelectedIndex();
        if (keystore >= 0 && (cert = this.contextManager.getCertificate(keystore, alias = this.aliasTable.getSelectedRow())) != null) {
            this.showCertificate(cert);
        }
    }

    private void showCertificate(Certificate cert) {
        if (cert != null) {
            new CertificateView(cert.toString());
        }
    }

    private void setActiveButtonActionPerformed(ActionEvent evt) {
        this.setActiveAction();
    }

    private void setActiveAction() {
        int ks = this.keyStoreList.getSelectedIndex();
        int alias = this.aliasTable.getSelectedRow();
        if (ks > -1 && alias > -1) {
            if (!this.contextManager.isKeyUnlocked(ks, alias)) {
                try {
                    String password;
                    if (!this.contextManager.unlockKeyWithDefaultPassword(ks, alias) && !this.contextManager.unlockKey(ks, alias, password = this.getPassword())) {
                        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.accesskeystore")}, Constant.messages.getString("options.cert.error"), 0);
                    }
                }
                catch (Exception e) {
                    OptionsCertificatePanel.showKeyStoreCertError(e.toString());
                }
            }
            Certificate cert = this.contextManager.getCertificate(ks, alias);
            try {
                this.contextManager.getFingerPrint(cert);
            }
            catch (KeyStoreException kse) {
                OptionsCertificatePanel.showCertError("options.cert.error.fingerprint", kse.toString());
            }
            try {
                this.contextManager.setDefaultKey(ks, alias);
                OptionsParamCertificate certParam = Model.getSingleton().getOptionsParam().getCertificateParam();
                certParam.setActiveCertificate();
            }
            catch (KeyStoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.certificateTextField.setText(this.contextManager.getDefaultKey());
        }
    }

    public String getPassword() {
        JPasswordField askPasswordField = new JPasswordField();
        int result = JOptionPane.showConfirmDialog(this, askPasswordField, Constant.messages.getString("options.cert.label.enterpassword"), 2);
        if (result == 0) {
            return new String(askPasswordField.getPassword());
        }
        return null;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int index = this.keyStoreList.getSelectedIndex();
        if (index >= 0) {
            boolean isDefaultKeyStore = this.contextManager.removeKeyStore(index);
            if (isDefaultKeyStore) {
                this.certificateTextField.setText("");
            }
            this.keyStoreListModel.removeElementAt(this.keyStoreList.getSelectedIndex());
            this.aliasTableModel.removeKeystore();
        }
    }

    private void useClientCertificateCheckBoxActionPerformed(ActionEvent evt) {
        this.certificatejTabbedPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.keyStoreScrollPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.keyStoreList.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.aliasScrollPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.aliasTable.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.deleteButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.setActiveButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.showAliasButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.fileTextField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.browseButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.pkcs12PasswordField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.addPkcs12Button.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.driverComboBox.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.driverButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.pkcs11PasswordField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.addPkcs11Button.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.usePkcs11ExperimentalSliSupportCheckBox.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.usePkcs11ExperimentalSliSupportCheckBox.setSelected(Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().isExperimentalSliSupportEnabled());
        this.certificateTextField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.showActiveCertificateButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
    }

    private void usePkcs11ExperimentalSliSupportCheckBoxActionPerformed(ActionEvent evt) {
        Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().setSlotListIndexSupport(this.usePkcs11ExperimentalSliSupportCheckBox.isSelected());
    }

    private OptionsCertificatePanel getContentPane() {
        return this;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        OptionsParamCertificate certParam = options.getCertificateParam();
        if (this.overrideEnableClientCertificate) {
            certParam.setEnableCertificate(true);
            this.overrideEnableClientCertificate = false;
        }
        this.keyStoreListModel.clear();
        for (int i = 0; i < this.contextManager.getKeyStoreCount(); ++i) {
            this.keyStoreListModel.addElement(this.contextManager.getKeyStoreDescription(i));
        }
        Certificate cert = this.contextManager.getDefaultCertificate();
        if (cert != null) {
            this.certificateTextField.setText(cert.toString());
        }
        this.useClientCertificateCheckBox.setSelected(certParam.isUseClientCert());
        this.useClientCertificateCheckBoxActionPerformed(null);
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        OptionsParamCertificate certParam = options.getCertificateParam();
        certParam.setEnableCertificate(this.useClientCertificateCheckBox.isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.certificate";
    }
}

