/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import com.stackhawk.hste.utils.FontUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.SSLConnector;

@Deprecated
public class SecurityProtocolsPanel
extends JPanel {
    private static final long serialVersionUID = 5096843444189699353L;
    private Map<String, JCheckBox> checkBoxesSslTlsProtocols;
    private boolean supportedSecurityProtocolsInitialised;

    public SecurityProtocolsPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("generic.options.panel.security.protocols.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.checkBoxesSslTlsProtocols = new HashMap<String, JCheckBox>();
        JCheckBox checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.ssl2hello.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("SSLv2Hello", checkBox);
        this.add((Component)checkBox, gbc);
        checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.ssl3.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("SSLv3", checkBox);
        this.add((Component)checkBox, gbc);
        checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1", checkBox);
        this.add((Component)checkBox, gbc);
        checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.1.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1.1", checkBox);
        this.add((Component)checkBox, gbc);
        checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.2.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1.2", checkBox);
        this.add((Component)checkBox, gbc);
        checkBox = new JCheckBox(Constant.messages.getString("generic.options.panel.security.protocols.tlsv1.3.label"));
        checkBox.setEnabled(false);
        this.checkBoxesSslTlsProtocols.put("TLSv1.3", checkBox);
        this.add((Component)checkBox, gbc);
    }

    public void setSecurityProtocolsEnabled(String[] selectedProtocols) {
        if (!this.supportedSecurityProtocolsInitialised) {
            String[] protocols;
            for (String protocol : protocols = SSLConnector.getSupportedProtocols()) {
                JCheckBox checkBox = this.checkBoxesSslTlsProtocols.get(protocol);
                if (checkBox == null) continue;
                checkBox.setEnabled(true);
            }
            String toolTip = null;
            for (JCheckBox checkBox : this.checkBoxesSslTlsProtocols.values()) {
                if (checkBox.isEnabled()) continue;
                if (toolTip == null) {
                    toolTip = Constant.messages.getString("generic.options.panel.security.protocols.protocol.not.supported.tooltip");
                }
                checkBox.setToolTipText(toolTip);
            }
            this.supportedSecurityProtocolsInitialised = true;
        }
        for (JCheckBox checkBox : this.checkBoxesSslTlsProtocols.values()) {
            checkBox.setSelected(false);
        }
        if (selectedProtocols != null) {
            for (String protocol : selectedProtocols) {
                JCheckBox checkBox = this.checkBoxesSslTlsProtocols.get(protocol);
                if (checkBox == null || !checkBox.isEnabled()) continue;
                checkBox.setSelected(true);
            }
        }
    }

    public void validateSecurityProtocols() {
        int protocolsSelected = 0;
        JComponent checkBoxEnabledProtocol = null;
        for (Map.Entry<String, JCheckBox> entry : this.checkBoxesSslTlsProtocols.entrySet()) {
            JCheckBox checkBox = entry.getValue();
            if (!checkBox.isEnabled()) continue;
            if (checkBoxEnabledProtocol == null) {
                checkBoxEnabledProtocol = checkBox;
            }
            if (!checkBox.isSelected() || ++protocolsSelected <= 1) continue;
            break;
        }
        if (checkBoxEnabledProtocol != null) {
            if (protocolsSelected == 0) {
                checkBoxEnabledProtocol.requestFocusInWindow();
                throw new IllegalArgumentException(Constant.messages.getString("generic.options.panel.security.protocols.error.no.protocols.selected"));
            }
            if (protocolsSelected == 1 && this.checkBoxesSslTlsProtocols.get("SSLv2Hello").isSelected()) {
                checkBoxEnabledProtocol.requestFocusInWindow();
                throw new IllegalArgumentException(Constant.messages.getString("generic.options.panel.security.protocols.error.just.sslv2hello.selected"));
            }
        }
    }

    public String[] getSelectedProtocols() {
        int countSelectedProtocols = 0;
        String[] selectedProtocols = new String[this.checkBoxesSslTlsProtocols.values().size()];
        for (Map.Entry<String, JCheckBox> entry : this.checkBoxesSslTlsProtocols.entrySet()) {
            JCheckBox checkBox = entry.getValue();
            if (!checkBox.isEnabled() || !checkBox.isSelected()) continue;
            selectedProtocols[countSelectedProtocols] = entry.getKey();
            ++countSelectedProtocols;
        }
        return Arrays.copyOf(selectedProtocols, countSelectedProtocols);
    }
}

