/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import com.stackhawk.hste.network.HttpRequestConfig;
import com.stackhawk.hste.network.HttpSenderContext;
import com.stackhawk.hste.network.HttpSenderImpl;
import com.stackhawk.hste.network.HttpSenderListener;
import com.stackhawk.hste.users.User;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSenderContextParos;
import org.parosproxy.paros.network.HttpSenderParos;
import org.parosproxy.paros.network.SSLConnector;

public class HttpSender {
    public static final int PROXY_INITIATOR = 1;
    public static final int ACTIVE_SCANNER_INITIATOR = 2;
    public static final int SPIDER_INITIATOR = 3;
    public static final int FUZZER_INITIATOR = 4;
    public static final int AUTHENTICATION_INITIATOR = 5;
    public static final int MANUAL_REQUEST_INITIATOR = 6;
    @Deprecated(since="2.13.0")
    public static final int CHECK_FOR_UPDATES_INITIATOR = 7;
    public static final int BEAN_SHELL_INITIATOR = 8;
    public static final int ACCESS_CONTROL_SCANNER_INITIATOR = 9;
    public static final int AJAX_SPIDER_INITIATOR = 10;
    public static final int FORCED_BROWSE_INITIATOR = 11;
    public static final int TOKEN_GENERATOR_INITIATOR = 12;
    public static final int WEB_SOCKET_INITIATOR = 13;
    public static final int AUTHENTICATION_HELPER_INITIATOR = 14;
    public static final int AUTHENTICATION_POLL_INITIATOR = 15;
    public static final int OAST_INITIATOR = 16;
    public static final int PARAM_DIGGER_INITIATOR = 17;
    private static final HttpRequestConfig NO_REDIRECTS = HttpRequestConfig.builder().build();
    private static final HttpRequestConfig FOLLOW_REDIRECTS = HttpRequestConfig.builder().setFollowRedirects(true).build();
    private static final HttpSenderParos PAROS_IMPL = new HttpSenderParos();
    private static HttpSenderImpl impl = PAROS_IMPL;
    private static Object implState;
    private HttpSenderContext ctx;
    private final int initiator;

    public static <T extends HttpSenderContext> void setImpl(HttpSenderImpl<T> impl) {
        if (HttpSender.impl != PAROS_IMPL) {
            implState = HttpSender.impl.saveState();
        }
        HttpSenderImpl<HttpSenderContextParos> httpSenderImpl = HttpSender.impl = impl == null ? PAROS_IMPL : impl;
        if (HttpSender.impl != PAROS_IMPL) {
            HttpSender.impl.restoreState(implState);
            implState = null;
        }
    }

    @Deprecated
    public HttpSender(ConnectionParam connectionParam, boolean useGlobalState, int initiator) {
        this(useGlobalState, initiator);
    }

    public HttpSender(int initiator) {
        this(true, initiator);
    }

    private HttpSender(boolean useGlobalState, int initiator) {
        this.initiator = initiator;
        Object createdCtx = impl.createContext(this, initiator);
        if (impl.getContext(this) == null) {
            this.ctx = createdCtx;
        }
        this.setUseGlobalState(useGlobalState);
        this.setUseCookies(true);
    }

    private HttpSenderContext getContext() {
        if (this.ctx != null) {
            return this.ctx;
        }
        return impl.getContext(this);
    }

    @Deprecated
    public static SSLConnector getSSLConnector() {
        return PAROS_IMPL.getSslConnector();
    }

    public void setUseGlobalState(boolean enableGlobalState) {
        this.getContext().setUseGlobalState(enableGlobalState);
    }

    public boolean isGlobalStateEnabled() {
        return impl.isGlobalStateEnabled();
    }

    public void setUseCookies(boolean shouldUseCookies) {
        this.getContext().setUseCookies(shouldUseCookies);
    }

    @Deprecated
    public int executeMethod(HttpMethod method, HttpState state) throws IOException {
        HttpSenderContext ctxTemp = this.getContext();
        if (!(ctxTemp instanceof HttpSenderContextParos)) {
            ctxTemp = PAROS_IMPL.createContext(this, this.initiator);
        }
        return PAROS_IMPL.executeMethodImpl((HttpSenderContextParos)ctxTemp, method, state);
    }

    @Deprecated
    public void shutdown() {
    }

    public void sendAndReceive(HttpMessage message, Path file) throws IOException {
        this.sendAndReceive(message, null, file);
    }

    public void sendAndReceive(HttpMessage message, HttpRequestConfig requestConfig, Path file) throws IOException {
        this.sendImpl(requestConfig, message, file);
    }

    public void sendAndReceive(HttpMessage msg) throws IOException {
        this.sendImpl(null, msg, null);
    }

    public void sendAndReceive(HttpMessage msg, boolean isFollowRedirect) throws IOException {
        this.sendImpl(isFollowRedirect ? FOLLOW_REDIRECTS : NO_REDIRECTS, msg, null);
    }

    public User getUser(HttpMessage msg) {
        return this.getContext().getUser(msg);
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.getContext().setFollowRedirects(followRedirect);
    }

    @Deprecated
    public static String getUserAgent() {
        return "";
    }

    @Deprecated
    public static void setUserAgent(String userAgent) {
    }

    public static void addListener(HttpSenderListener listener) {
        impl.addListener(listener);
    }

    public static void removeListener(HttpSenderListener listener) {
        impl.removeListener(listener);
    }

    public void setUser(User user) {
        this.getContext().setUser(user);
    }

    @Deprecated
    public HttpClient getClient() {
        return PAROS_IMPL.getClient();
    }

    public void setRemoveUserDefinedAuthHeaders(boolean removeHeaders) {
        this.getContext().setRemoveUserDefinedAuthHeaders(removeHeaders);
    }

    public void setMaxRetriesOnIOError(int retries) {
        this.getContext().setMaxRetriesOnIoError(retries);
    }

    public void setMaxRedirects(int maxRedirects) {
        this.getContext().setMaxRedirects(maxRedirects);
    }

    @Deprecated
    public void setAllowCircularRedirects(boolean allow) {
    }

    public void sendAndReceive(HttpMessage message, HttpRequestConfig requestConfig) throws IOException {
        this.sendImpl(requestConfig, message, null);
    }

    private void sendImpl(HttpRequestConfig requestConfig, HttpMessage message, Path file) throws IOException {
        if (this.ctx == null) {
            impl.sendAndReceive(this, requestConfig, message, file);
        } else {
            impl.sendAndReceive(this.ctx, requestConfig, message, file);
        }
    }
}

