/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import com.stackhawk.hste.view.AboutDialog;
import com.stackhawk.hste.view.HsteMenuItem;
import com.stackhawk.hste.view.HsteSortedMenu;
import com.stackhawk.hste.view.HsteSupportDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;

public class MainMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 8580116506279095244L;
    private static final Logger LOGGER = LogManager.getLogger(MainMenuBar.class);
    private JMenu menuEdit = null;
    private JMenu menuTools = null;
    private JMenu menuView = null;
    private JMenu menuImport = null;
    private HsteMenuItem menuToolsOptions = null;
    private JMenu menuFile = null;
    private JMenu menuFileOpenRecent;
    private HsteMenuItem menuFileNewSession = null;
    private HsteMenuItem menuFileOpen = null;
    private HsteMenuItem menuFileSaveAs = null;
    private HsteMenuItem menuFileSnapshot = null;
    private HsteMenuItem menuFileContextExport = null;
    private HsteMenuItem menuFileContextImport = null;
    private HsteMenuItem menuFileExit = null;
    private HsteMenuItem menuFileExitAndDelete = null;
    private HsteMenuItem menuFileProperties = null;
    private JMenu menuHelp = null;
    private HsteMenuItem menuHelpAbout = null;
    private HsteMenuItem menuHelpSupport = null;
    private JMenu menuAnalyse = null;
    private JMenu menuHsteMode = null;
    private ButtonGroup menuHsteModeGroup = null;
    private Map<Control.Mode, JRadioButtonMenuItem> menuHsteModeMap = null;
    private JMenu menuReport = null;
    private JMenu menuOnline = null;

    public MainMenuBar() {
        this.initialize();
    }

    private void initialize() {
        this.add(this.getMenuFile());
        this.add(this.getMenuEdit());
        this.add(this.getMenuView());
        this.add(this.getMenuAnalyse());
        this.add(this.getMenuReport());
        this.add(this.getMenuTools());
        this.add(this.getMenuImport());
        this.add(this.getMenuOnline());
        this.add(this.getMenuHelp());
    }

    public JMenu getMenuEdit() {
        if (this.menuEdit == null) {
            this.menuEdit = new JMenu();
            this.menuEdit.setText(Constant.messages.getString("menu.edit"));
            this.menuEdit.setMnemonic(Constant.messages.getChar("menu.edit.mnemonic"));
            this.menuEdit.add(this.getMenuEditZAPMode());
            this.menuEdit.addSeparator();
        }
        return this.menuEdit;
    }

    private JMenuItem getMenuEditZAPMode() {
        if (this.menuHsteMode == null) {
            this.menuHsteMode = new JMenu(Constant.messages.getString("menu.edit.zapmode"));
            this.menuHsteModeGroup = new ButtonGroup();
            this.menuHsteModeMap = new HashMap<Control.Mode, JRadioButtonMenuItem>();
            for (Control.Mode modeType : Control.Mode.values()) {
                JRadioButtonMenuItem newButton = this.addZAPModeMenuItem(modeType);
                this.menuHsteModeGroup.add(newButton);
                this.menuHsteMode.add(newButton);
                this.menuHsteModeMap.put(modeType, newButton);
            }
            Control.Mode mode = Control.Mode.valueOf(Model.getSingleton().getOptionsParam().getViewParam().getMode());
            this.setMode(mode);
        }
        return this.menuHsteMode;
    }

    private JRadioButtonMenuItem addZAPModeMenuItem(final Control.Mode modeType) {
        JRadioButtonMenuItem modeItem = new JRadioButtonMenuItem(Constant.messages.getString("view.toolbar.mode." + modeType.name() + ".select"));
        modeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Control.getSingleton().setMode(modeType);
                View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(modeType);
            }
        });
        return modeItem;
    }

    public void setMode(final Control.Mode mode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenuBar.this.menuHsteModeMap.get((Object)mode).setSelected(true);
            }
        });
    }

    public JMenu getMenuTools() {
        if (this.menuTools == null) {
            this.menuTools = new JMenu();
            this.menuTools.setText(Constant.messages.getString("menu.tools"));
            this.menuTools.setMnemonic(Constant.messages.getChar("menu.tools.mnemonic"));
            this.menuTools.addSeparator();
            this.menuTools.add(this.getMenuToolsOptions());
        }
        return this.menuTools;
    }

    public JMenu getMenuView() {
        if (this.menuView == null) {
            this.menuView = new JMenu();
            this.menuView.setText(Constant.messages.getString("menu.view"));
            this.menuView.setMnemonic(Constant.messages.getChar("menu.view.mnemonic"));
        }
        return this.menuView;
    }

    public JMenu getMenuImport() {
        if (this.menuImport == null) {
            this.menuImport = new HsteSortedMenu();
            this.menuImport.setText(Constant.messages.getString("menu.import"));
            this.menuImport.setMnemonic(Constant.messages.getChar("menu.import.mnemonic"));
        }
        return this.menuImport;
    }

    private HsteMenuItem getMenuToolsOptions() {
        if (this.menuToolsOptions == null) {
            this.menuToolsOptions = new HsteMenuItem("menu.tools.options", View.getSingleton().getMenuShortcutKeyStroke(79, 512, false));
            this.menuToolsOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuToolsControl().options();
                }
            });
        }
        return this.menuToolsOptions;
    }

    public JMenu getMenuFile() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu();
            this.menuFile.setText(Constant.messages.getString("menu.file"));
            this.menuFile.setMnemonic(Constant.messages.getChar("menu.file.mnemonic"));
            this.menuFile.add(this.getMenuFileNewSession());
            this.menuFile.add(this.getMenuFileOpen());
            this.menuFile.add(this.getMenuFileOpenRecent());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileSaveAs());
            this.menuFile.add(this.getMenuFileSnapshot());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileProperties());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuContextImport());
            this.menuFile.add(this.getMenuContextExport());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileExitAndDelete());
            this.menuFile.add(this.getMenuFileExit());
        }
        return this.menuFile;
    }

    private JMenuItem getMenuFileNewSession() {
        if (this.menuFileNewSession == null) {
            this.menuFileNewSession = new HsteMenuItem("menu.file.newSession", View.getSingleton().getMenuShortcutKeyStroke(78, 0, false));
            this.menuFileNewSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MainMenuBar.this.getMenuFileControl().newSession(true);
                    }
                    catch (Exception e1) {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                        LOGGER.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.menuFileNewSession;
    }

    private JMenuItem getMenuFileOpen() {
        if (this.menuFileOpen == null) {
            this.menuFileOpen = new HsteMenuItem("menu.file.openSession", View.getSingleton().getMenuShortcutKeyStroke(79, 0, false));
            this.menuFileOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().openSession();
                }
            });
        }
        return this.menuFileOpen;
    }

    private JMenu getMenuFileOpenRecent() {
        if (this.menuFileOpenRecent == null) {
            this.menuFileOpenRecent = new JMenu();
            this.menuFileOpenRecent.setText(Constant.messages.getString("menu.file.openRecent"));
            this.refreshMenuFileOpenRecent();
        }
        return this.menuFileOpenRecent;
    }

    private void refreshMenuFileOpenRecent() {
        this.menuFileOpenRecent.removeAll();
        for (String session : Model.getSingleton().getOptionsParam().getViewParam().getRecentSessions()) {
            JMenuItem menuItem = new JMenuItem(session);
            menuItem.addActionListener(e -> this.getMenuFileControl().openSession(session));
            this.menuFileOpenRecent.add(menuItem);
        }
        this.menuFileOpenRecent.setEnabled(this.menuFileOpenRecent.getMenuComponentCount() != 0);
    }

    private JMenuItem getMenuFileSaveAs() {
        if (this.menuFileSaveAs == null) {
            this.menuFileSaveAs = new HsteMenuItem("menu.file.persistSession");
            this.menuFileSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Model.getSingleton().getSession().isNewState()) {
                        MainMenuBar.this.getMenuFileControl().saveAsSession();
                    } else {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionExists.error"));
                    }
                }
            });
        }
        return this.menuFileSaveAs;
    }

    private JMenuItem getMenuFileSnapshot() {
        if (this.menuFileSnapshot == null) {
            this.menuFileSnapshot = new HsteMenuItem("menu.file.snapshotSession");
            this.menuFileSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Model.getSingleton().getSession().isNewState()) {
                        MainMenuBar.this.getMenuFileControl().saveSnapshot();
                    } else {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.snapshotSession.error"));
                    }
                }
            });
            this.toggleSnapshotState(false);
        }
        return this.menuFileSnapshot;
    }

    private JMenuItem getMenuFileExit() {
        if (this.menuFileExit == null) {
            this.menuFileExit = new HsteMenuItem("menu.file.exit");
            this.menuFileExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().exit();
                }
            });
        }
        return this.menuFileExit;
    }

    private JMenuItem getMenuFileExitAndDelete() {
        if (this.menuFileExitAndDelete == null) {
            this.menuFileExitAndDelete = new HsteMenuItem("menu.file.exit.delete");
            this.menuFileExitAndDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int ans = View.getSingleton().showConfirmDialog(Constant.messages.getString("menu.file.exit.delete.warning"));
                    if (ans == 0) {
                        Control.getSingleton().exitAndDeleteSession(Model.getSingleton().getSession().getFileName());
                    }
                }
            });
        }
        return this.menuFileExitAndDelete;
    }

    public MenuFileControl getMenuFileControl() {
        return Control.getSingleton().getMenuFileControl();
    }

    private MenuToolsControl getMenuToolsControl() {
        return Control.getSingleton().getMenuToolsControl();
    }

    private HsteMenuItem getMenuFileProperties() {
        if (this.menuFileProperties == null) {
            this.menuFileProperties = new HsteMenuItem("menu.file.properties", View.getSingleton().getMenuShortcutKeyStroke(80, 512, false));
            this.menuFileProperties.setText(Constant.messages.getString("menu.file.properties"));
            this.menuFileProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().properties();
                }
            });
        }
        return this.menuFileProperties;
    }

    private HsteMenuItem getMenuContextImport() {
        if (this.menuFileContextImport == null) {
            this.menuFileContextImport = new HsteMenuItem("menu.file.context.import");
            this.menuFileContextImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().importContext();
                }
            });
        }
        return this.menuFileContextImport;
    }

    private HsteMenuItem getMenuContextExport() {
        if (this.menuFileContextExport == null) {
            this.menuFileContextExport = new HsteMenuItem("menu.file.context.export");
            this.menuFileContextExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().exportContext();
                }
            });
        }
        return this.menuFileContextExport;
    }

    public JMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new JMenu();
            this.menuHelp.setText(Constant.messages.getString("menu.help"));
            this.menuHelp.setMnemonic(Constant.messages.getChar("menu.help.mnemonic"));
            this.menuHelp.add(this.getMenuHelpAbout());
            this.menuHelp.add(this.getMenuHelpSupport());
        }
        return this.menuHelp;
    }

    public JMenu getMenuOnline() {
        if (this.menuOnline == null) {
            this.menuOnline = new JMenu();
            this.menuOnline.setText(Constant.messages.getString("menu.online"));
            this.menuOnline.setMnemonic(Constant.messages.getChar("menu.online.mnemonic"));
        }
        return this.menuOnline;
    }

    public JMenu getMenuReport() {
        if (this.menuReport == null) {
            this.menuReport = new JMenu();
            this.menuReport.setText(Constant.messages.getString("menu.report"));
            this.menuReport.setMnemonic(Constant.messages.getChar("menu.report.mnemonic"));
        }
        return this.menuReport;
    }

    private HsteMenuItem getMenuHelpAbout() {
        if (this.menuHelpAbout == null) {
            this.menuHelpAbout = new HsteMenuItem("menu.help.about");
            this.menuHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog dialog = new AboutDialog((Frame)View.getSingleton().getMainFrame(), true);
                    dialog.setVisible(true);
                }
            });
        }
        return this.menuHelpAbout;
    }

    private HsteMenuItem getMenuHelpSupport() {
        if (this.menuHelpSupport == null) {
            this.menuHelpSupport = new HsteMenuItem("menu.help.zap.support");
            this.menuHelpSupport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HsteSupportDialog zsd = new HsteSupportDialog((Frame)View.getSingleton().getMainFrame(), true);
                    zsd.setVisible(true);
                }
            });
        }
        return this.menuHelpSupport;
    }

    public JMenu getMenuAnalyse() {
        if (this.menuAnalyse == null) {
            this.menuAnalyse = new JMenu();
            this.menuAnalyse.setText(Constant.messages.getString("menu.analyse"));
            this.menuAnalyse.setMnemonic(Constant.messages.getChar("menu.analyse.mnemonic"));
        }
        return this.menuAnalyse;
    }

    public void sessionChanged(Session session) {
        if (session != null) {
            this.getMenuFileSaveAs().setEnabled(session.isNewState());
            this.toggleSnapshotState(!session.isNewState());
            this.refreshMenuFileOpenRecent();
        }
    }

    private void toggleSnapshotState(boolean enabled) {
        if (enabled) {
            this.menuFileSnapshot.setToolTipText("");
        } else {
            this.menuFileSnapshot.setToolTipText(Constant.messages.getString("menu.file.snapshotSession.disabled.tooltip"));
        }
        this.menuFileSnapshot.setEnabled(enabled);
    }
}

