/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import com.stackhawk.hste.extension.ExtensionPopupMenu;
import com.stackhawk.hste.extension.history.PopupMenuPurgeSites;
import com.stackhawk.hste.view.messagecontainer.MessageContainer;
import com.stackhawk.hste.view.popup.ExtensionPopupMenuComponent;
import com.stackhawk.hste.view.popup.PopupMenuUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;

public class MainPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3021348328961418293L;
    private List<JMenuItem> itemList = null;
    private PopupMenuPurgeSites popupMenuPurgeSites = null;
    Map<String, JMenu> superMenus = new HashMap<String, JMenu>();
    View view = null;
    private static final Logger LOGGER = LogManager.getLogger(MainPopupMenu.class);
    private MenuSelectionChangeListener menuSelectionChangeListener;
    private MenuElement[] pathSelectedMenu;

    public MainPopupMenu(View view) {
        this.initialize();
        this.view = view;
    }

    public MainPopupMenu(String arg0, View view) {
        super(arg0);
        this.view = view;
    }

    public MainPopupMenu(List<JMenuItem> itemList, View view) {
        this(view);
        this.itemList = itemList;
    }

    private void initialize() {
        this.add(this.getPopupMenuPurgeSites());
        this.menuSelectionChangeListener = new MenuSelectionChangeListener();
        this.addPopupMenuListener(new MenuSelectionListenerInstaller());
    }

    public void show(MessageContainer<?> invoker, int x, int y) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(invoker), x, y);
    }

    @Override
    public synchronized void show(Component invoker, int x, int y) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(invoker), x, y);
    }

    private synchronized void showImpl(PopupMenuUtils.PopupMenuInvokerWrapper invoker, int x, int y) {
        int i;
        for (i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            try {
                if (component == null || !(component instanceof ExtensionPopupMenuItem)) continue;
                ExtensionPopupMenuItem menuItem = (ExtensionPopupMenuItem)component;
                menuItem.setVisible(invoker.isEnable(menuItem));
                if (!Control.getSingleton().getMode().equals((Object)Control.Mode.safe) || menuItem.isSafe()) continue;
                menuItem.setEnabled(false);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        for (i = 0; i < this.itemList.size(); ++i) {
            JMenuItem menuItem = this.itemList.get(i);
            if (menuItem instanceof ExtensionPopupMenuItem) {
                this.handleMenuItem(invoker, (ExtensionPopupMenuItem)menuItem);
                continue;
            }
            if (!(menuItem instanceof ExtensionPopupMenu)) continue;
            ExtensionPopupMenu item = (ExtensionPopupMenu)menuItem;
            this.handleMenu(invoker, item);
        }
        PopupMenuUtils.removeTopAndBottomSeparators(this);
        if (PopupMenuUtils.isAtLeastOneChildComponentVisible(this)) {
            super.show(invoker.getComponent(), x, y);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            ExtensionPopupMenuComponent selectedMenuComponent = null;
            if (this.pathSelectedMenu != null) {
                MenuElement selectedMenuElement = this.pathSelectedMenu[this.pathSelectedMenu.length - 1];
                if (PopupMenuUtils.isExtensionPopupMenuComponent(selectedMenuElement)) {
                    selectedMenuComponent = (ExtensionPopupMenuComponent)((Object)selectedMenuElement);
                }
                this.pathSelectedMenu = null;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!PopupMenuUtils.isExtensionPopupMenuComponent(component)) continue;
                ((ExtensionPopupMenuComponent)((Object)component)).dismissed(selectedMenuComponent);
            }
        }
    }

    private void handleMenuItem(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvoker, ExtensionPopupMenuItem menuItem) {
        try {
            if (menuItem == ExtensionHookMenu.POPUP_MENU_SEPARATOR) {
                PopupMenuUtils.addSeparatorIfNeeded(this);
            } else if (popupMenuInvoker.isEnable(menuItem)) {
                if (menuItem.isSubMenu()) {
                    JMenu superMenu = this.getSuperMenu(menuItem.getParentMenuName(), menuItem.getParentMenuIndex());
                    if (menuItem.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(superMenu.getPopupMenu());
                    }
                    if (menuItem.isDummyItem()) {
                        superMenu.setEnabled(false);
                    } else {
                        superMenu.add(menuItem);
                        superMenu.setEnabled(true);
                    }
                    if (menuItem.succeedWithSeparator()) {
                        superMenu.addSeparator();
                    }
                } else {
                    if (menuItem.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(this);
                    }
                    this.addMenuItem(menuItem, menuItem.getMenuIndex());
                    if (menuItem.succeedWithSeparator()) {
                        this.addSeparator();
                    }
                }
            }
            if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !menuItem.isSafe()) {
                menuItem.setEnabled(false);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleMenu(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvoker, ExtensionPopupMenu menu) {
        try {
            if (popupMenuInvoker.isEnable(menu)) {
                if (menu.isSubMenu()) {
                    JMenu superMenu = this.getSuperMenu(menu.getParentMenuName(), menu.getParentMenuIndex());
                    if (menu.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(superMenu.getPopupMenu());
                    }
                    superMenu.add(menu);
                    if (menu.succeedWithSeparator()) {
                        superMenu.addSeparator();
                    }
                } else {
                    if (menu.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(this);
                    }
                    this.addMenuItem(menu, menu.getMenuIndex());
                    if (menu.succeedWithSeparator()) {
                        this.addSeparator();
                    }
                }
                if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !menu.isSafe()) {
                    menu.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private JMenu getSuperMenu(String name, int index) {
        JMenu superMenu = this.superMenus.get(name);
        if (superMenu == null) {
            superMenu = new ExtensionPopupMenu(name){
                private static final long serialVersionUID = 6825880451078204378L;

                @Override
                public boolean isEnableForComponent(Component invoker) {
                    return true;
                }
            };
            this.superMenus.put(name, superMenu);
            this.addMenuItem(superMenu, index);
        }
        return superMenu;
    }

    private void addMenuItem(JMenuItem menuItem, int index) {
        int correctIndex = index < 0 && index != -1 || index > this.getComponentCount() ? -1 : index;
        this.add((Component)menuItem, correctIndex);
    }

    private PopupMenuPurgeSites getPopupMenuPurgeSites() {
        if (this.popupMenuPurgeSites == null) {
            this.popupMenuPurgeSites = new PopupMenuPurgeSites();
        }
        return this.popupMenuPurgeSites;
    }

    public void addMenu(ExtensionPopupMenuItem menu) {
        this.itemList.add(menu);
    }

    public void removeMenu(ExtensionPopupMenuItem menu) {
        this.itemList.remove(menu);
    }

    public void addMenu(ExtensionPopupMenu menu) {
        this.itemList.add(menu);
    }

    public void removeMenu(ExtensionPopupMenu menu) {
        this.itemList.remove(menu);
    }

    private class MenuSelectionChangeListener
    implements ChangeListener {
        private MenuSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainPopupMenu.this.pathSelectedMenu = MenuSelectionManager.defaultManager().getSelectedPath();
        }
    }

    private class MenuSelectionListenerInstaller
    implements PopupMenuListener {
        private MenuSelectionListenerInstaller() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            MenuSelectionManager.defaultManager().addChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            MenuSelectionManager.defaultManager().removeChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            MainPopupMenu.this.pathSelectedMenu = null;
        }
    }
}

