/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import com.stackhawk.hste.model.Context;
import com.stackhawk.hste.view.AbstractContextPropertiesPanel;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;

public class SessionDialog
extends AbstractParamDialog {
    private static final long serialVersionUID = 2078860056416521552L;
    private Map<Integer, Context> uiContexts = new HashMap<Integer, Context>();
    private Session session;

    public SessionDialog() {
        this.initialize();
    }

    @Deprecated
    public SessionDialog(Frame parent, boolean modal, String title) throws HeadlessException {
        super((Window)parent, modal, title, "Session");
        this.initialize();
    }

    public SessionDialog(Frame parent, boolean modal, String title, String rootName) {
        super((Window)parent, modal, title, rootName);
        this.initialize();
    }

    private void initialize() {
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(650, 550);
        } else {
            this.pack();
        }
    }

    @Override
    public void addParamPanel(String[] parentParams, String name, AbstractParamPanel panel, boolean sort) {
        super.addParamPanel(parentParams, name, panel, sort);
        if (this.session != null) {
            if (panel instanceof AbstractContextPropertiesPanel) {
                this.initContextPanel((AbstractContextPropertiesPanel)panel);
            } else {
                panel.initParam(this.session);
            }
        }
    }

    @Override
    public void initParam(Object session) {
        super.initParam(session);
        this.session = (Session)session;
        for (AbstractParamPanel panel : super.getPanels()) {
            if (!(panel instanceof AbstractContextPropertiesPanel)) continue;
            this.initContextPanel((AbstractContextPropertiesPanel)panel);
        }
    }

    private void initContextPanel(AbstractContextPropertiesPanel contextPanel) {
        Context ctx = this.uiContexts.get(contextPanel.getContextId());
        if (ctx != null) {
            contextPanel.initContextData(this.session, ctx);
        }
    }

    @Override
    public void saveParam() throws Exception {
        super.saveParam();
        Model.getSingleton().getSession().saveAllContexts();
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (!show && this.session != null) {
            this.session = null;
            this.uiContexts.clear();
        }
    }

    public void recreateUISharedContexts(Session session) {
        this.uiContexts.clear();
        for (Context context : session.getContexts()) {
            Context uiContext = context.duplicate();
            this.uiContexts.put(context.getId(), uiContext);
        }
    }

    public void createUISharedContext(Context context) {
        if (this.session != null) {
            this.uiContexts.put(context.getId(), context.duplicate());
        }
    }

    public Context getUISharedContext(int contextId) {
        return this.uiContexts.get(contextId);
    }
}

