/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\u001a'\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001aV\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0000\u001aA\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00190\u001eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001f\u001a\u00a1\u0001\u0010 \u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2`\u0010%\u001a\\\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b($\u0012\u0004\u0012\u0002H\u00190&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(\u001a\u00a1\u0001\u0010)\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2`\u0010%\u001a\\\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b($\u0012\u0004\u0012\u0002H\u00190&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(\u001a\u00a1\u0001\u0010*\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2`\u0010%\u001a\\\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b\b\u0012\u0004\b\b($\u0012\u0004\u0012\u0002H\u00190&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(\u001aS\u0010+\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u00190,2\u0006\u0010-\u001a\u00020.2$\u0010/\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00190&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100\u001aA\u00101\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u00190,2\u0006\u0010-\u001a\u00020.2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H\u00190\u001eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00064"}, d2={"alphaInfo", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "componentInfoList", "", "c", "", "([Lcom/github/ajalt/colormath/ColorComponentInfo;)Ljava/util/List;", "polarComponentInfo", "name", "", "l", "", "r", "threeComponentInfo", "n1", "l1", "r1", "n2", "l2", "r2", "n3", "l3", "r3", "zeroOneComponentInfo", "adaptToThis", "T", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/WhitePointColorSpace;", "color", "convert", "Lkotlin/Function1;", "(Lcom/github/ajalt/colormath/WhitePointColorSpace;Lcom/github/ajalt/colormath/Color;Lkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "clamp3", "v1", "v2", "v3", "alpha", "copy", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "(Lcom/github/ajalt/colormath/Color;FFFFLkotlin/jvm/functions/Function4;)Lcom/github/ajalt/colormath/Color;", "clampLeadingHue", "clampTrailingHue", "doCreate", "Lcom/github/ajalt/colormath/ColorSpace;", "components", "", "init", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function4;)Lcom/github/ajalt/colormath/Color;", "withValidComps", "block", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "colormath"})
@SourceDebugExtension(value={"SMAP\nColorSpaceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,150:1\n15#1,5:151\n1#2:156\n1041#3,3:157\n1041#3,3:160\n*S KotlinDebug\n*F\n+ 1 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n26#1:151,5\n61#1:157,3\n70#1:160,3\n*E\n"})
public final class ColorSpaceUtilsKt {
    @NotNull
    private static final ColorComponentInfo alphaInfo = new ColorComponentInfo("alpha", false, 0.0f, 1.0f);

    @NotNull
    public static final <T extends Color> T withValidComps(@NotNull ColorSpace<T> $this$withValidComps, @NotNull float[] components, @NotNull Function1<? super float[], ? extends T> block) {
        Intrinsics.checkNotNullParameter($this$withValidComps, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withValidComps = false;
        int size = $this$withValidComps.getComponents().size();
        int n = size - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size - 1) + " or " + size;
            throw new IllegalArgumentException(string.toString());
        }
        return (T)((Color)block.invoke((Object)components));
    }

    @NotNull
    public static final <T extends Color> T doCreate(@NotNull ColorSpace<T> $this$doCreate, @NotNull float[] components, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> init) {
        float f;
        Intrinsics.checkNotNullParameter($this$doCreate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$doCreate = false;
        ColorSpace<T> $this$withValidComps$iv = $this$doCreate;
        boolean $i$f$withValidComps = false;
        int size$iv = $this$withValidComps$iv.getComponents().size();
        int n = size$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it = components;
        boolean bl = false;
        Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> function4 = init;
        Float f2 = Float.valueOf(components[0]);
        Float f3 = Float.valueOf(components[1]);
        Float f4 = Float.valueOf(components[2]);
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex((float[])fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            Float f5 = f4;
            Float f6 = f3;
            Float f7 = f2;
            Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> function42 = function4;
            boolean bl2 = false;
            float f8 = 1.0f;
            function4 = function42;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        return (T)((Color)function4.invoke((Object)f2, (Object)f3, (Object)f4, (Object)Float.valueOf(f)));
    }

    @NotNull
    public static final <T extends Color> T adaptToThis(@NotNull WhitePointColorSpace<T> $this$adaptToThis, @NotNull Color color, @NotNull Function1<? super Color, ? extends T> convert) {
        Intrinsics.checkNotNullParameter($this$adaptToThis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(convert, (String)"convert");
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        Object object = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        if (object == null || (object = object.getWhitePoint()) == null) {
            object = Illuminant.INSTANCE.getD65();
        }
        return (T)(Intrinsics.areEqual((Object)object, (Object)$this$adaptToThis.getWhitePoint()) ? (Color)convert.invoke((Object)color) : (Color)convert.invoke((Object)color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis.getWhitePoint()))));
    }

    @NotNull
    public static final List<ColorComponentInfo> componentInfoList(ColorComponentInfo ... c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)c);
        spreadBuilder.add((Object)alphaInfo);
        return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new ColorComponentInfo[spreadBuilder.size()]));
    }

    @NotNull
    public static final List<ColorComponentInfo> threeComponentInfo(@NotNull String n1, float l1, float r1, @NotNull String n2, float l2, float r2, @NotNull String n3, float l3, float r3) {
        Intrinsics.checkNotNullParameter((Object)n1, (String)"n1");
        Intrinsics.checkNotNullParameter((Object)n2, (String)"n2");
        Intrinsics.checkNotNullParameter((Object)n3, (String)"n3");
        ColorComponentInfo[] colorComponentInfoArray = new ColorComponentInfo[]{new ColorComponentInfo(n1, false, l1, r1), new ColorComponentInfo(n2, false, l2, r2), new ColorComponentInfo(n3, false, l3, r3)};
        return ColorSpaceUtilsKt.componentInfoList(colorComponentInfoArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> zeroOneComponentInfo(@NotNull String name) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List $this$zeroOneComponentInfo_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence $this$mapTo$iv = name;
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv.length(); ++i) {
            void it;
            char item$iv;
            char c = item$iv = $this$mapTo$iv.charAt(i);
            Collection collection = $this$zeroOneComponentInfo_u24lambda_u244;
            boolean bl2 = false;
            collection.add(new ColorComponentInfo(String.valueOf((char)it), false, 0.0f, 1.0f));
        }
        $this$zeroOneComponentInfo_u24lambda_u244.add(alphaInfo);
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> polarComponentInfo(@NotNull String name, float l, float r) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List $this$polarComponentInfo_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence $this$mapTo$iv = name;
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv.length(); ++i) {
            void it;
            char item$iv;
            char c = item$iv = $this$mapTo$iv.charAt(i);
            Collection collection = $this$polarComponentInfo_u24lambda_u246;
            boolean bl2 = false;
            collection.add(new ColorComponentInfo(String.valueOf((char)it), it == 72, it == 72 ? 0.0f : l, it == 72 ? 360.0f : r));
        }
        $this$polarComponentInfo_u24lambda_u246.add(alphaInfo);
        return CollectionsKt.build((List)list);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final <T extends Color> T clamp3(@NotNull T $this$clamp3, float v1, float v2, float v3, float alpha, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> copy) {
        Object object;
        Intrinsics.checkNotNullParameter($this$clamp3, (String)"<this>");
        Intrinsics.checkNotNullParameter(copy, (String)"copy");
        boolean $i$f$clamp3 = false;
        List<ColorComponentInfo> list = $this$clamp3.getSpace().getComponents();
        ColorComponentInfo c1 = list.get(0);
        ColorComponentInfo c2 = list.get(1);
        ColorComponentInfo c3 = list.get(2);
        float f = c1.getMin();
        boolean bl = v1 <= c1.getMax() ? f <= v1 : false;
        if (bl) {
            f = c2.getMin();
            boolean bl2 = v2 <= c2.getMax() ? f <= v2 : false;
            if (bl2) {
                f = c3.getMin();
                boolean bl3 = v3 <= c3.getMax() ? f <= v3 : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha ? alpha <= 1.0f : false;
                    if (bl4) {
                        object = $this$clamp3;
                        return object;
                    }
                }
            }
        }
        object = (Color)copy.invoke((Object)Float.valueOf(RangesKt.coerceIn((float)v1, (float)c1.getMin(), (float)c1.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)v2, (float)c2.getMin(), (float)c2.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)v3, (float)c3.getMin(), (float)c3.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)alpha, (float)0.0f, (float)1.0f)));
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final <T extends Color> T clampLeadingHue(@NotNull T $this$clampLeadingHue, float v1, float v2, float v3, float alpha, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> copy) {
        Object object;
        Intrinsics.checkNotNullParameter($this$clampLeadingHue, (String)"<this>");
        Intrinsics.checkNotNullParameter(copy, (String)"copy");
        boolean $i$f$clampLeadingHue = false;
        List<ColorComponentInfo> list = $this$clampLeadingHue.getSpace().getComponents();
        ColorComponentInfo c1 = list.get(0);
        ColorComponentInfo c2 = list.get(1);
        ColorComponentInfo c3 = list.get(2);
        float f = c1.getMin();
        boolean bl = v1 <= c1.getMax() ? f <= v1 : false;
        if (bl) {
            f = c2.getMin();
            boolean bl2 = v2 <= c2.getMax() ? f <= v2 : false;
            if (bl2) {
                f = c3.getMin();
                boolean bl3 = v3 <= c3.getMax() ? f <= v3 : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha ? alpha <= 1.0f : false;
                    if (bl4) {
                        object = $this$clampLeadingHue;
                        return object;
                    }
                }
            }
        }
        object = (Color)copy.invoke((Object)Float.valueOf(v1 % (float)360), (Object)Float.valueOf(RangesKt.coerceIn((float)v2, (float)c2.getMin(), (float)c2.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)v3, (float)c3.getMin(), (float)c3.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)alpha, (float)0.0f, (float)1.0f)));
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final <T extends Color> T clampTrailingHue(@NotNull T $this$clampTrailingHue, float v1, float v2, float v3, float alpha, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> copy) {
        Object object;
        Intrinsics.checkNotNullParameter($this$clampTrailingHue, (String)"<this>");
        Intrinsics.checkNotNullParameter(copy, (String)"copy");
        boolean $i$f$clampTrailingHue = false;
        List<ColorComponentInfo> list = $this$clampTrailingHue.getSpace().getComponents();
        ColorComponentInfo c1 = list.get(0);
        ColorComponentInfo c2 = list.get(1);
        ColorComponentInfo c3 = list.get(2);
        float f = c1.getMin();
        boolean bl = v1 <= c1.getMax() ? f <= v1 : false;
        if (bl) {
            f = c2.getMin();
            boolean bl2 = v2 <= c2.getMax() ? f <= v2 : false;
            if (bl2) {
                f = c3.getMin();
                boolean bl3 = v3 <= c3.getMax() ? f <= v3 : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha ? alpha <= 1.0f : false;
                    if (bl4) {
                        object = $this$clampTrailingHue;
                        return object;
                    }
                }
            }
        }
        object = (Color)copy.invoke((Object)Float.valueOf(RangesKt.coerceIn((float)v1, (float)c1.getMin(), (float)c1.getMax())), (Object)Float.valueOf(RangesKt.coerceIn((float)v2, (float)c2.getMin(), (float)c2.getMax())), (Object)Float.valueOf(v3 % (float)360), (Object)Float.valueOf(RangesKt.coerceIn((float)alpha, (float)0.0f, (float)1.0f)));
        return object;
    }
}

