/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.internal.MatrixKt;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpacesKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001BT\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u001d\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c2\u0003J\t\u0010'\u001a\u00020\tH\u00c2\u0003J\t\u0010(\u001a\u00020\tH\u00c2\u0003J \u0010)\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u00c2\u0003J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000eH\u0016Jf\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\u001f\b\u0002\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u00c6\u0001J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u000203H\u0016J)\u00104\u001a\u00020\u000f2\u0006\u0010\b\u001a\u0002052\u0006\u0010\n\u001a\u0002052\u0006\u0010\u000b\u001a\u0002052\u0006\u00106\u001a\u000205H\u0096\u0002J\b\u00107\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R%\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00068"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpaceImpl;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "name", "", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "transferFunctions", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "r", "Lcom/github/ajalt/colormath/model/xyY;", "g", "b", "convertImpl", "Lkotlin/Function2;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/model/RGB;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lcom/github/ajalt/colormath/WhitePoint;Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;Lcom/github/ajalt/colormath/model/xyY;Lcom/github/ajalt/colormath/model/xyY;Lcom/github/ajalt/colormath/model/xyY;Lkotlin/jvm/functions/Function2;)V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "matrixFromXyz", "", "getMatrixFromXyz", "()[F", "matrixToXyz", "getMatrixToXyz", "getName", "()Ljava/lang/String;", "getTransferFunctions", "()Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "convert", "color", "copy", "create", "equals", "", "other", "", "hashCode", "", "invoke", "", "alpha", "toString", "colormath"})
@SourceDebugExtension(value={"SMAP\nRGBColorSpaces.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/RGBColorSpaceImpl\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n26#2:421\n15#2,13:422\n1#3:435\n*S KotlinDebug\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/RGBColorSpaceImpl\n*L\n255#1:421\n255#1:422,13\n255#1:435\n*E\n"})
final class RGBColorSpaceImpl
implements RGBColorSpace {
    @NotNull
    private final String name;
    @NotNull
    private final WhitePoint whitePoint;
    @NotNull
    private final RGBColorSpace.TransferFunctions transferFunctions;
    @NotNull
    private final xyY r;
    @NotNull
    private final xyY g;
    @NotNull
    private final xyY b;
    @NotNull
    private final Function2<RGBColorSpaceImpl, Color, RGB> convertImpl;
    @NotNull
    private final List<ColorComponentInfo> components;
    @NotNull
    private final float[] matrixToXyz;
    @NotNull
    private final float[] matrixFromXyz;

    public RGBColorSpaceImpl(@NotNull String name, @NotNull WhitePoint whitePoint, @NotNull RGBColorSpace.TransferFunctions transferFunctions, @NotNull xyY r, @NotNull xyY g, @NotNull xyY b, @NotNull Function2<? super RGBColorSpaceImpl, ? super Color, RGB> convertImpl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)transferFunctions, (String)"transferFunctions");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(convertImpl, (String)"convertImpl");
        this.name = name;
        this.whitePoint = whitePoint;
        this.transferFunctions = transferFunctions;
        this.r = r;
        this.g = g;
        this.b = b;
        this.convertImpl = convertImpl;
        this.components = ColorSpaceUtilsKt.zeroOneComponentInfo("RGB");
        this.matrixToXyz = RGBColorSpacesKt.access$rgbToXyzMatrix(this.getWhitePoint(), this.r, this.g, this.b);
        this.matrixFromXyz = MatrixKt.inverse-M2Qqt3Q$default(Matrix.constructor-impl(this.getMatrixToXyz()), false, 1, null);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Override
    @NotNull
    public RGBColorSpace.TransferFunctions getTransferFunctions() {
        return this.transferFunctions;
    }

    @Override
    @NotNull
    public List<ColorComponentInfo> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public RGB convert(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return (RGB)this.convertImpl.invoke((Object)this, (Object)color);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB create(@NotNull float[] components) {
        void p3;
        void p2;
        void p1;
        float f;
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        ColorSpace $this$doCreate$iv = this;
        boolean $i$f$doCreate = false;
        ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
        boolean $i$f$withValidComps = false;
        int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
        int n = size$iv$iv - 1;
        int n2 = components.length;
        if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
            boolean bl = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
            throw new IllegalArgumentException(string.toString());
        }
        float[] it$iv = components;
        boolean bl = false;
        float f2 = components[0];
        float f3 = components[1];
        float f4 = components[2];
        int n3 = 3;
        float[] fArray = components;
        if (n3 <= ArraysKt.getLastIndex((float[])fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            float f5 = f4;
            float f6 = f3;
            float f7 = f2;
            boolean bl2 = false;
            float f8 = 1.0f;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        float f9 = f;
        float f10 = f4;
        float f11 = f3;
        float p0 = f2;
        boolean bl3 = false;
        return (RGB)((Color)this.invoke(p0, (float)p1, (float)p2, (float)p3));
    }

    @Override
    @NotNull
    public float[] getMatrixToXyz() {
        return this.matrixToXyz;
    }

    @Override
    @NotNull
    public float[] getMatrixFromXyz() {
        return this.matrixFromXyz;
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @Override
    @NotNull
    public RGB invoke(float r, float g, float b, float alpha) {
        return new RGB(r, g, b, alpha, this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RGBColorSpace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((RGBColorSpace)other).getName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getWhitePoint(), (Object)((RGBColorSpace)other).getWhitePoint())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTransferFunctions(), (Object)((RGBColorSpace)other).getTransferFunctions())) {
            return false;
        }
        if (other instanceof RGBColorSpaceImpl) {
            if (!Intrinsics.areEqual((Object)this.r, (Object)((RGBColorSpaceImpl)other).r)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.g, (Object)((RGBColorSpaceImpl)other).g)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.b, (Object)((RGBColorSpaceImpl)other).b)) {
                return false;
            }
        } else {
            if (!Arrays.equals(this.getMatrixToXyz(), ((RGBColorSpace)other).getMatrixToXyz())) {
                return false;
            }
            if (!Arrays.equals(this.getMatrixFromXyz(), ((RGBColorSpace)other).getMatrixFromXyz())) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getWhitePoint().hashCode();
        result = 31 * result + this.getTransferFunctions().hashCode();
        result = 31 * result + this.r.hashCode();
        result = 31 * result + this.g.hashCode();
        result = 31 * result + this.b.hashCode();
        return result;
    }

    @Override
    @NotNull
    public RGB invoke(@NotNull Number r, @NotNull Number g, @NotNull Number b, @NotNull Number alpha) {
        return RGBColorSpace.DefaultImpls.invoke(this, r, g, b, alpha);
    }

    @Override
    @NotNull
    public RGB invoke(@NotNull String hex) {
        return RGBColorSpace.DefaultImpls.invoke(this, hex);
    }

    @Override
    @NotNull
    public RGB from255(int r, int g, int b, int alpha) {
        return RGBColorSpace.DefaultImpls.from255(this, r, g, b, alpha);
    }

    @Override
    @NotNull
    public RGB grey(@NotNull Number amount, @NotNull Number alpha) {
        return RGBColorSpace.DefaultImpls.grey(this, amount, alpha);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final WhitePoint component2() {
        return this.whitePoint;
    }

    @NotNull
    public final RGBColorSpace.TransferFunctions component3() {
        return this.transferFunctions;
    }

    private final xyY component4() {
        return this.r;
    }

    private final xyY component5() {
        return this.g;
    }

    private final xyY component6() {
        return this.b;
    }

    private final Function2<RGBColorSpaceImpl, Color, RGB> component7() {
        return this.convertImpl;
    }

    @NotNull
    public final RGBColorSpaceImpl copy(@NotNull String name, @NotNull WhitePoint whitePoint, @NotNull RGBColorSpace.TransferFunctions transferFunctions, @NotNull xyY r, @NotNull xyY g, @NotNull xyY b, @NotNull Function2<? super RGBColorSpaceImpl, ? super Color, RGB> convertImpl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)transferFunctions, (String)"transferFunctions");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(convertImpl, (String)"convertImpl");
        return new RGBColorSpaceImpl(name, whitePoint, transferFunctions, r, g, b, convertImpl);
    }

    public static /* synthetic */ RGBColorSpaceImpl copy$default(RGBColorSpaceImpl rGBColorSpaceImpl, String string, WhitePoint whitePoint, RGBColorSpace.TransferFunctions transferFunctions, xyY xyY2, xyY xyY3, xyY xyY4, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            string = rGBColorSpaceImpl.name;
        }
        if ((n & 2) != 0) {
            whitePoint = rGBColorSpaceImpl.whitePoint;
        }
        if ((n & 4) != 0) {
            transferFunctions = rGBColorSpaceImpl.transferFunctions;
        }
        if ((n & 8) != 0) {
            xyY2 = rGBColorSpaceImpl.r;
        }
        if ((n & 0x10) != 0) {
            xyY3 = rGBColorSpaceImpl.g;
        }
        if ((n & 0x20) != 0) {
            xyY4 = rGBColorSpaceImpl.b;
        }
        if ((n & 0x40) != 0) {
            function2 = rGBColorSpaceImpl.convertImpl;
        }
        return rGBColorSpaceImpl.copy(string, whitePoint, transferFunctions, xyY2, xyY3, xyY4, function2);
    }
}

