/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hawk;

import com.stackhawk.hawk.BrowserUtilsKt;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.software.os.OperatingSystem;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.software.os.mac.MacOperatingSystem;
import oshi.software.os.windows.WindowsOperatingSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010 \u001a\u0004\u0018\u00010\u0004J\n\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010#\u001a\u0004\u0018\u00010\u0004J\n\u0010$\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004J\n\u0010(\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010)\u001a\u0004\u0018\u00010\u0004J\n\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006."}, d2={"Lcom/stackhawk/hawk/BrowserUtils;", "", "()V", "CHROME", "", "getCHROME", "()Ljava/lang/String;", "CHROME_HEADLESS", "getCHROME_HEADLESS", "DISABLED", "getDISABLED", "EDGE", "getEDGE", "FIREFOX", "getFIREFOX", "FIREFOX_HEADLESS", "getFIREFOX_HEADLESS", "SAFARI", "getSAFARI", "UNRECOGNIZED", "getUNRECOGNIZED", "browseToPage", "", "uri", "Ljava/net/URI;", "checkIfBrowserIsInstalled", "os", "Loshi/software/os/OperatingSystem;", "browser", "convertBrowserName", "name", "getLinuxChromeInstallPath", "getLinuxDefaultBrowserPath", "getLinuxFireFoxInstallPath", "getOsxChromeInstallPath", "getOsxDefaultBrowserPath", "getOsxFireFoxInstallPath", "getOsxSafariInstallPath", "getSystemBrowser", "osFamily", "getWindowsChromeInstallPath", "getWindowsDefaultBrowserPath", "getWindowsEdgeInstallPath", "getWindowsFireFoxInstallPath", "isDesktopBrowserEnabled", "isSupportedBrowser", "talon-common"})
@SourceDebugExtension(value={"SMAP\nBrowserUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserUtils.kt\ncom/stackhawk/hawk/BrowserUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n288#2,2:179\n288#2,2:181\n288#2,2:183\n1855#2,2:185\n288#2,2:187\n1855#2,2:189\n288#2,2:191\n1855#2,2:193\n288#2,2:195\n288#2,2:197\n288#2,2:199\n*S KotlinDebug\n*F\n+ 1 BrowserUtils.kt\ncom/stackhawk/hawk/BrowserUtils\n*L\n117#1:179,2\n123#1:181,2\n129#1:183,2\n133#1:185,2\n135#1:187,2\n140#1:189,2\n142#1:191,2\n147#1:193,2\n149#1:195,2\n158#1:197,2\n167#1:199,2\n*E\n"})
public final class BrowserUtils {
    @NotNull
    public static final BrowserUtils INSTANCE = new BrowserUtils();
    @NotNull
    private static final String UNRECOGNIZED;
    @NotNull
    private static final String FIREFOX;
    @NotNull
    private static final String CHROME;
    @NotNull
    private static final String FIREFOX_HEADLESS;
    @NotNull
    private static final String CHROME_HEADLESS;
    @NotNull
    private static final String EDGE;
    @NotNull
    private static final String SAFARI;
    @NotNull
    private static final String DISABLED;

    private BrowserUtils() {
    }

    @NotNull
    public final String getUNRECOGNIZED() {
        return UNRECOGNIZED;
    }

    @NotNull
    public final String getFIREFOX() {
        return FIREFOX;
    }

    @NotNull
    public final String getCHROME() {
        return CHROME;
    }

    @NotNull
    public final String getFIREFOX_HEADLESS() {
        return FIREFOX_HEADLESS;
    }

    @NotNull
    public final String getCHROME_HEADLESS() {
        return CHROME_HEADLESS;
    }

    @NotNull
    public final String getEDGE() {
        return EDGE;
    }

    @NotNull
    public final String getSAFARI() {
        return SAFARI;
    }

    @NotNull
    public final String getDISABLED() {
        return DISABLED;
    }

    public final boolean isSupportedBrowser(@NotNull String browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Object[] objectArray = new String[]{CHROME, FIREFOX, CHROME_HEADLESS, FIREFOX_HEADLESS};
        return CollectionsKt.listOf((Object[])objectArray).contains(browser);
    }

    public final boolean isDesktopBrowserEnabled() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    public final boolean browseToPage(@NotNull URI uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.isDesktopBrowserEnabled() && !GraphicsEnvironment.isHeadless()) {
            Desktop.getDesktop().browse(uri);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getSystemBrowser(@NotNull String osFamily) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)osFamily, (String)"osFamily");
                var4_2 = osFamily;
                v0 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDefault(...)");
                v1 = var4_2.toLowerCase(v0);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                var3_3 = v1;
                switch (var3_3.hashCode()) {
                    case 102977780: {
                        if (!var3_3.equals("linux")) {
                            ** break;
                        }
                        break block6;
                    }
                    case 1349493379: {
                        if (var3_3.equals("windows")) break;
                        ** break;
                    }
                    case 103652211: {
                        if (!var3_3.equals("macos")) ** break;
                        v2 = this.getOsxDefaultBrowserPath();
                        break block7;
                    }
                }
                v2 = this.getWindowsDefaultBrowserPath();
                break block7;
            }
            v2 = this.getLinuxDefaultBrowserPath();
            break block7;
lbl25:
            // 4 sources

            v2 = BrowserUtils.UNRECOGNIZED;
        }
        defaultBrowserPath = v2;
        return this.isDesktopBrowserEnabled() == false ? BrowserUtils.DISABLED : (defaultBrowserPath == null ? BrowserUtils.UNRECOGNIZED : (StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)StringsKt.dropLast((String)BrowserUtils.CHROME, (int)1), (boolean)true) != false ? BrowserUtils.CHROME : (StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)BrowserUtils.FIREFOX, (boolean)true) != false ? BrowserUtils.FIREFOX : (StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)BrowserUtils.EDGE, (boolean)true) != false ? BrowserUtils.EDGE : (StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)BrowserUtils.SAFARI, (boolean)true) != false ? BrowserUtils.SAFARI : BrowserUtils.UNRECOGNIZED)))));
    }

    @NotNull
    public final String convertBrowserName(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string3, (Object)CHROME_HEADLESS)) {
            string = CHROME;
        } else {
            string2 = name;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string4 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string4, (Object)CHROME)) {
                string = CHROME;
            } else {
                string2 = name;
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string5 = string2.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string5, (Object)FIREFOX_HEADLESS)) {
                    string = FIREFOX;
                } else {
                    string2 = name;
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string6 = string2.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                    string = Intrinsics.areEqual((Object)string6, (Object)FIREFOX) ? FIREFOX : UNRECOGNIZED;
                }
            }
        }
        return string;
    }

    public final boolean checkIfBrowserIsInstalled(@NotNull OperatingSystem os, @NotNull String browser) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        String string = this.convertBrowserName(browser);
        if (Intrinsics.areEqual((Object)string, (Object)CHROME)) {
            String defaultBrowserPath;
            OperatingSystem operatingSystem = os;
            String string2 = operatingSystem instanceof MacOperatingSystem ? this.getOsxChromeInstallPath() : (operatingSystem instanceof WindowsOperatingSystem ? this.getWindowsChromeInstallPath() : (defaultBrowserPath = operatingSystem instanceof LinuxOperatingSystem ? this.getLinuxChromeInstallPath() : UNRECOGNIZED));
            if (defaultBrowserPath != null) {
                return StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)StringsKt.dropLast((String)CHROME, (int)1), (boolean)true);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)FIREFOX)) {
            String defaultBrowserPath;
            OperatingSystem operatingSystem = os;
            String string3 = operatingSystem instanceof MacOperatingSystem ? this.getOsxFireFoxInstallPath() : (operatingSystem instanceof WindowsOperatingSystem ? this.getWindowsFireFoxInstallPath() : (defaultBrowserPath = operatingSystem instanceof LinuxOperatingSystem ? this.getLinuxFireFoxInstallPath() : UNRECOGNIZED));
            if (defaultBrowserPath != null) {
                return StringsKt.contains((CharSequence)defaultBrowserPath, (CharSequence)FIREFOX, (boolean)true);
            }
        }
        return false;
    }

    @Nullable
    public final String getWindowsDefaultBrowserPath() {
        String string = this.getWindowsChromeInstallPath();
        if (string == null && (string = this.getWindowsFireFoxInstallPath()) == null) {
            string = this.getWindowsEdgeInstallPath();
        }
        return string;
    }

    @Nullable
    public final String getLinuxDefaultBrowserPath() {
        String string = this.getLinuxChromeInstallPath();
        if (string == null) {
            string = this.getLinuxFireFoxInstallPath();
        }
        return string;
    }

    @Nullable
    public final String getOsxDefaultBrowserPath() {
        String string = this.getOsxChromeInstallPath();
        if (string == null && (string = this.getOsxFireFoxInstallPath()) == null) {
            string = this.getOsxSafariInstallPath();
        }
        return string;
    }

    private final String getOsxFireFoxInstallPath() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object)"/Applications/Firefox.app/Contents/MacOS/firefox");
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getOsxChromeInstallPath() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object)"/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getOsxSafariInstallPath() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object)"/Applications/Safari.app/Contents/MacOS/Safari");
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getWindowsEdgeInstallPath() {
        Object v1;
        block3: {
            List listOfEdge = new ArrayList();
            List list = BrowserUtilsKt.access$getWindowsProgramFilesPath();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    listOfEdge.add(it + "\\Microsoft\\Edge\\Application\\msedge.exe");
                }
            }
            Iterable $this$firstOrNull$iv = listOfEdge;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private final String getWindowsFireFoxInstallPath() {
        Object v1;
        block3: {
            List listOfFireFox = new ArrayList();
            List list = BrowserUtilsKt.access$getWindowsProgramFilesPath();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    listOfFireFox.add(it + "\\Mozilla Firefox\\firefox.exe");
                }
            }
            Iterable $this$firstOrNull$iv = listOfFireFox;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private final String getWindowsChromeInstallPath() {
        Object v1;
        block3: {
            List listOfChrome = new ArrayList();
            List list = BrowserUtilsKt.access$getWindowsProgramFilesPath();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    listOfChrome.add(it + "\\Google\\Chrome\\Application\\chrome.exe");
                }
            }
            Iterable $this$firstOrNull$iv = listOfChrome;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private final String getLinuxFireFoxInstallPath() {
        Object v0;
        block1: {
            Object[] objectArray = new String[]{"/usr/lib/firefox/firefox", "/usr/lib64/firefox/firefox", "/usr/bin/firefox"};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getLinuxChromeInstallPath() {
        Object v0;
        block1: {
            Object[] objectArray = new String[]{"/opt/google/chrome/chrome", "/snap/bin/chromium", "/usr/bin/google-chrome", "/usr/bin/chromium"};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        String string = "UNRECOGNIZED".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        UNRECOGNIZED = string;
        String string2 = "FIREFOX".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        FIREFOX = string2;
        String string3 = "CHROME".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        CHROME = string3;
        String string4 = "FIREFOX_HEADLESS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        FIREFOX_HEADLESS = string4;
        String string5 = "CHROME_HEADLESS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        CHROME_HEADLESS = string5;
        EDGE = "edge";
        SAFARI = "safari";
        DISABLED = "disabled";
    }
}

