/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon;

import com.google.protobuf.ProtocolStringList;
import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.extension.talon.HawkConfExtensions;
import com.stackhawk.hste.extension.talon.IncludeExcludeUrlsRegex;
import com.stackhawk.hste.extension.talon.config.ConfigUtils;
import com.stackhawk.nest.HawkScanMessages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\u0002\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0004*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0004*\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0004\u001a\n\u0010\u001a\u001a\u00020\u0004*\u00020\u0013\u001a\n\u0010\u001b\u001a\u00020\u0004*\u00020\u0013\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0011\u001a\u0012\u0010\u001e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0004\u00a8\u0006 "}, d2={"authTestPathURI", "Ljava/net/URI;", "Lcom/stackhawk/nest/HawkScanMessages$AppConf;", "cleanHost", "", "cleanHostDefaultPort", "harReplacerHost", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf;", "hostRegEx", "hostUri", "hostWithPort", "hostedOASIds", "", "Lcom/stackhawk/nest/HawkScanMessages$OpenApiConf;", "includeExcludeUrls", "Lcom/stackhawk/hste/extension/talon/IncludeExcludeUrlsRegex;", "jwtTokenType", "Lcom/stackhawk/nest/HawkScanMessages$TokenAuthorization;", "loggedInIndicator", "Lcom/stackhawk/nest/HawkScanMessages$Authentication;", "loggedOutIndicator", "maxDepth", "", "Lcom/stackhawk/nest/HawkScanMessages$GrpcConf;", "pathWithHost", "path", "prettyAuthorization", "prettyCredentials", "renewMillis", "", "setProfile", "profileName", "talon-common"})
@SourceDebugExtension(value={"SMAP\nHawkConfExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HawkConfExtensions.kt\ncom/stackhawk/hste/extension/talon/HawkConfExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,649:1\n1549#2:650\n1620#2,3:651\n1549#2:654\n1620#2,3:655\n1549#2:659\n1620#2,3:660\n766#2:663\n857#2,2:664\n1549#2:666\n1620#2,3:667\n1#3:658\n*S KotlinDebug\n*F\n+ 1 HawkConfExtensions.kt\ncom/stackhawk/hste/extension/talon/HawkConfExtensionsKt\n*L\n475#1:650\n475#1:651,3\n476#1:654\n476#1:655,3\n565#1:659\n565#1:660,3\n566#1:663\n566#1:664,2\n567#1:666\n567#1:667,3\n*E\n"})
public final class HawkConfExtensionsKt {
    @NotNull
    public static final URI hostUri(@NotNull HawkScanMessages.AppConf $this$hostUri) {
        Intrinsics.checkNotNullParameter((Object)$this$hostUri, (String)"<this>");
        return HawkConfExtensions.INSTANCE.hostUri($this$hostUri);
    }

    @NotNull
    public static final String cleanHost(@NotNull HawkScanMessages.AppConf $this$cleanHost) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanHost, (String)"<this>");
        return HawkConfExtensions.INSTANCE.cleanHost($this$cleanHost);
    }

    @NotNull
    public static final String cleanHostDefaultPort(@NotNull HawkScanMessages.AppConf $this$cleanHostDefaultPort) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanHostDefaultPort, (String)"<this>");
        return HawkConfExtensions.INSTANCE.cleanHostDefaultPort($this$cleanHostDefaultPort);
    }

    @NotNull
    public static final URI authTestPathURI(@NotNull HawkScanMessages.AppConf $this$authTestPathURI) {
        Intrinsics.checkNotNullParameter((Object)$this$authTestPathURI, (String)"<this>");
        return HawkConfExtensions.INSTANCE.authTestPathURI($this$authTestPathURI);
    }

    @NotNull
    public static final String pathWithHost(@NotNull HawkScanMessages.AppConf $this$pathWithHost, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$pathWithHost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? HawkConfExtensionsKt.cleanHost($this$pathWithHost) + path : (((CharSequence)path).length() == 0 ? HawkConfExtensionsKt.cleanHost($this$pathWithHost) : HawkConfExtensionsKt.cleanHost($this$pathWithHost) + "/" + path);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IncludeExcludeUrlsRegex includeExcludeUrls(@NotNull HawkScanMessages.AppConf $this$includeExcludeUrls) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$includeExcludeUrls, (String)"<this>");
        ProtocolStringList protocolStringList = $this$includeExcludeUrls.getIncludePathsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getIncludePathsList(...)");
        Iterable $this$map$iv = (Iterable)protocolStringList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void path;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)path);
            collection.add(HawkConfExtensionsKt.pathWithHost($this$includeExcludeUrls, (String)path));
        }
        Set includes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ProtocolStringList protocolStringList2 = $this$includeExcludeUrls.getExcludePathsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"getExcludePathsList(...)");
        Iterable $this$map$iv2 = (Iterable)protocolStringList2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void path;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)path);
            collection.add(HawkConfExtensionsKt.pathWithHost($this$includeExcludeUrls, (String)path));
        }
        Set excludes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return new IncludeExcludeUrlsRegex(CollectionsKt.toList((Iterable)includes), CollectionsKt.toList((Iterable)excludes));
    }

    @NotNull
    public static final String hostWithPort(@NotNull HawkScanMessages.AppConf $this$hostWithPort) {
        Intrinsics.checkNotNullParameter((Object)$this$hostWithPort, (String)"<this>");
        URI uri = HawkConfExtensionsKt.hostUri($this$hostWithPort);
        return uri.getHost() + Utils.INSTANCE.portPart(uri);
    }

    @NotNull
    public static final String hostRegEx(@NotNull HawkScanMessages.AppConf $this$hostRegEx) {
        Intrinsics.checkNotNullParameter((Object)$this$hostRegEx, (String)"<this>");
        return HawkConfExtensionsKt.cleanHost($this$hostRegEx) + ".*";
    }

    @NotNull
    public static final String harReplacerHost(@NotNull HawkScanMessages.HawkscanConf $this$harReplacerHost) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$harReplacerHost, (String)"<this>");
        CharSequence charSequence2 = $this$harReplacerHost.getHawk().getSpider().getHar().getReplaceHost();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            HawkScanMessages.AppConf appConf = $this$harReplacerHost.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
            charSequence = HawkConfExtensionsKt.cleanHost(appConf);
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public static final String prettyCredentials(@NotNull HawkScanMessages.Authentication $this$prettyCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyCredentials, (String)"<this>");
        return $this$prettyCredentials.hasUsernamePassword() ? "usernamePassword authentication as " + $this$prettyCredentials.getUsernamePassword().getScanUsername() : ($this$prettyCredentials.hasExternal() ? "external " + $this$prettyCredentials.getExternal().getType() + " authentication with " + $this$prettyCredentials.getExternal().getValuesList().size() + " values." : ($this$prettyCredentials.hasScript() ? "script authentication with " + $this$prettyCredentials.getScript().getName() : ($this$prettyCredentials.hasExternalCommand() ? "externalCommand authentication with " + $this$prettyCredentials.getExternalCommand().getCommand() : ($this$prettyCredentials.hasOauth() ? "oauth authentication with " + $this$prettyCredentials.getOauth().getCredentials().getUsername() + " and " + $this$prettyCredentials.getOauth().getParameters().getTokenEndpoint() : "Unexpected Authentication: " + $this$prettyCredentials.getCredentialsCase()))));
    }

    @NotNull
    public static final String prettyAuthorization(@NotNull HawkScanMessages.Authentication $this$prettyAuthorization) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyAuthorization, (String)"<this>");
        return $this$prettyAuthorization.hasCookieAuthorization() ? "cookieAuthorization with " + $this$prettyAuthorization.getCookieAuthorization().getCookieNamesList().size() + " cookies." : ($this$prettyAuthorization.hasTokenAuthorization() ? "tokenAuthorization " + $this$prettyAuthorization.getTokenAuthorization().getType() + ": " + $this$prettyAuthorization.getTokenAuthorization().getValue() : ($this$prettyAuthorization.hasSessionScript() ? "sessionScript authorization with " + $this$prettyAuthorization.getScript().getName() : "Unexpected Authorization: " + $this$prettyAuthorization.getAuthorizationCase()));
    }

    public static final long renewMillis(@NotNull HawkScanMessages.TokenAuthorization $this$renewMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$renewMillis, (String)"<this>");
        long DEFAULT_JWT_RENEW_MILLIS = 1500L;
        return $this$renewMillis.getRenewMillis() == 0L ? DEFAULT_JWT_RENEW_MILLIS : $this$renewMillis.getRenewMillis();
    }

    @NotNull
    public static final String jwtTokenType(@NotNull HawkScanMessages.TokenAuthorization $this$jwtTokenType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$jwtTokenType, (String)"<this>");
        String DEFAULT_HEADER = "Bearer";
        String string2 = $this$jwtTokenType.getTokenType();
        if (string2 == null ? true : Intrinsics.areEqual((Object)string2, (Object)"")) {
            string = DEFAULT_HEADER;
        } else {
            String string3 = $this$jwtTokenType.getTokenType();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTokenType(...)");
        }
        return string;
    }

    @NotNull
    public static final String loggedInIndicator(@NotNull HawkScanMessages.Authentication $this$loggedInIndicator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loggedInIndicator, (String)"<this>");
        String MATCH_EVERYTHING = ".*";
        String string2 = $this$loggedInIndicator.getLoggedInIndicator();
        if (string2 == null ? true : Intrinsics.areEqual((Object)string2, (Object)"")) {
            string = MATCH_EVERYTHING;
        } else {
            String string3 = $this$loggedInIndicator.getLoggedInIndicator();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLoggedInIndicator(...)");
        }
        return string;
    }

    @NotNull
    public static final String loggedOutIndicator(@NotNull HawkScanMessages.Authentication $this$loggedOutIndicator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loggedOutIndicator, (String)"<this>");
        String MATCH_NOTHING = "$^";
        String string2 = $this$loggedOutIndicator.getLoggedOutIndicator();
        if (string2 == null ? true : Intrinsics.areEqual((Object)string2, (Object)"")) {
            string = MATCH_NOTHING;
        } else {
            String string3 = $this$loggedOutIndicator.getLoggedOutIndicator();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLoggedOutIndicator(...)");
        }
        return string;
    }

    public static final int maxDepth(@NotNull HawkScanMessages.GrpcConf $this$maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$maxDepth, (String)"<this>");
        int DEFAULT_GRPC_MAX_DEPTH = 10;
        return $this$maxDepth.getMaxDepth() == 0L ? DEFAULT_GRPC_MAX_DEPTH : (int)$this$maxDepth.getMaxDepth();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> hostedOASIds(@NotNull HawkScanMessages.OpenApiConf $this$hostedOASIds) {
        URI pathUri;
        Iterable $this$filterTo$iv$iv;
        void it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hostedOASIds, (String)"<this>");
        ProtocolStringList protocolStringList = $this$hostedOASIds.getFilePathsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getFilePathsList(...)");
        List paths = CollectionsKt.toMutableList((Collection)((Collection)protocolStringList));
        paths.add($this$hostedOASIds.getFilePath());
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ConfigUtils.Companion.getFileUri((String)it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pathUri = (URI)element$iv$iv;
            boolean bl = false;
            if (!(ConfigUtils.Companion.fileLocation(pathUri) == ConfigUtils.Companion.FileLocation.HOSTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pathUri = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHost());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HawkScanMessages.HawkscanConf setProfile(@NotNull HawkScanMessages.HawkscanConf $this$setProfile, @NotNull String profileName) {
        Object v1;
        HawkScanMessages.UserProfile it;
        Iterable iterable;
        block15: {
            Intrinsics.checkNotNullParameter((Object)$this$setProfile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            if (!$this$setProfile.getApp().hasAuthentication()) {
                return $this$setProfile;
            }
            List list = $this$setProfile.getApp().getAuthentication().getProfilesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProfilesList(...)");
            iterable = list;
            for (Object t : iterable) {
                it = (HawkScanMessages.UserProfile)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)profileName)) continue;
                v1 = t;
                break block15;
            }
            v1 = null;
        }
        HawkScanMessages.UserProfile profile = v1;
        HawkScanMessages.HawkscanConf.Builder hawkscanConfBuilder = $this$setProfile.toBuilder();
        if ($this$setProfile.getApp().getAuthentication().hasUsernamePassword()) {
            iterable = $this$setProfile.getApp().getAuthentication().getUsernamePassword().toBuilder();
            Iterable iterable2 = iterable;
            HawkScanMessages.Authentication.Builder builder = $this$setProfile.getApp().getAuthentication().toBuilder();
            HawkScanMessages.AppConf.Builder builder2 = $this$setProfile.getApp().toBuilder();
            HawkScanMessages.HawkscanConf.Builder builder3 = hawkscanConfBuilder;
            boolean bl = false;
            HawkScanMessages.UserProfile userProfile = profile;
            if (userProfile != null) {
                it = userProfile;
                boolean bl2 = false;
                $this$setProfile_u24lambda_u248.setScanUsername(it.getUserNamePassword().getUsername());
                $this$setProfile_u24lambda_u248.setScanPassword(it.getUserNamePassword().getPassword());
            }
            Unit unit = Unit.INSTANCE;
            builder3.setApp(builder2.setAuthentication(builder.setUsernamePassword((HawkScanMessages.UsernamePasswordCredentials.Builder)iterable)));
        } else if ($this$setProfile.getApp().getAuthentication().hasOauth()) {
            $this$setProfile_u24lambda_u248 = iterable = $this$setProfile.getApp().getAuthentication().getOauth().toBuilder();
            HawkScanMessages.Authentication.Builder builder = $this$setProfile.getApp().getAuthentication().toBuilder();
            HawkScanMessages.AppConf.Builder builder4 = $this$setProfile.getApp().toBuilder();
            HawkScanMessages.HawkscanConf.Builder builder5 = hawkscanConfBuilder;
            boolean bl = false;
            HawkScanMessages.UserProfile $this$setProfile_u24lambda_u2411_u24lambda_u2410 = it = $this$setProfile_u24lambda_u2411.getCredentials().toBuilder();
            boolean bl3 = false;
            HawkScanMessages.UserProfile userProfile = profile;
            if (userProfile != null) {
                HawkScanMessages.UserProfile it2 = userProfile;
                boolean bl4 = false;
                $this$setProfile_u24lambda_u2411_u24lambda_u2410.setUsername(it2.getUserNamePassword().getUsername());
                $this$setProfile_u24lambda_u2411_u24lambda_u2410.setPassword(it2.getUserNamePassword().getPassword());
            }
            Unit unit = Unit.INSTANCE;
            builder5.setApp(builder4.setAuthentication(builder.setOauth((HawkScanMessages.OAuth.Builder)iterable)));
        } else if ($this$setProfile.getApp().getAuthentication().hasExternal()) {
            $this$setProfile_u24lambda_u2411 = iterable = $this$setProfile.getApp().getAuthentication().getExternal().toBuilder();
            HawkScanMessages.Authentication.Builder builder = $this$setProfile.getApp().getAuthentication().toBuilder();
            HawkScanMessages.AppConf.Builder builder6 = $this$setProfile.getApp().toBuilder();
            HawkScanMessages.HawkscanConf.Builder builder7 = hawkscanConfBuilder;
            boolean bl = false;
            HawkScanMessages.UserProfile userProfile = profile;
            if (userProfile != null) {
                it = userProfile;
                boolean bl5 = false;
                $this$setProfile_u24lambda_u2413.getValuesList().clear();
                List list = $this$setProfile_u24lambda_u2413.getValuesList();
                List list2 = it.getExternal().getAuthTokensList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAuthTokensList(...)");
                list.addAll(list2);
            }
            Unit unit = Unit.INSTANCE;
            builder7.setApp(builder6.setAuthentication(builder.setExternal((HawkScanMessages.ExternalCredentials.Builder)iterable)));
        } else if ($this$setProfile.getApp().getAuthentication().hasScript()) {
            $this$setProfile_u24lambda_u2413 = iterable = $this$setProfile.getApp().getAuthentication().getScript().toBuilder();
            HawkScanMessages.Authentication.Builder builder = $this$setProfile.getApp().getAuthentication().toBuilder();
            HawkScanMessages.AppConf.Builder builder8 = $this$setProfile.getApp().toBuilder();
            HawkScanMessages.HawkscanConf.Builder builder9 = hawkscanConfBuilder;
            boolean bl = false;
            HawkScanMessages.UserProfile userProfile = profile;
            if (userProfile != null) {
                void $this$setProfile_u24lambda_u2415;
                it = userProfile;
                boolean bl6 = false;
                $this$setProfile_u24lambda_u2415.setName(it.getAuthScript().getName());
                $this$setProfile_u24lambda_u2415.clearCredentials();
                $this$setProfile_u24lambda_u2415.putAllCredentials(it.getAuthScript().getCredentialsMap());
            }
            Unit unit = Unit.INSTANCE;
            builder9.setApp(builder8.setAuthentication(builder.setScript((HawkScanMessages.AuthenticationScript.Builder)iterable)));
        } else if (!$this$setProfile.getApp().getAuthentication().hasExternalCommand()) {
            throw new IllegalArgumentException("No authentication configured to set profile on");
        }
        HawkScanMessages.HawkscanConf hawkscanConf = hawkscanConfBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf, (String)"build(...)");
        return hawkscanConf;
    }
}

