/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.JsonFormat;
import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.PlatformApi;
import com.stackhawk.hste.extension.talon.HawkConfExtensionsKt;
import com.stackhawk.hste.extension.talon.ScanPolicyResolverOptions;
import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.hawkscan.api.AssetDownloadException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScanPolicyException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScannerConfigException;
import com.stackhawk.hste.extension.talon.process.ProcessCommandConfiguration;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.HostedAssetMessages;
import com.stackhawk.nest.ScanPolicyMessages;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.nest.UserMessages;
import com.stackhawk.nest.json.Formatter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u0006\u0010\r\u001a\u00020\tJ:\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fJ$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\n\u0010\u0014\u001a\u00020\u0004*\u00020\u0015J\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0015J\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0015J\n\u0010\u0019\u001a\u00020\u0004*\u00020\u0015J \u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\n\u0010\u001d\u001a\u00020\u0004*\u00020\u0015J\u0016\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f*\u00020\u0015J\n\u0010\u001f\u001a\u00020\u0015*\u00020\u0015J\n\u0010 \u001a\u00020\u0004*\u00020\u0015J\n\u0010!\u001a\u00020\u0004*\u00020\u0015J\n\u0010\"\u001a\u00020\u0017*\u00020\u0015J\n\u0010#\u001a\u00020\u0017*\u00020\u0015J\n\u0010$\u001a\u00020\u0004*\u00020\u0015J\n\u0010%\u001a\u00020\u0017*\u00020\u0015J\n\u0010&\u001a\u00020\u0017*\u00020\u0015J\n\u0010'\u001a\u00020\u0017*\u00020\u0015J\n\u0010(\u001a\u00020\u0017*\u00020\u0015J\n\u0010)\u001a\u00020\u0017*\u00020\u0015J\n\u0010*\u001a\u00020\u0017*\u00020\u0015J\n\u0010+\u001a\u00020\u0017*\u00020\u0015J\f\u0010,\u001a\u00020\u0017*\u00020\u0015H\u0002J\n\u0010-\u001a\u00020\u0017*\u00020\u0015J\n\u0010.\u001a\u00020\u0017*\u00020\u0015J\n\u0010/\u001a\u00020\u0017*\u00020\u0015J\n\u00100\u001a\u00020\u0015*\u00020\u0015J\n\u00101\u001a\u000202*\u00020\u0015J\n\u00103\u001a\u000204*\u00020\u0015J\u0012\u00105\u001a\u00020\t*\u00020\u00152\u0006\u00106\u001a\u000207J\n\u00108\u001a\u000204*\u00020\u0015J\u0014\u00109\u001a\u00020\u0015*\u00020\u00152\b\b\u0002\u0010:\u001a\u00020;J\u0012\u0010<\u001a\u00020=*\u00020=2\u0006\u0010>\u001a\u00020?J\u0012\u0010@\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0004J\u0012\u0010A\u001a\u00020?*\u00020?2\u0006\u0010B\u001a\u00020\u0017J\u0012\u0010C\u001a\u00020?*\u00020?2\u0006\u0010D\u001a\u00020\u0017J\u0012\u0010E\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004J\u0012\u0010F\u001a\u00020\u0015*\u00020\u00152\u0006\u0010G\u001a\u00020=J \u0010H\u001a\u00020\u0015*\u00020\u00152\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\f2\u0006\u0010K\u001a\u00020LJ\u0018\u0010M\u001a\u00020\u0015*\u00020\u00152\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u0012\u0010O\u001a\u00020\u0015*\u00020\u00152\u0006\u0010P\u001a\u00020QJ\u0012\u0010R\u001a\u00020\u0015*\u00020\u00152\u0006\u0010S\u001a\u00020\u0004J\n\u0010T\u001a\u00020\u0017*\u00020\u0015J\n\u0010U\u001a\u00020\u0004*\u00020\u0015J\n\u0010V\u001a\u00020\u0004*\u00020\u0015J \u0010W\u001a\u00020\u001b*\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040X2\u0006\u0010Y\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/stackhawk/hste/extension/talon/TalonHawkScanConfExtensions;", "", "()V", "BUSINESS_LOGIC_POLICY_NAME", "", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "configureCustomPolicy", "Lcom/stackhawk/nest/ScanPolicyMessages$ScanPolicy;", "defaultScanPolicy", "pluginIds", "", "configureDefaultPolicy", "interpolateMapValuesReplacements", "", "interpolatedMap", "replacements", "interpolateStringReplacements", "interpolatedString", "applicationId", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "canSend", "", "canSendApi", "cleanTargetHost", "enableOnlyPlugins", "Lcom/stackhawk/nest/ScanPolicyMessages$ScanPolicy$Builder;", "defaultScanPolicyMessage", "environment", "externalCommandImplicitEnvironmentVariables", "generateScanId", "getPlatformUrl", "getScanPolicyName", "graphqlEnabled", "harEnabled", "httpProxy", "isApiScan", "isAutoPolicy", "isCrawlplanEnabled", "isGraphQLEnabled", "isGrpcEnabled", "isOpenApiEnabled", "isOrgLevelPolicy", "isSmartCrawlAutoEnabled", "isSmartCrawlStrictlyEnabled", "isSoapEnabled", "openApiEnabled", "optimizeApiScan", "postmanProcessConfiguration", "Lcom/stackhawk/hste/extension/talon/process/ProcessCommandConfiguration;", "proxyCACertPath", "Ljava/nio/file/Path;", "resolveScanPolicy", "options", "Lcom/stackhawk/hste/extension/talon/ScanPolicyResolverOptions;", "scanSessionDirectory", "setAjaxBrowser", "browser", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$Spider$AjaxBrowser;", "setApp", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf;", "app", "Lcom/stackhawk/nest/HawkScanMessages$AppConf;", "setApplicationId", "setAutoInputVectors", "autoInputVectors", "setAutoPolicy", "autoPolicy", "setEnvironment", "setHawkscanConf", "hawkscanConf", "setIncludeScripts", "scriptIds", "", "type", "Lcom/stackhawk/nest/HawkScanMessages$Script$ScriptType;", "setIncludedPlugins", "plugins", "setOutBoundProxy", "outBoundProxy", "Lcom/stackhawk/nest/HawkScanMessages$Proxy;", "setScanId", "scanId", "soapEnabled", "soapFullFilePath", "soapFullUrlPath", "togglePluginEnabled", "", "enabled", "talon-common"})
@SourceDebugExtension(value={"SMAP\nTalonHawkScanConfExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TalonHawkScanConfExtensions.kt\ncom/stackhawk/hste/extension/talon/TalonHawkScanConfExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AssetManagerClient.kt\ncom/stackhawk/hste/extension/talon/client/AssetManagerClient\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,457:1\n1726#2,3:458\n766#2:461\n857#2,2:462\n1864#2,3:464\n1864#2,3:467\n1271#2,2:478\n1285#2,4:480\n173#3,6:470\n215#4,2:476\n*S KotlinDebug\n*F\n+ 1 TalonHawkScanConfExtensions.kt\ncom/stackhawk/hste/extension/talon/TalonHawkScanConfExtensions\n*L\n43#1:458,3\n200#1:461\n200#1:462,2\n332#1:464,3\n346#1:467,3\n445#1:478,2\n445#1:480,4\n406#1:470,6\n437#1:476,2\n*E\n"})
public final class TalonHawkScanConfExtensions {
    @NotNull
    public static final TalonHawkScanConfExtensions INSTANCE = new TalonHawkScanConfExtensions();
    private static final Logger LOG = LogManager.getLogger(TalonHawkScanConfExtensions.class);
    @NotNull
    public static final String BUSINESS_LOGIC_POLICY_NAME = "BUSINESS_LOGIC";

    private TalonHawkScanConfExtensions() {
    }

    public final boolean canSend(@NotNull TalonMessages.TalonHawkScanConf $this$canSend) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$canSend, (String)"<this>");
            String string = $this$canSend.getPerchKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPerchKey(...)");
            if (((CharSequence)string).length() == 0) {
                String string2 = $this$canSend.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApiKey(...)");
                if (((CharSequence)string2).length() == 0) {
                    return false;
                }
            }
            Object[] objectArray = new String[]{$this$canSend.getAuthEndpoint(), $this$canSend.getApiEndpoint()};
            Iterable $this$all$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = it;
                    if (!(charSequence == null || charSequence.length() == 0)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean graphqlEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$graphqlEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$graphqlEnabled, (String)"<this>");
        return $this$graphqlEnabled.getHawkscanConf().getApp().getGraphqlConf().getEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean soapEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$soapEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$soapEnabled, (String)"<this>");
        String string = $this$soapEnabled.getHawkscanConf().getApp().getSoapConf().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (((CharSequence)string).length() > 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string2 = $this$soapEnabled.getHawkscanConf().getApp().getSoapConf().getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(...)");
        if (((CharSequence)string2).length() <= 0) return false;
        return true;
    }

    @NotNull
    public final String soapFullUrlPath(@NotNull TalonMessages.TalonHawkScanConf $this$soapFullUrlPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$soapFullUrlPath, (String)"<this>");
        CharSequence charSequence = $this$soapFullUrlPath.getHawkscanConf().getApp().getSoapConf().getPath();
        if (!(charSequence == null || charSequence.length() == 0)) {
            HawkScanMessages.AppConf appConf = $this$soapFullUrlPath.getHawkscanConf().getApp();
            Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
            String string = HawkConfExtensionsKt.cleanHost(appConf);
            String string2 = $this$soapFullUrlPath.getHawkscanConf().getApp().getSoapConf().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            object = string + ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String soapFullFilePath(@NotNull TalonMessages.TalonHawkScanConf $this$soapFullFilePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$soapFullFilePath, (String)"<this>");
        CharSequence charSequence = $this$soapFullFilePath.getHawkscanConf().getApp().getSoapConf().getFilePath();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string2 = $this$soapFullFilePath.getBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBaseDir(...)");
            String baseDir = ((CharSequence)string2).length() > 0 ? ((Object)Path.of($this$soapFullFilePath.getBaseDir(), new String[0]).toAbsolutePath()).toString() : "";
            String[] stringArray = new String[]{$this$soapFullFilePath.getHawkscanConf().getApp().getSoapConf().getFilePath()};
            string = ((Object)Path.of(baseDir, stringArray)).toString();
        } else {
            string = "";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean openApiEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$openApiEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$openApiEnabled, (String)"<this>");
        String string = $this$openApiEnabled.getHawkscanConf().getApp().getOpenApiConf().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (((CharSequence)string).length() > 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string2 = $this$openApiEnabled.getHawkscanConf().getApp().getOpenApiConf().getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(...)");
        if (((CharSequence)string2).length() > 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        String string3 = $this$openApiEnabled.getHawkscanConf().getApp().getOpenApiConf().getInline();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInline(...)");
        if (((CharSequence)string3).length() > 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        ProtocolStringList protocolStringList = $this$openApiEnabled.getHawkscanConf().getApp().getOpenApiConf().getFilePathsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getFilePathsList(...)");
        if (!((Collection)protocolStringList).isEmpty()) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        if (!$this$openApiEnabled.getHawkscanConf().getApp().getOpenApiConf().getUsePlatform()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean harEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$harEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$harEnabled, (String)"<this>");
        if (!$this$harEnabled.getHawkscanConf().getHawk().getSpider().hasHar()) return false;
        ProtocolStringList protocolStringList = $this$harEnabled.getHawkscanConf().getHawk().getSpider().getHar().getFile().getPathsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getPathsList(...)");
        if (!((Collection)protocolStringList).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string = $this$harEnabled.getHawkscanConf().getHawk().getSpider().getHar().getDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (((CharSequence)string).length() <= 0) return false;
        return true;
    }

    public final boolean canSendApi(@NotNull TalonMessages.TalonHawkScanConf $this$canSendApi) {
        Intrinsics.checkNotNullParameter((Object)$this$canSendApi, (String)"<this>");
        return this.canSend($this$canSendApi);
    }

    @NotNull
    public final String getPlatformUrl(@NotNull TalonMessages.TalonHawkScanConf $this$getPlatformUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getPlatformUrl, (String)"<this>");
        String string2 = $this$getPlatformUrl.getAuthEndpoint();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAuthEndpoint(...)");
        if (((CharSequence)string2).length() > 0) {
            String string3 = $this$getPlatformUrl.getAuthEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAuthEndpoint(...)");
            string = StringsKt.replace$default((String)string3, (String)"auth", (String)"app", (boolean)false, (int)4, null);
        } else {
            string = "TEST";
        }
        return string;
    }

    @NotNull
    public final String cleanTargetHost(@NotNull TalonMessages.TalonHawkScanConf $this$cleanTargetHost) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanTargetHost, (String)"<this>");
        HawkScanMessages.AppConf appConf = $this$cleanTargetHost.getHawkscanConf().getApp();
        Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
        return HawkConfExtensionsKt.cleanHost(appConf);
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setScanId(@NotNull TalonMessages.TalonHawkScanConf $this$setScanId, @NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)$this$setScanId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setScanId.toBuilder().setScanId(scanId).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf generateScanId(@NotNull TalonMessages.TalonHawkScanConf $this$generateScanId) {
        Intrinsics.checkNotNullParameter((Object)$this$generateScanId, (String)"<this>");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.setScanId($this$generateScanId, string);
    }

    @NotNull
    public final String applicationId(@NotNull TalonMessages.TalonHawkScanConf $this$applicationId) {
        Intrinsics.checkNotNullParameter((Object)$this$applicationId, (String)"<this>");
        String string = $this$applicationId.getHawkscanConf().getApp().getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationId(...)");
        return string;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setApplicationId(@NotNull TalonMessages.TalonHawkScanConf $this$setApplicationId, @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)$this$setApplicationId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setApplicationId.toBuilder().setHawkscanConf($this$setApplicationId.getHawkscanConf().toBuilder().setApp($this$setApplicationId.getHawkscanConf().getApp().toBuilder().setApplicationId(applicationId))).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    @NotNull
    public final String environment(@NotNull TalonMessages.TalonHawkScanConf $this$environment) {
        Intrinsics.checkNotNullParameter((Object)$this$environment, (String)"<this>");
        String string = $this$environment.getHawkscanConf().getApp().getEnv();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEnv(...)");
        return string;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setEnvironment(@NotNull TalonMessages.TalonHawkScanConf $this$setEnvironment, @NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)$this$setEnvironment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setEnvironment.toBuilder().setHawkscanConf($this$setEnvironment.getHawkscanConf().toBuilder().setApp($this$setEnvironment.getHawkscanConf().getApp().toBuilder().setEnv(environment))).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf optimizeApiScan(@NotNull TalonMessages.TalonHawkScanConf $this$optimizeApiScan) {
        TalonMessages.TalonHawkScanConf talonHawkScanConf;
        Intrinsics.checkNotNullParameter((Object)$this$optimizeApiScan, (String)"<this>");
        if (!(Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getSoapConf().getPath(), (Object)"") && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getSoapConf().getFilePath(), (Object)"") && !$this$optimizeApiScan.getHawkscanConf().getApp().getOpenApiConf().getUsePlatform() && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getOpenApiConf().getPath(), (Object)"") && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getOpenApiConf().getFilePath(), (Object)"") && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getOpenApiConf().getInline(), (Object)"") && !$this$optimizeApiScan.getHawkscanConf().getApp().getGraphqlConf().getEnabled() && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getGrpcConf().getPath(), (Object)"") && Intrinsics.areEqual((Object)$this$optimizeApiScan.getHawkscanConf().getApp().getGrpcConf().getFilePath(), (Object)""))) {
            HawkScanMessages.AppConf app;
            HawkScanMessages.AppConf appConf = app = $this$optimizeApiScan.getHawkscanConf().getApp();
            Intrinsics.checkNotNull((Object)appConf);
            appConf = app = this.setAutoInputVectors(appConf, true);
            Intrinsics.checkNotNull((Object)appConf);
            app = this.setAutoPolicy(appConf, true);
            HawkScanMessages.HawkscanConf hawkscanConf = $this$optimizeApiScan.getHawkscanConf();
            Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf, (String)"getHawkscanConf(...)");
            HawkScanMessages.AppConf appConf2 = app;
            Intrinsics.checkNotNull((Object)appConf2);
            HawkScanMessages.HawkscanConf hawkscanConf2 = this.setApp(hawkscanConf, appConf2);
            talonHawkScanConf = this.setHawkscanConf($this$optimizeApiScan, hawkscanConf2);
        } else {
            talonHawkScanConf = $this$optimizeApiScan;
        }
        return talonHawkScanConf;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setHawkscanConf(@NotNull TalonMessages.TalonHawkScanConf $this$setHawkscanConf, @NotNull HawkScanMessages.HawkscanConf hawkscanConf) {
        Intrinsics.checkNotNullParameter((Object)$this$setHawkscanConf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hawkscanConf, (String)"hawkscanConf");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setHawkscanConf.toBuilder().setHawkscanConf(hawkscanConf).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setAjaxBrowser(@NotNull TalonMessages.TalonHawkScanConf $this$setAjaxBrowser, @NotNull HawkScanMessages.HawkConf.Spider.AjaxBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)$this$setAjaxBrowser, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setAjaxBrowser.toBuilder().setHawkscanConf($this$setAjaxBrowser.getHawkscanConf().toBuilder().setHawk($this$setAjaxBrowser.getHawkscanConf().getHawk().toBuilder().setSpider($this$setAjaxBrowser.getHawkscanConf().getHawk().getSpider().toBuilder().setAjaxBrowser(browser)))).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    public static /* synthetic */ TalonMessages.TalonHawkScanConf setAjaxBrowser$default(TalonHawkScanConfExtensions talonHawkScanConfExtensions, TalonMessages.TalonHawkScanConf talonHawkScanConf, HawkScanMessages.HawkConf.Spider.AjaxBrowser ajaxBrowser, int n, Object object) {
        if ((n & 1) != 0) {
            ajaxBrowser = HawkScanMessages.HawkConf.Spider.AjaxBrowser.FIREFOX_HEADLESS;
        }
        return talonHawkScanConfExtensions.setAjaxBrowser(talonHawkScanConf, ajaxBrowser);
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf setIncludedPlugins(@NotNull TalonMessages.TalonHawkScanConf $this$setIncludedPlugins, @NotNull Set<String> plugins) {
        Intrinsics.checkNotNullParameter((Object)$this$setIncludedPlugins, (String)"<this>");
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = $this$setIncludedPlugins.toBuilder().setHawkscanConf($this$setIncludedPlugins.getHawkscanConf().toBuilder().setHawk($this$setIncludedPlugins.getHawkscanConf().getHawk().toBuilder().setScan($this$setIncludedPlugins.getHawkscanConf().getHawk().getScan().toBuilder().clearIncludedPlugins().addAllIncludedPlugins((Iterable)plugins)))).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TalonMessages.TalonHawkScanConf setIncludeScripts(@NotNull TalonMessages.TalonHawkScanConf $this$setIncludeScripts, @NotNull Set<Long> scriptIds, @NotNull HawkScanMessages.Script.ScriptType type) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$setIncludeScripts, (String)"<this>");
        Intrinsics.checkNotNullParameter(scriptIds, (String)"scriptIds");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TalonMessages.TalonHawkScanConf.Builder builder = $this$setIncludeScripts.toBuilder();
        HawkScanMessages.HawkscanConf.Builder builder2 = $this$setIncludeScripts.getHawkscanConf().toBuilder();
        HawkScanMessages.HawkAddOnConf.Builder builder3 = $this$setIncludeScripts.getHawkscanConf().getHawkAddOn().toBuilder().clearScripts();
        List list = $this$setIncludeScripts.getHawkscanConf().getHawkAddOn().getScriptsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getScriptsList(...)");
        Iterable iterable = list;
        HawkScanMessages.HawkAddOnConf.Builder builder4 = builder3;
        HawkScanMessages.HawkscanConf.Builder builder5 = builder2;
        TalonMessages.TalonHawkScanConf.Builder builder6 = builder;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HawkScanMessages.Script script = (HawkScanMessages.Script)element$iv$iv;
            boolean bl = false;
            if (!(script.getType() != type || scriptIds.contains(script.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        TalonMessages.TalonHawkScanConf talonHawkScanConf = builder6.setHawkscanConf(builder5.setHawkAddOn(builder4.addAllScripts((Iterable)list2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    @NotNull
    public final HawkScanMessages.HawkscanConf setApp(@NotNull HawkScanMessages.HawkscanConf $this$setApp, @NotNull HawkScanMessages.AppConf app) {
        Intrinsics.checkNotNullParameter((Object)$this$setApp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        HawkScanMessages.HawkscanConf hawkscanConf = $this$setApp.toBuilder().setApp(app).build();
        Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf, (String)"build(...)");
        return hawkscanConf;
    }

    @NotNull
    public final HawkScanMessages.AppConf setAutoInputVectors(@NotNull HawkScanMessages.AppConf $this$setAutoInputVectors, boolean autoInputVectors) {
        Intrinsics.checkNotNullParameter((Object)$this$setAutoInputVectors, (String)"<this>");
        HawkScanMessages.AppConf appConf = $this$setAutoInputVectors.toBuilder().setAutoInputVectors(autoInputVectors).build();
        Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"build(...)");
        return appConf;
    }

    @NotNull
    public final HawkScanMessages.AppConf setAutoPolicy(@NotNull HawkScanMessages.AppConf $this$setAutoPolicy, boolean autoPolicy) {
        Intrinsics.checkNotNullParameter((Object)$this$setAutoPolicy, (String)"<this>");
        HawkScanMessages.AppConf appConf = $this$setAutoPolicy.toBuilder().setAutoPolicy(autoPolicy).build();
        Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"build(...)");
        return appConf;
    }

    @NotNull
    public final String httpProxy(@NotNull TalonMessages.TalonHawkScanConf $this$httpProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$httpProxy, (String)"<this>");
        return "http://127.0.0.1:" + $this$httpProxy.getProxyPort();
    }

    @NotNull
    public final Path scanSessionDirectory(@NotNull TalonMessages.TalonHawkScanConf $this$scanSessionDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$scanSessionDirectory, (String)"<this>");
        String[] stringArray = new String[]{$this$scanSessionDirectory.getScanId()};
        Path path = Path.of($this$scanSessionDirectory.getSessionHomeDir(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @NotNull
    public final Path proxyCACertPath(@NotNull TalonMessages.TalonHawkScanConf $this$proxyCACertPath) {
        Intrinsics.checkNotNullParameter((Object)$this$proxyCACertPath, (String)"<this>");
        String[] stringArray = new String[]{"ROOT_CA.pem"};
        Path path = Path.of(((Object)this.scanSessionDirectory($this$proxyCACertPath).toAbsolutePath()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    @NotNull
    public final Map<String, String> externalCommandImplicitEnvironmentVariables(@NotNull TalonMessages.TalonHawkScanConf $this$externalCommandImplicitEnvironmentVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$externalCommandImplicitEnvironmentVariables, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"HTTP_PROXY", (Object)this.httpProxy($this$externalCommandImplicitEnvironmentVariables)), TuplesKt.to((Object)"HTTPS_PROXY", (Object)this.httpProxy($this$externalCommandImplicitEnvironmentVariables)), TuplesKt.to((Object)"PROXY_CA_CERT", (Object)((Object)this.proxyCACertPath($this$externalCommandImplicitEnvironmentVariables)).toString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final ProcessCommandConfiguration postmanProcessConfiguration(@NotNull TalonMessages.TalonHawkScanConf $this$postmanProcessConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$postmanProcessConfiguration, (String)"<this>");
        HawkScanMessages.PostmanConfig postmanConfig = $this$postmanProcessConfiguration.getHawkscanConf().getHawk().getSpider().getPostmanConfig();
        Map<String, String> implicitEnvironmentVariables = this.externalCommandImplicitEnvironmentVariables($this$postmanProcessConfiguration);
        String customCommand = "newman run --insecure";
        CharSequence charSequence = postmanConfig.getFilePath();
        List arguments = !(charSequence == null || charSequence.length() == 0) ? CollectionsKt.listOf((Object)postmanConfig.getFilePath()) : CollectionsKt.listOf((Object)("https://api.getpostman.com/collections/" + postmanConfig.getCollectionUID() + "?apikey=" + postmanConfig.getApikey()));
        String string = $this$postmanProcessConfiguration.getBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseDir(...)");
        return new ProcessCommandConfiguration(customCommand, implicitEnvironmentVariables, string, arguments, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final TalonMessages.TalonHawkScanConf setOutBoundProxy(@NotNull TalonMessages.TalonHawkScanConf $this$setOutBoundProxy, @NotNull HawkScanMessages.Proxy outBoundProxy) {
        TalonMessages.TalonHawkScanConf talonHawkScanConf;
        Intrinsics.checkNotNullParameter((Object)$this$setOutBoundProxy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outBoundProxy, (String)"outBoundProxy");
        String string = outBoundProxy.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        if (!(((CharSequence)string).length() > 0)) {
            String string2 = outBoundProxy.getRootCACertPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRootCACertPath(...)");
            if (!(((CharSequence)string2).length() > 0)) {
                talonHawkScanConf = $this$setOutBoundProxy;
                return talonHawkScanConf;
            }
        }
        TalonMessages.TalonHawkScanConf talonHawkScanConf2 = $this$setOutBoundProxy.toBuilder().setHawkscanConf($this$setOutBoundProxy.getHawkscanConf().toBuilder().setHawk($this$setOutBoundProxy.getHawkscanConf().getHawk().toBuilder().setOutboundProxy(outBoundProxy))).build();
        talonHawkScanConf = talonHawkScanConf2;
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf2, (String)"build(...)");
        return talonHawkScanConf;
    }

    public final boolean isGraphQLEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isGraphQLEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isGraphQLEnabled, (String)"<this>");
        return $this$isGraphQLEnabled.getHawkscanConf().getApp().getGraphqlConf().getEnabled();
    }

    public final boolean isSoapEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isSoapEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isSoapEnabled, (String)"<this>");
        return $this$isSoapEnabled.getHawkscanConf().getApp().hasSoapConf();
    }

    public final boolean isOpenApiEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isOpenApiEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isOpenApiEnabled, (String)"<this>");
        return $this$isOpenApiEnabled.getHawkscanConf().getApp().hasOpenApiConf();
    }

    public final boolean isCrawlplanEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isCrawlplanEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isCrawlplanEnabled, (String)"<this>");
        return this.isSmartCrawlStrictlyEnabled($this$isCrawlplanEnabled) || this.isSmartCrawlAutoEnabled($this$isCrawlplanEnabled);
    }

    public final boolean isSmartCrawlStrictlyEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isSmartCrawlStrictlyEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isSmartCrawlStrictlyEnabled, (String)"<this>");
        boolean hasMultipleProfiles = $this$isSmartCrawlStrictlyEnabled.getHawkscanConf().getApp().getAuthentication().getProfilesList().size() > 1;
        return hasMultipleProfiles;
    }

    private final boolean isSmartCrawlAutoEnabled(TalonMessages.TalonHawkScanConf $this$isSmartCrawlAutoEnabled) {
        return this.openApiEnabled($this$isSmartCrawlAutoEnabled) && !$this$isSmartCrawlAutoEnabled.getHawkscanConf().getHawk().getSpider().getDisableSmartCrawling();
    }

    public final boolean isGrpcEnabled(@NotNull TalonMessages.TalonHawkScanConf $this$isGrpcEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isGrpcEnabled, (String)"<this>");
        return $this$isGrpcEnabled.getHawkscanConf().getApp().hasGrpcConf();
    }

    public final boolean isApiScan(@NotNull TalonMessages.TalonHawkScanConf $this$isApiScan) {
        Intrinsics.checkNotNullParameter((Object)$this$isApiScan, (String)"<this>");
        return this.isOpenApiEnabled($this$isApiScan) || this.isGraphQLEnabled($this$isApiScan) || this.isSoapEnabled($this$isApiScan) || this.isGrpcEnabled($this$isApiScan);
    }

    public final boolean isOrgLevelPolicy(@NotNull TalonMessages.TalonHawkScanConf $this$isOrgLevelPolicy) {
        Intrinsics.checkNotNullParameter((Object)$this$isOrgLevelPolicy, (String)"<this>");
        return $this$isOrgLevelPolicy.getHawkscanConf().getApp().hasScanPolicy();
    }

    @NotNull
    public final String getScanPolicyName(@NotNull TalonMessages.TalonHawkScanConf $this$getScanPolicyName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$getScanPolicyName, (String)"<this>");
        CharSequence charSequence2 = $this$getScanPolicyName.getHawkscanConf().getHawk().getScan().getPolicyName();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = INSTANCE.isApiScan($this$getScanPolicyName) && INSTANCE.isAutoPolicy($this$getScanPolicyName) ? (INSTANCE.isGraphQLEnabled($this$getScanPolicyName) ? "DEFAULT_API_GQL" : (INSTANCE.isOpenApiEnabled($this$getScanPolicyName) ? "DEFAULT_API" : (INSTANCE.isSoapEnabled($this$getScanPolicyName) ? "DEFAULT_SOAP" : (INSTANCE.isGrpcEnabled($this$getScanPolicyName) ? "DEFAULT_GRPC" : "")))) : "";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public final boolean isAutoPolicy(@NotNull TalonMessages.TalonHawkScanConf $this$isAutoPolicy) {
        Intrinsics.checkNotNullParameter((Object)$this$isAutoPolicy, (String)"<this>");
        return $this$isAutoPolicy.getHawkscanConf().getApp().getAutoPolicy();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanPolicyMessages.ScanPolicy.Builder enableOnlyPlugins(@NotNull ScanPolicyMessages.ScanPolicy.Builder $this$enableOnlyPlugins, @NotNull ScanPolicyMessages.ScanPolicy defaultScanPolicyMessage, @NotNull Set<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)$this$enableOnlyPlugins, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)defaultScanPolicyMessage, (String)"defaultScanPolicyMessage");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        List list = defaultScanPolicyMessage.getPluginsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPluginsList(...)");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScanPolicyMessages.Plugin plugin = (ScanPolicyMessages.Plugin)item$iv;
            int key = n;
            boolean bl = false;
            boolean enabled = pluginIds.contains(it.getPluginId());
            ScanPolicyMessages.Plugin.Threshold threshold = enabled ? it.getThreshold() : ScanPolicyMessages.Plugin.Threshold.THRESHOLD_OFF;
            LOG.info("Configuring this plugin " + it.getName() + ", " + it.getPluginId() + ", " + it.getPluginType());
            ScanPolicyMessages.Plugin.Builder newPlugin = it.toBuilder().setEnabled(enabled).setThreshold(threshold);
            $this$enableOnlyPlugins.setPlugins(key, newPlugin);
        }
        return $this$enableOnlyPlugins;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanPolicyMessages.ScanPolicy.Builder togglePluginEnabled(@NotNull ScanPolicyMessages.ScanPolicy.Builder $this$togglePluginEnabled, @NotNull List<String> pluginIds, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)$this$togglePluginEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        List list = $this$togglePluginEnabled.getPluginsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPluginsList(...)");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScanPolicyMessages.Plugin plugin = (ScanPolicyMessages.Plugin)item$iv;
            int key = n;
            boolean bl = false;
            boolean included = pluginIds.contains(it.getPluginId());
            if (!included) continue;
            ScanPolicyMessages.Plugin.Threshold threshold = enabled ? it.getThreshold() : ScanPolicyMessages.Plugin.Threshold.THRESHOLD_OFF;
            LOG.info("Configuring this plugin " + it.getName() + ", " + it.getPluginId() + ", " + it.getPluginType());
            ScanPolicyMessages.Plugin.Builder newPlugin = it.toBuilder().setEnabled(enabled).setThreshold(threshold);
            $this$togglePluginEnabled.setPlugins(key, newPlugin);
        }
        return $this$togglePluginEnabled;
    }

    @NotNull
    public final ScanPolicyMessages.ScanPolicy configureCustomPolicy(@NotNull ScanPolicyMessages.ScanPolicy defaultScanPolicy, @NotNull Set<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)defaultScanPolicy, (String)"defaultScanPolicy");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        ScanPolicyMessages.ScanPolicy.Builder builder = defaultScanPolicy.toBuilder().setId(UUID.randomUUID().toString()).setName("CUSTOM").setDisplayName("CUSTOM").setIsCustomized(true);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setIsCustomized(...)");
        ScanPolicyMessages.ScanPolicy scanPolicy = this.enableOnlyPlugins(builder, defaultScanPolicy, pluginIds).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanPolicy, (String)"build(...)");
        return scanPolicy;
    }

    @NotNull
    public final ScanPolicyMessages.ScanPolicy configureDefaultPolicy() {
        InputStreamReader defaultPolicyReader;
        InputStream inputStream = TalonHawkScanConfExtensions.class.getResourceAsStream("/policies/Stock-Default-Policy.json");
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            v1 = new InputStreamReader(inputStream2, charset);
        } else {
            v1 = defaultPolicyReader = null;
        }
        if (defaultPolicyReader == null) {
            throw new ScannerConfigException("could not load default policy from file /policies/Stock-Default-Policy.json", null, null, 6, null);
        }
        ScanPolicyMessages.ScanPolicy.Builder builder = ScanPolicyMessages.ScanPolicy.newBuilder();
        JsonFormat.parser().merge((Reader)defaultPolicyReader, (Message.Builder)builder);
        ScanPolicyMessages.ScanPolicy scanPolicy = builder.build();
        Intrinsics.checkNotNull((Object)scanPolicy);
        return scanPolicy;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanPolicyMessages.ScanPolicy resolveScanPolicy(@NotNull TalonMessages.TalonHawkScanConf $this$resolveScanPolicy, @NotNull ScanPolicyResolverOptions options) {
        ScanPolicyMessages.ScanPolicy scanPolicy;
        Intrinsics.checkNotNullParameter((Object)$this$resolveScanPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (this.canSend($this$resolveScanPolicy)) {
            ScanPolicyMessages.ScanPolicy scanPolicy2;
            try {
                ScanPolicyMessages.ScanPolicy scanPolicy3;
                String appId = $this$resolveScanPolicy.getHawkscanConf().getApp().getApplicationId();
                List list = $this$resolveScanPolicy.getHawkscanConf().getApp().getAuthentication().getProfilesList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProfilesList(...)");
                if (!((Collection)list).isEmpty()) {
                    Intrinsics.checkNotNull((Object)appId);
                    StackHawkApiClient stackHawkApiClient = options.getApiClient();
                    Intrinsics.checkNotNull((Object)stackHawkApiClient);
                    scanPolicy3 = PlatformApi.INSTANCE.getScanPolicyResult(BUSINESS_LOGIC_POLICY_NAME, appId, true, stackHawkApiClient);
                } else if (!((Collection)options.getPluginIds()).isEmpty()) {
                    Intrinsics.checkNotNull((Object)appId);
                    StackHawkApiClient stackHawkApiClient = options.getApiClient();
                    Intrinsics.checkNotNull((Object)stackHawkApiClient);
                    scanPolicy = PlatformApi.INSTANCE.getScanPolicyResult("DEFAULT", appId, true, stackHawkApiClient);
                    scanPolicy3 = this.configureCustomPolicy(scanPolicy, options.getPluginIds());
                } else if (this.isOrgLevelPolicy($this$resolveScanPolicy)) {
                    GeneratedMessageV3 generatedMessageV3;
                    void assetName$iv;
                    void assetType$iv;
                    List list2 = CollectionsKt.listOf((Object)"ORG_POLICY_MANAGEMENT");
                    UserMessages.UserOrganization userOrganization = options.getOrganization();
                    Intrinsics.checkNotNull((Object)userOrganization);
                    Utils.INSTANCE.validateFeatureByOrganizations(list2, SetsKt.setOf((Object)userOrganization), "org level policy management");
                    AssetManagerClient assetManagerClient = options.getAssetManagerClient();
                    Intrinsics.checkNotNull((Object)assetManagerClient);
                    AssetManagerClient assetManagerClient2 = assetManagerClient;
                    String string = options.getOrganization().getOrganization().getId();
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = string;
                    HostedAssetMessages.HostedAssetType hostedAssetType = HostedAssetMessages.HostedAssetType.SCAN_POLICY;
                    String string3 = $this$resolveScanPolicy.getHawkscanConf().getApp().getScanPolicy().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = string3;
                    GeneratedMessageV3 generatedMessageV32 = (GeneratedMessageV3)ScanPolicyMessages.ScanPolicy.getDefaultInstance();
                    TalonHawkScanConfExtensions talonHawkScanConfExtensions = this;
                    TalonHawkScanConfExtensions talonHawkScanConfExtensions2 = this;
                    boolean $i$f$getDownloadedAsset = false;
                    try {
                        void organizationId$iv;
                        void this_$iv;
                        void resultBuilder$iv;
                        Message.Builder builder$iv = (Message.Builder)resultBuilder$iv.newBuilderForType();
                        Formatter.INSTANCE.parser().merge((Reader)new InputStreamReader(AssetManagerClient.getRawAsset$default((AssetManagerClient)this_$iv, (String)organizationId$iv, (HostedAssetMessages.HostedAssetType)assetType$iv, (String)assetName$iv, null, 8, null)), builder$iv);
                        generatedMessageV3 = (GeneratedMessageV3)((ScanPolicyMessages.ScanPolicy)builder$iv.build());
                    }
                    catch (Exception ex$iv) {
                        throw new AssetDownloadException("Could not download " + (HostedAssetMessages.HostedAssetType)assetType$iv + " : " + (String)assetName$iv, ex$iv, null, 4, null);
                    }
                    GeneratedMessageV3 generatedMessageV33 = generatedMessageV3;
                    scanPolicy = ((ScanPolicyMessages.ScanPolicy)generatedMessageV33).toBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)scanPolicy, (String)"toBuilder(...)");
                    ProtocolStringList protocolStringList = $this$resolveScanPolicy.getHawkscanConf().getApp().getScanPolicy().getIncludePluginIdsList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getIncludePluginIdsList(...)");
                    ScanPolicyMessages.ScanPolicy.Builder builder = talonHawkScanConfExtensions.togglePluginEnabled((ScanPolicyMessages.ScanPolicy.Builder)scanPolicy, (List)protocolStringList, true);
                    ProtocolStringList protocolStringList2 = $this$resolveScanPolicy.getHawkscanConf().getApp().getScanPolicy().getExcludePluginIdsList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"getExcludePluginIdsList(...)");
                    scanPolicy3 = talonHawkScanConfExtensions2.togglePluginEnabled(builder, (List)protocolStringList2, false).build();
                } else {
                    String string = options.getPolicyName();
                    Intrinsics.checkNotNull((Object)appId);
                    boolean bl = options.getPolicyConfigured();
                    StackHawkApiClient stackHawkApiClient = options.getApiClient();
                    Intrinsics.checkNotNull((Object)stackHawkApiClient);
                    scanPolicy3 = PlatformApi.INSTANCE.getScanPolicyResult(string, appId, bl, stackHawkApiClient);
                }
                scanPolicy2 = scanPolicy3;
            }
            catch (Exception e) {
                LOG.error("unable to pull remote policy " + e.getMessage(), (Throwable)e);
                if (e instanceof AssetDownloadException) {
                    throw new ScanPolicyException("Could not retrieve org level policy " + $this$resolveScanPolicy.getHawkscanConf().getApp().getScanPolicy().getName(), e.getCause(), null, 4, null);
                }
                throw e;
            }
            ScanPolicyMessages.ScanPolicy scanPolicy4 = scanPolicy2;
            Intrinsics.checkNotNull((Object)scanPolicy4);
            scanPolicy = scanPolicy4;
        } else {
            LOG.info("platform not available, using default policy");
            scanPolicy = this.configureDefaultPolicy();
        }
        return scanPolicy;
    }

    private final String interpolateStringReplacements(String interpolatedString, Map<String, String> replacements) {
        String customString = null;
        customString = interpolatedString;
        Map<String, String> $this$forEach$iv = replacements;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            customString = StringsKt.replace$default((String)customString, (String)key, (String)value, (boolean)false, (int)4, null);
        }
        return customString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> interpolateMapValuesReplacements(@NotNull Map<String, String> interpolatedMap, @NotNull Map<String, String> replacements) {
        Intrinsics.checkNotNullParameter(interpolatedMap, (String)"interpolatedMap");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        Iterable $this$associateWith$iv = interpolatedMap.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string2 = interpolatedMap.get(it);
            Intrinsics.checkNotNull((Object)string2);
            String string3 = INSTANCE.interpolateStringReplacements(string2, replacements);
            map.put(t, string3);
        }
        return result$iv;
    }
}

