/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.brymck.gsondeepmerge.GsonDeepMerge;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.stackhawk.hste.PlatformApi;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.config.AppVariables;
import com.stackhawk.hste.extension.talon.config.Config;
import com.stackhawk.hste.extension.talon.config.ConfigResolverOptions;
import com.stackhawk.hste.extension.talon.config.ConfigUtils;
import com.stackhawk.hste.extension.talon.config.HawkSchemaLoader;
import com.stackhawk.hste.extension.talon.hawkscan.api.ConfException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanConfigValidationError;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidYamlFileException;
import com.stackhawk.nest.AssetValidationMessages;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.UserSecretMessages;
import com.stackhawk.nest.json.Formatter;
import com.stackhawk.nest.json.NestJsonSchemaCustomizer;
import com.stackhawk.nest.proto.FieldValidationError;
import com.stackhawk.nest.proto.NestProtoResolver;
import com.stackhawk.nest.proto.Validations;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.jimblackler.jsonschemafriend.ListValidationException;
import net.jimblackler.jsonschemafriend.Loader;
import net.jimblackler.jsonschemafriend.MissingPathException;
import net.jimblackler.jsonschemafriend.MissingPropertyError;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.SchemaException;
import net.jimblackler.jsonschemafriend.SchemaStore;
import net.jimblackler.jsonschemafriend.ValidationError;
import net.jimblackler.jsonschemafriend.ValidationException;
import net.jimblackler.jsonschemafriend.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u00108\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0001092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0001092\b\b\u0002\u0010;\u001a\u00020\fH\u0002J2\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010=2\b\b\u0002\u0010;\u001a\u00020\fH\u0002J\u0010\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020\fH\u0002J\u000e\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020CJ\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0E2\b\u0010F\u001a\u0004\u0018\u00010\fJ$\u0010G\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u000b0H2\u0006\u0010J\u001a\u00020\u001bH\u0002J\"\u0010K\u001a\u0014\u0012\u0004\u0012\u00020L\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u000b0H2\u0006\u0010M\u001a\u00020\fH\u0002J\u0018\u0010N\u001a\u00020L2\u0006\u0010B\u001a\u00020C2\b\u0010O\u001a\u0004\u0018\u00010PJ\u0016\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020TJ(\u0010U\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010I0H2\u0006\u0010V\u001a\u00020\f2\u0006\u0010S\u001a\u00020TH\u0002J\"\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010=2\u0006\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020TJ*\u0010X\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010L\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u000b0H2\u0006\u0010V\u001a\u00020\f2\u0006\u0010S\u001a\u00020TJ \u0010Y\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010Z\u001a\u00020\f2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\fJ \u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020L2\u0006\u0010'\u001a\u00020(2\u0006\u0010_\u001a\u00020`H\u0002J*\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010=*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010=2\u0006\u0010b\u001a\u00020cJ\n\u0010d\u001a\u00020e*\u00020fJ\n\u0010g\u001a\u00020I*\u00020hJ\f\u0010g\u001a\u00020I*\u00020iH\u0002J\u000e\u0010g\u001a\u00020I*\u00060jj\u0002`kJ\n\u0010g\u001a\u00020I*\u00020lJ\n\u0010g\u001a\u00020I*\u00020mJ\u0010\u0010n\u001a\b\u0012\u0004\u0012\u00020I0\u000b*\u00020oJ\u0010\u0010n\u001a\b\u0012\u0004\u0012\u00020I0\u000b*\u00020pJ\u0010\u0010n\u001a\b\u0012\u0004\u0012\u00020I0\u000b*\u00020qJ\n\u0010r\u001a\u00020\f*\u00020LJ\u0012\u0010s\u001a\n\u0012\u0004\u0012\u00020i\u0018\u00010\u000b*\u00020LJ\f\u0010t\u001a\u0004\u0018\u00010i*\u00020fJ\f\u0010u\u001a\u0004\u0018\u00010i*\u00020vJ\f\u0010w\u001a\u0004\u0018\u00010i*\u00020fJ\f\u0010x\u001a\u0004\u0018\u00010i*\u00020fJ\f\u0010y\u001a\u0004\u0018\u00010i*\u00020fJ\f\u0010z\u001a\u0004\u0018\u00010i*\u00020{J\n\u0010|\u001a\u00020}*\u00020}J\n\u0010|\u001a\u00020~*\u00020~J\n\u0010|\u001a\u00020\u007f*\u00020\u007fJ\f\u0010|\u001a\u00030\u0080\u0001*\u00030\u0080\u0001R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006\u0081\u0001"}, d2={"Lcom/stackhawk/hste/extension/talon/config/Config;", "", "()V", "additionalPropertiesString", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "customizer", "Lcom/stackhawk/nest/json/NestJsonSchemaCustomizer;", "getCustomizer", "()Lcom/stackhawk/nest/json/NestJsonSchemaCustomizer;", "defaultConfigFiles", "", "", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "getGsonBuilder", "()Lcom/google/gson/GsonBuilder;", "gsonDeepMerge", "Lcom/github/brymck/gsondeepmerge/GsonDeepMerge;", "getGsonDeepMerge", "()Lcom/github/brymck/gsondeepmerge/GsonDeepMerge;", "hawkscanConfRoot", "jsonSchema", "Lcom/google/gson/JsonObject;", "getJsonSchema", "()Lcom/google/gson/JsonObject;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "npr", "Lcom/stackhawk/nest/proto/NestProtoResolver;", "getNpr", "()Lcom/stackhawk/nest/proto/NestProtoResolver;", "quotedStringRegex", "schema", "Lnet/jimblackler/jsonschemafriend/Schema;", "getSchema", "()Lnet/jimblackler/jsonschemafriend/Schema;", "schemaStore", "Lnet/jimblackler/jsonschemafriend/SchemaStore;", "getSchemaStore", "()Lnet/jimblackler/jsonschemafriend/SchemaStore;", "validationErrorsPrefix", "validator", "Lnet/jimblackler/jsonschemafriend/Validator;", "getValidator", "()Lnet/jimblackler/jsonschemafriend/Validator;", "yaml", "Lorg/yaml/snakeyaml/Yaml;", "getYaml", "()Lorg/yaml/snakeyaml/Yaml;", "fixNumericType", "", "entry", "baseKey", "fixNumericTypes", "", "yamlMap", "matchValidationExceptionMessage", "it", "mergeConfigs", "options", "Lcom/stackhawk/hste/extension/talon/config/ConfigResolverOptions;", "parseEnvVarsFile", "", "filePath", "parseJsonObjectToValidatedJsonStringMarkers", "Lkotlin/Pair;", "Lcom/stackhawk/nest/AssetValidationMessages$Marker;", "jsonObject", "parseJsonStringToHawkScanConfWithMarkers", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf;", "jsonString", "parseStackHawkYamlFiles", "stackHawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "parseYamlTextAsJsonObject", "confText", "uri", "Ljava/net/URI;", "parseYamlTextAsJsonObjectWithMarker", "interpolatedConfText", "parseYamlTextAsMap", "parseYamlTextAsValidatedHawkScanConfig", "resolveDefaultConfigFiles", "baseDir", "applicationId", "validateConfig", "", "conf", "document", "Ljava/lang/Object;", "injectVariables", "appVariables", "Lcom/stackhawk/hste/extension/talon/config/AppVariables;", "isJWTAuth", "", "Lcom/stackhawk/nest/HawkScanMessages$AppConf;", "toAssetValidationMarker", "Lcom/google/protobuf/InvalidProtocolBufferException;", "Lcom/stackhawk/nest/proto/FieldValidationError;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "Lnet/jimblackler/jsonschemafriend/MissingPropertyError;", "Lnet/jimblackler/jsonschemafriend/SchemaException;", "toAssetValidationMarkers", "Lnet/jimblackler/jsonschemafriend/ListValidationException;", "Lnet/jimblackler/jsonschemafriend/ValidationError;", "Lnet/jimblackler/jsonschemafriend/ValidationException;", "toJson", "validate", "validateAuthorization", "validateExternalCredentials", "Lcom/stackhawk/nest/HawkScanMessages$Authentication;", "validateLoggedInIndicator", "validateLoggedOutIndicator", "validatePaths", "validatePostmanConfig", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf;", "withDefaults", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$Builder;", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$ScanConf$Builder;", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$Spider$Builder;", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf$Builder;", "talon-common"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/stackhawk/hste/extension/talon/config/Config\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Formatter.kt\ncom/stackhawk/nest/json/Formatter\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,634:1\n1549#2:635\n1620#2,3:636\n1549#2:639\n1620#2,3:640\n1360#2:643\n1446#2,5:644\n1549#2:650\n1620#2,3:651\n766#2:654\n857#2,2:655\n1179#2,2:657\n1253#2,4:659\n1789#2,3:669\n1271#2,2:672\n1285#2,4:674\n1549#2:681\n1620#2,3:682\n1789#2,3:686\n1855#2,2:689\n1#3:649\n45#4,3:663\n45#4,3:666\n125#5:678\n152#5,2:679\n154#5:685\n*S KotlinDebug\n*F\n+ 1 Config.kt\ncom/stackhawk/hste/extension/talon/config/Config\n*L\n119#1:635\n119#1:636,3\n145#1:639\n145#1:640,3\n191#1:643\n191#1:644,5\n312#1:650\n312#1:651,3\n312#1:654\n312#1:655,2\n343#1:657,2\n343#1:659,4\n451#1:669,3\n493#1:672,2\n493#1:674,4\n536#1:681\n536#1:682,3\n546#1:686,3\n595#1:689,2\n351#1:663,3\n416#1:666,3\n525#1:678\n525#1:679,2\n525#1:685\n*E\n"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String hawkscanConfRoot = "com.stackhawk.nest.HawkScanMessages$HawkscanConf";
    @NotNull
    private static final List<String> defaultConfigFiles;
    private static final Pattern quotedStringRegex;
    private static final Pattern additionalPropertiesString;
    @NotNull
    private static final String validationErrorsPrefix;

    private Config() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    private final Yaml getYaml() {
        return new Yaml();
    }

    private final GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).setLenient();
    }

    public final Gson getGson() {
        return this.getGsonBuilder().create();
    }

    private final GsonDeepMerge getGsonDeepMerge() {
        return new GsonDeepMerge();
    }

    private final NestJsonSchemaCustomizer getCustomizer() {
        return new NestJsonSchemaCustomizer();
    }

    @NotNull
    public final JsonObject getJsonSchema() {
        NestJsonSchemaCustomizer nestJsonSchemaCustomizer = this.getCustomizer();
        String string = HawkScanMessages.HawkscanConf.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return nestJsonSchemaCustomizer.createJsonSchema(string);
    }

    @NotNull
    public final SchemaStore getSchemaStore() {
        return new SchemaStore((Loader)new HawkSchemaLoader());
    }

    @NotNull
    public final Schema getSchema() {
        Schema schema = this.getSchemaStore().loadSchemaJson(this.getJsonSchema().toString());
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"loadSchemaJson(...)");
        return schema;
    }

    @NotNull
    public final Validator getValidator() {
        return new Validator(arg_0 -> Config._get_validator_$lambda$0(validator.1.INSTANCE, arg_0));
    }

    private final NestProtoResolver getNpr() {
        return new NestProtoResolver();
    }

    private final String matchValidationExceptionMessage(String it) {
        Matcher addPropertiesMatcher = additionalPropertiesString.matcher(it);
        Matcher quotedMatcher = quotedStringRegex.matcher(it);
        Object msg = addPropertiesMatcher.find() ? addPropertiesMatcher.group(1) + " does not support additional properties." : (quotedMatcher.find() ? quotedMatcher.group(1) : it);
        Intrinsics.checkNotNull((Object)msg);
        return msg;
    }

    @NotNull
    public final AssetValidationMessages.Marker toAssetValidationMarker(@NotNull SchemaException $this$toAssetValidationMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarker, (String)"<this>");
        AssetValidationMessages.Marker marker = AssetValidationMessages.Marker.newBuilder().setOwner("SchemaException").setMessage($this$toAssetValidationMarker.getMessage()).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"build(...)");
        return marker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AssetValidationMessages.Marker> toAssetValidationMarkers(@NotNull ValidationException $this$toAssetValidationMarkers) {
        List list;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarkers, (String)"<this>");
        Object object = $this$toAssetValidationMarkers.getMessage();
        if (object != null && (object = StringsKt.removePrefix((String)object, (CharSequence)validationErrorsPrefix)) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String message = INSTANCE.matchValidationExceptionMessage((String)it);
                collection.add(AssetValidationMessages.Marker.newBuilder().setOwner("ValidationException").setMessage(message).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final AssetValidationMessages.Marker toAssetValidationMarker(@NotNull MissingPropertyError $this$toAssetValidationMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarker, (String)"<this>");
        Matcher matcher = quotedStringRegex.matcher($this$toAssetValidationMarker.getMessage());
        String msg = matcher.find() ? matcher.group(1) : $this$toAssetValidationMarker.getMessage();
        AssetValidationMessages.Marker marker = AssetValidationMessages.Marker.newBuilder().setOwner("MissingPropertyError").setMessage(msg).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"build(...)");
        return marker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AssetValidationMessages.Marker> toAssetValidationMarkers(@NotNull ValidationError $this$toAssetValidationMarkers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarkers, (String)"<this>");
        String string = $this$toAssetValidationMarkers.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void msg;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Matcher matcher = quotedStringRegex.matcher((CharSequence)it);
            Object object = msg = matcher.find() ? matcher.group(1) : it;
            collection.add($this$toAssetValidationMarkers instanceof MissingPropertyError ? INSTANCE.toAssetValidationMarker((MissingPropertyError)$this$toAssetValidationMarkers) : AssetValidationMessages.Marker.newBuilder().setOwner("ValidationError").setMessage((String)msg).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final AssetValidationMessages.Marker toAssetValidationMarker(@NotNull IllegalArgumentException $this$toAssetValidationMarker) {
        AssetValidationMessages.Marker marker;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarker, (String)"<this>");
        String suffix = "(enableSubstitutionInVariables=false).";
        String owner = "IllegalArgumentException";
        if ($this$toAssetValidationMarker.getMessage() != null) {
            String string = $this$toAssetValidationMarker.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.startsWith$default((String)string, (String)"Cannot resolve variable", (boolean)false, (int)2, null)) {
                String string2 = $this$toAssetValidationMarker.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                String message = StringsKt.removeSuffix((String)string2, (CharSequence)suffix);
                AssetValidationMessages.Marker marker2 = AssetValidationMessages.Marker.newBuilder().setOwner(owner).setMessage(message).setSeverity(AssetValidationMessages.MarkerSeverity.WARNING).build();
                Intrinsics.checkNotNull((Object)marker2);
                marker = marker2;
                return marker;
            }
        }
        AssetValidationMessages.Marker marker3 = AssetValidationMessages.Marker.newBuilder().setOwner(owner).setMessage($this$toAssetValidationMarker.getMessage()).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build();
        Intrinsics.checkNotNull((Object)marker3);
        marker = marker3;
        return marker;
    }

    @NotNull
    public final AssetValidationMessages.Marker toAssetValidationMarker(@NotNull InvalidProtocolBufferException $this$toAssetValidationMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarker, (String)"<this>");
        AssetValidationMessages.Marker marker = AssetValidationMessages.Marker.newBuilder().setOwner("InvalidProtocolBufferException").setMessage($this$toAssetValidationMarker.getMessage()).setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"build(...)");
        return marker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AssetValidationMessages.Marker> toAssetValidationMarkers(@NotNull ListValidationException $this$toAssetValidationMarkers) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetValidationMarkers, (String)"<this>");
        Collection collection = $this$toAssetValidationMarkers.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getErrors(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ValidationError it = (ValidationError)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = INSTANCE.toAssetValidationMarkers(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final FieldValidationError validatePaths(@NotNull HawkScanMessages.AppConf $this$validatePaths) {
        Intrinsics.checkNotNullParameter((Object)$this$validatePaths, (String)"<this>");
        return Validations.Companion.isEqual((List)$this$validatePaths.getIncludePathsList(), (List)$this$validatePaths.getExcludePathsList()) ? new FieldValidationError("includePaths", "All include paths are excluded", "#/app/includePaths") : null;
    }

    @Nullable
    public final FieldValidationError validateLoggedInIndicator(@NotNull HawkScanMessages.AppConf $this$validateLoggedInIndicator) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$validateLoggedInIndicator, (String)"<this>");
        return $this$validateLoggedInIndicator.hasAuthentication() && ((charSequence = (CharSequence)$this$validateLoggedInIndicator.getAuthentication().getLoggedInIndicator()) == null || charSequence.length() == 0) && !this.isJWTAuth($this$validateLoggedInIndicator) ? new FieldValidationError("loggedInIndicator", "Logged in indicator is required", "#/app/authentication/loggedInIndicator") : (!Validations.Companion.isValidRegex($this$validateLoggedInIndicator.getAuthentication().getLoggedInIndicator()) ? new FieldValidationError("loggedInIndicator", "Logged in indicator must be a valid regex", "#/app/authentication/loggedInIndicator") : null);
    }

    @Nullable
    public final FieldValidationError validateLoggedOutIndicator(@NotNull HawkScanMessages.AppConf $this$validateLoggedOutIndicator) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$validateLoggedOutIndicator, (String)"<this>");
        return $this$validateLoggedOutIndicator.hasAuthentication() && ((charSequence = (CharSequence)$this$validateLoggedOutIndicator.getAuthentication().getLoggedOutIndicator()) == null || charSequence.length() == 0) && !this.isJWTAuth($this$validateLoggedOutIndicator) ? new FieldValidationError("loggedOutIndicator", "Logged out indicator is required", "#/app/authentication/loggedOutIndicator") : (!Validations.Companion.isValidRegex($this$validateLoggedOutIndicator.getAuthentication().getLoggedOutIndicator()) ? new FieldValidationError("loggedOutIndicator", "Logged out indicator must be a valid regex", "#/app/authentication/loggedOutIndicator") : null);
    }

    @Nullable
    public final FieldValidationError validatePostmanConfig(@NotNull HawkScanMessages.HawkConf $this$validatePostmanConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$validatePostmanConfig, (String)"<this>");
        CharSequence charSequence = $this$validatePostmanConfig.getSpider().getPostmanConfig().getFilePath();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && (!((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getApikey()) == null || StringsKt.isBlank((CharSequence)charSequence)) || !((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getCollectionUID()) == null || StringsKt.isBlank((CharSequence)charSequence))) ? new FieldValidationError("postmanConfig", "PostmanConfig requires either ApiKey and CollectionUID or Collection filePath but not both.", "#/hawkConf/spider/postmanConfig") : (((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getFilePath()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getApikey()) == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getCollectionUID()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? new FieldValidationError("postmanConfig", "PostmanConfig requires apiKey when no filePath is present.", "#/hawkConf/spider/postmanConfig") : (((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getFilePath()) == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getApikey()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)$this$validatePostmanConfig.getSpider().getPostmanConfig().getCollectionUID()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? new FieldValidationError("postmanConfig", "PostmanConfig requires CollectionUID when no filePath is present.", "#/hawkConf/spider/postmanConfig") : null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final FieldValidationError validateExternalCredentials(@NotNull HawkScanMessages.Authentication $this$validateExternalCredentials) {
        FieldValidationError fieldValidationError;
        Intrinsics.checkNotNullParameter((Object)$this$validateExternalCredentials, (String)"<this>");
        if (!$this$validateExternalCredentials.hasExternal()) {
            return null;
        }
        CharSequence charSequence = $this$validateExternalCredentials.getExternal().getValue();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List list = $this$validateExternalCredentials.getExternal().getValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValuesList(...)");
            if (!((Collection)list).isEmpty()) {
                fieldValidationError = new FieldValidationError("externalCredentials", "ExternalCredentials requires either value or values but not both.", "#/Authentication/external");
                return fieldValidationError;
            }
        }
        if ((charSequence = (CharSequence)$this$validateExternalCredentials.getExternal().getValue()) != null) {
            if (!StringsKt.isBlank((CharSequence)charSequence)) return null;
        }
        boolean bl = true;
        if (!bl) return null;
        if (!$this$validateExternalCredentials.getExternal().getValuesList().isEmpty()) return null;
        fieldValidationError = new FieldValidationError("externalCredentials", "ExternalCredentials requires either single value or values.", "#/Authentication/external");
        return fieldValidationError;
    }

    @Nullable
    public final FieldValidationError validateAuthorization(@NotNull HawkScanMessages.AppConf $this$validateAuthorization) {
        Intrinsics.checkNotNullParameter((Object)$this$validateAuthorization, (String)"<this>");
        return $this$validateAuthorization.hasAuthentication() && !$this$validateAuthorization.getAuthentication().hasExternal() && !$this$validateAuthorization.getAuthentication().hasExternalCommand() ? (!($this$validateAuthorization.getAuthentication().hasCookieAuthorization() || $this$validateAuthorization.getAuthentication().hasTokenAuthorization() || $this$validateAuthorization.getAuthentication().hasSessionScript()) ? new FieldValidationError("authorization", "Missing property, should have exactly 1 property from [cookieAuthorization, tokenAuthorization, sessionScript]", "#/Authentication/authorization") : null) : null;
    }

    private final AssetValidationMessages.Marker toAssetValidationMarker(FieldValidationError $this$toAssetValidationMarker) {
        AssetValidationMessages.Marker marker = AssetValidationMessages.Marker.newBuilder().setOwner("FieldValidationError").setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).setMessage($this$toAssetValidationMarker.getMessage()).build();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"build(...)");
        return marker;
    }

    @Nullable
    public final List<FieldValidationError> validate(@NotNull HawkScanMessages.HawkscanConf $this$validate) {
        Collection collection;
        FieldValidationError it;
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        List errors = new ArrayList();
        HawkScanMessages.AppConf appConf = $this$validate.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
        FieldValidationError fieldValidationError = this.validatePaths(appConf);
        if (fieldValidationError != null) {
            it = fieldValidationError;
            boolean bl = false;
            errors.add(it);
        }
        HawkScanMessages.Authentication authentication = $this$validate.getApp().getAuthentication();
        Intrinsics.checkNotNullExpressionValue((Object)authentication, (String)"getAuthentication(...)");
        FieldValidationError fieldValidationError2 = this.validateExternalCredentials(authentication);
        if (fieldValidationError2 != null) {
            it = fieldValidationError2;
            boolean bl = false;
            errors.add(it);
        }
        HawkScanMessages.AppConf appConf2 = $this$validate.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)appConf2, (String)"getApp(...)");
        FieldValidationError fieldValidationError3 = this.validateAuthorization(appConf2);
        if (fieldValidationError3 != null) {
            it = fieldValidationError3;
            boolean bl = false;
            errors.add(it);
        }
        HawkScanMessages.AppConf appConf3 = $this$validate.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)appConf3, (String)"getApp(...)");
        FieldValidationError fieldValidationError4 = this.validateLoggedInIndicator(appConf3);
        if (fieldValidationError4 != null) {
            it = fieldValidationError4;
            boolean bl = false;
            errors.add(it);
        }
        HawkScanMessages.AppConf appConf4 = $this$validate.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)appConf4, (String)"getApp(...)");
        FieldValidationError fieldValidationError5 = this.validateLoggedOutIndicator(appConf4);
        if (fieldValidationError5 != null) {
            it = fieldValidationError5;
            boolean bl = false;
            errors.add(it);
        }
        HawkScanMessages.HawkConf hawkConf = $this$validate.getHawk();
        Intrinsics.checkNotNullExpressionValue((Object)hawkConf, (String)"getHawk(...)");
        FieldValidationError fieldValidationError6 = this.validatePostmanConfig(hawkConf);
        if (fieldValidationError6 != null) {
            it = fieldValidationError6;
            boolean bl = false;
            errors.add(it);
        }
        Collection collection2 = errors;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    public final boolean isJWTAuth(@NotNull HawkScanMessages.AppConf $this$isJWTAuth) {
        Intrinsics.checkNotNullParameter((Object)$this$isJWTAuth, (String)"<this>");
        return $this$isJWTAuth.getAuthentication().hasTokenAuthorization() && $this$isJWTAuth.getAuthentication().getTokenAuthorization().getIsJWT();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> resolveDefaultConfigFiles(@NotNull String baseDir, @Nullable String applicationId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Iterable $this$map$iv = defaultConfigFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(baseDir + File.separator + it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!new File(it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ret = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)1);
        if (ret.isEmpty()) {
            if (applicationId != null) {
                String it2 = applicationId;
                boolean bl = false;
                return CollectionsKt.listOf((Object)("hawk://" + applicationId));
            }
            String nudge = "Visit https://app.stackhawk.com/applications to create a new StackHawk application and HawkScan configuration file.";
            throw new ConfException("No default configuration file (" + CollectionsKt.joinToString$default((Iterable)defaultConfigFiles, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ") found in " + baseDir, null, "config-verify.linting.missing-file", nudge, 2, null);
        }
        return ret;
    }

    public static /* synthetic */ List resolveDefaultConfigFiles$default(Config config, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return config.resolveDefaultConfigFiles(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HawkScanMessages.HawkscanConf parseStackHawkYamlFiles(@NotNull ConfigResolverOptions options, @Nullable StackHawkApiClient stackHawkApiClient) {
        Message ret$iv;
        void json$iv;
        void this_$iv;
        StackHawkApiClient it;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JsonObject defaultObj = this.mergeConfigs(options);
        String jsonString = null;
        jsonString = this.getGson().toJson((JsonElement)defaultObj);
        StackHawkApiClient stackHawkApiClient2 = stackHawkApiClient;
        if (stackHawkApiClient2 != null) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            it = stackHawkApiClient2;
            boolean bl = false;
            String string = jsonString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element");
            List<String> envVars = ConfigUtils.Companion.extractInterpolationVariables(string);
            UserSecretMessages.BulkLookupUserSecretResponse secretManagerVariables = PlatformApi.INSTANCE.getSecretsFromManager(envVars, stackHawkApiClient);
            List list = secretManagerVariables.getUserSecretsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUserSecretsList(...)");
            Iterable iterable = list;
            String string2 = jsonString;
            ConfigUtils.Companion companion = ConfigUtils.Companion;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void var15_16 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                UserSecretMessages.UserSecretValuePair it2 = (UserSecretMessages.UserSecretValuePair)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it2.getName(), (Object)it2.getValue());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            jsonString = ConfigUtils.Companion.replaceEnvVars$default(companion, string2, map, false, 4, null);
        }
        if (options.getValidate()) {
            this.getValidator().validateJson(this.getSchema(), jsonString);
        }
        it = Formatter.INSTANCE;
        String string = jsonString;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element");
        String bl = string;
        HawkScanMessages.HawkscanConf.Builder builder = HawkScanMessages.HawkscanConf.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        Message.Builder builder$iv = (Message.Builder)builder;
        boolean $i$f$parse = false;
        this_$iv.parser().merge((String)json$iv, builder$iv);
        Message message = ret$iv = builder$iv.build();
        if (message == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.stackhawk.nest.HawkScanMessages.HawkscanConf");
        }
        HawkScanMessages.HawkscanConf message2 = (HawkScanMessages.HawkscanConf)message;
        if (options.getValidate()) {
            Schema schema = this.getSchema();
            Object object = new ObjectMapper().readValue(jsonString, Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            this.validateConfig(message2, schema, object);
        }
        return message2;
    }

    @NotNull
    public final Map<String, Object> parseYamlTextAsMap(@NotNull String confText, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)confText, (String)"confText");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Map<String, Object> rawMap = ConfigUtils.Companion.loadYamlAsMap(this.getYaml(), confText, uri);
        Map yamlMap = Config.fixNumericTypes$default(this, rawMap, null, 2, null);
        return yamlMap;
    }

    @NotNull
    public final JsonObject parseYamlTextAsJsonObject(@NotNull String confText, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)confText, (String)"confText");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Map<String, Object> map = this.parseYamlTextAsMap(confText, uri);
        String overlayJson = this.getGson().toJson(map);
        JsonObject overlayJsonObject = (JsonObject)this.getGson().fromJson(overlayJson, JsonObject.class);
        Gson gson = this.getGson();
        JsonFormat.Printer printer = JsonFormat.printer();
        HawkScanMessages.HawkscanConf.Builder builder = HawkScanMessages.HawkscanConf.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        JsonObject defaultObj = (JsonObject)gson.fromJson(printer.print((MessageOrBuilder)this.withDefaults(builder)), JsonObject.class);
        JsonObject jsonObject = this.getGsonDeepMerge().deepMerge(defaultObj, overlayJsonObject);
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"deepMerge(...)");
        return jsonObject;
    }

    private final Pair<JsonObject, AssetValidationMessages.Marker> parseYamlTextAsJsonObjectWithMarker(String interpolatedConfText, URI uri) {
        Pair pair;
        try {
            pair = new Pair((Object)this.parseYamlTextAsJsonObject(interpolatedConfText, uri), null);
        }
        catch (Exception e) {
            Pair pair2;
            Exception exception = e;
            if (exception instanceof InvalidYamlFileException) {
                pair2 = new Pair(null, (Object)((InvalidYamlFileException)e).toAssetValidationMarker());
            } else if (exception instanceof IllegalArgumentException) {
                pair2 = new Pair(null, (Object)this.toAssetValidationMarker((IllegalArgumentException)e));
            } else {
                throw e;
            }
            pair = pair2;
        }
        return pair;
    }

    private final Pair<String, List<AssetValidationMessages.Marker>> parseJsonObjectToValidatedJsonStringMarkers(JsonObject jsonObject) {
        Pair pair;
        String jsonString = null;
        try {
            jsonString = this.getGson().toJson((JsonElement)jsonObject);
            this.getValidator().validateJson(this.getSchema(), jsonString);
            pair = new Pair((Object)jsonString, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            Pair pair2;
            Exception exception = e;
            if (exception instanceof MissingPathException) {
                pair2 = new Pair((Object)jsonString, (Object)CollectionsKt.listOf((Object)this.toAssetValidationMarker((SchemaException)e)));
            } else if (exception instanceof ValidationException) {
                pair2 = new Pair((Object)jsonString, this.toAssetValidationMarkers((ValidationException)e));
            } else if (exception instanceof SchemaException) {
                pair2 = new Pair((Object)jsonString, (Object)CollectionsKt.listOf((Object)this.toAssetValidationMarker((SchemaException)e)));
            } else {
                throw e;
            }
            pair = pair2;
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<HawkScanMessages.HawkscanConf, List<AssetValidationMessages.Marker>> parseJsonStringToHawkScanConfWithMarkers(String jsonString) {
        Formatter formatter;
        HawkScanMessages.HawkscanConf hawkScanConf = HawkScanMessages.HawkscanConf.getDefaultInstance();
        try {
            Message ret$iv;
            void builder$iv;
            void this_$iv;
            formatter = Formatter.INSTANCE;
            HawkScanMessages.HawkscanConf.Builder builder = HawkScanMessages.HawkscanConf.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
            Message.Builder builder2 = (Message.Builder)builder;
            boolean $i$f$parse = false;
            this_$iv.parser().merge(jsonString, (Message.Builder)builder$iv);
            Message message = ret$iv = builder$iv.build();
            if (message == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.stackhawk.nest.HawkScanMessages.HawkscanConf");
            }
            hawkScanConf = (HawkScanMessages.HawkscanConf)message;
            formatter = hawkScanConf;
            Intrinsics.checkNotNull((Object)formatter);
            Schema schema = this.getSchema();
            Object object = new ObjectMapper().readValue(jsonString, Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            this.validateConfig((HawkScanMessages.HawkscanConf)formatter, schema, object);
            formatter = hawkScanConf;
            Intrinsics.checkNotNull((Object)formatter);
            formatter = new Pair((Object)formatter, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            Pair pair;
            Exception exception = e;
            if (exception instanceof ListValidationException) {
                pair = new Pair((Object)hawkScanConf, this.toAssetValidationMarkers((ListValidationException)e));
            } else if (exception instanceof InvalidProtocolBufferException) {
                pair = new Pair((Object)hawkScanConf, (Object)CollectionsKt.listOf((Object)this.toAssetValidationMarker((InvalidProtocolBufferException)e)));
            } else {
                throw e;
            }
            formatter = pair;
        }
        return formatter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<HawkScanMessages.HawkscanConf, List<AssetValidationMessages.Marker>> parseYamlTextAsValidatedHawkScanConfig(@NotNull String interpolatedConfText, @NotNull URI uri) {
        Pair pair;
        JsonObject jsonObject;
        block5: {
            Object object;
            Object v0;
            block7: {
                block6: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)interpolatedConfText, (String)"interpolatedConfText");
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    Pair<JsonObject, AssetValidationMessages.Marker> pair2 = this.parseYamlTextAsJsonObjectWithMarker(interpolatedConfText, uri);
                    jsonObject = (JsonObject)pair2.component1();
                    AssetValidationMessages.Marker yamlMarker = (AssetValidationMessages.Marker)pair2.component2();
                    if (jsonObject != null) break block5;
                    v0 = null;
                    object = yamlMarker;
                    if (object == null) break block6;
                    AssetValidationMessages.Marker marker = object;
                    Object var12_8 = v0;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)it);
                    v0 = var12_8;
                    object = list;
                    if (list != null) break block7;
                }
                object = CollectionsKt.emptyList();
            }
            Object object2 = object;
            Object var14_12 = v0;
            return new Pair(var14_12, object2);
        }
        Pair<String, List<AssetValidationMessages.Marker>> pair3 = this.parseJsonObjectToValidatedJsonStringMarkers(jsonObject);
        String jsonString = (String)pair3.component1();
        List jsonMarkers = (List)pair3.component2();
        if (jsonString == null) {
            pair = new Pair(null, (Object)jsonMarkers);
        } else {
            Pair<HawkScanMessages.HawkscanConf, List<AssetValidationMessages.Marker>> pair4 = this.parseJsonStringToHawkScanConfWithMarkers(jsonString);
            HawkScanMessages.HawkscanConf hawkscanConf = (HawkScanMessages.HawkscanConf)pair4.component1();
            List protoMarkers = (List)pair4.component2();
            pair = new Pair((Object)hawkscanConf, (Object)CollectionsKt.plus((Collection)protoMarkers, (Iterable)jsonMarkers));
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject mergeConfigs(@NotNull ConfigResolverOptions options) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Iterable iterable = options.getFiles();
        Gson gson = this.getGson();
        JsonFormat.Printer printer = JsonFormat.printer();
        HawkScanMessages.HawkscanConf.Builder builder = HawkScanMessages.HawkscanConf.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        Object object = gson.fromJson(printer.print((MessageOrBuilder)this.withDefaults(builder)), JsonObject.class);
        boolean $i$f$fold = false;
        JsonObject accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            JsonObject jsonObject;
            void filePath;
            String string = (String)element$iv;
            JsonObject defaultObj = accumulator$iv;
            boolean bl = false;
            URI fileUri = ConfigUtils.Companion.getFileUri((String)filePath);
            String confFile = ConfigUtils.Companion.getConfigFileText(fileUri, options.getHttpClient(), options.getAssetManagerClient());
            if (((CharSequence)confFile).length() > 0) {
                String confText = ConfigUtils.Companion.replaceEnvVars$default(ConfigUtils.Companion, confFile, options.getEnvMap(), false, 4, null);
                Map<String, Object> yamlMap = INSTANCE.parseYamlTextAsMap(confText, fileUri);
                Map<String, Object> map = INSTANCE.injectVariables(yamlMap, options.getAppVariables());
                String overlayJson = INSTANCE.getGson().toJson(map);
                JsonObject overlayJsonObject = (JsonObject)INSTANCE.getGson().fromJson(overlayJson, JsonObject.class);
                try {
                    jsonObject = INSTANCE.getGsonDeepMerge().deepMerge(defaultObj, overlayJsonObject);
                }
                catch (IllegalStateException ise) {
                    INSTANCE.getValidator().validateJson(INSTANCE.getSchema(), overlayJson);
                    throw ise;
                }
            } else {
                String path = !Intrinsics.areEqual((Object)options.getBaseDir(), (Object)"") ? " in " + options.getBaseDir() : "";
                if (ConfigUtils.Companion.doesLocalFileExist(fileUri, false)) {
                    throw new InvalidYamlFileException("Invalid Yaml File: " + fileUri, new File(fileUri.getPath()), null, null, 12, null);
                }
                throw new ConfException("File does not exist (" + (String)filePath + ")" + path, null, "config-verify.linting.missing-file", null, 10, null);
            }
            accumulator$iv = jsonObject;
        }
        void var2_20 = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)var2_20, (String)"fold(...)");
        return (JsonObject)var2_20;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> parseEnvVarsFile(@Nullable String filePath) {
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists()) {
                Properties props = new Properties();
                String string = FilesKt.readText$default((File)file, null, (int)1, null);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                props.load(new ByteArrayInputStream(byArray));
                Set<String> set = props.stringPropertyNames();
                Intrinsics.checkNotNullExpressionValue(set, (String)"stringPropertyNames(...)");
                Iterable $this$associateWith$iv = set;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void it;
                    String string2 = (String)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map = result$iv;
                    boolean bl = false;
                    String string3 = props.getProperty((String)it);
                    map.put(t, string3);
                }
                return result$iv;
            }
            throw new ConfException("Environment variables file not found at " + filePath, null, null, null, 14, null);
        }
        return MapsKt.emptyMap();
    }

    @NotNull
    public final Map<String, Object> injectVariables(@NotNull Map<String, Object> $this$injectVariables, @NotNull AppVariables appVariables) {
        block2: {
            Intrinsics.checkNotNullParameter($this$injectVariables, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)appVariables, (String)"appVariables");
            Object object = $this$injectVariables.get("app");
            if (object == null) break block2;
            Object m = object;
            boolean bl = false;
            Map appMap = TypeIntrinsics.asMutableMap((Object)m);
            CharSequence charSequence = appVariables.getApplicationId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                appMap.put("applicationId", appVariables.getApplicationId());
            }
            if (!((charSequence = (CharSequence)appVariables.getEnvironment()) == null || charSequence.length() == 0)) {
                appMap.put("env", appVariables.getEnvironment());
            }
            Intrinsics.checkNotNull((Object)appMap, (String)"null cannot be cast to non-null type kotlin.Any");
            $this$injectVariables.put("app", appMap);
        }
        return $this$injectVariables;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> fixNumericTypes(Map<String, Object> yamlMap, String baseKey) {
        void $this$fold$iv;
        void initial$iv;
        Pair item$iv$iv;
        void $this$mapTo$iv$iv;
        Object $this$map$iv = yamlMap;
        boolean $i$f$map22 = false;
        Map<String, Object> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void entry;
            Pair pair2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object mv = entry.getValue();
            if (mv instanceof Map) {
                if (Intrinsics.areEqual((Object)baseKey, (Object)"app.api.")) {
                    var13_16 = entry;
                    pair = new Pair(var13_16.getKey(), var13_16.getValue());
                } else {
                    pair = TuplesKt.to(entry.getKey(), INSTANCE.fixNumericTypes(TypeIntrinsics.asMutableMap(mv), baseKey + entry.getKey() + "."));
                }
            } else if (mv instanceof Iterable) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                var13_16 = (Iterable)mv;
                Object k = entry.getKey();
                boolean $i$f$map = false;
                void var16_19 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Map<String, Object> map2;
                    void i;
                    Object item$iv$iv2;
                    Object t = item$iv$iv2 = iterator2.next();
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    if (i instanceof Map) {
                        Intrinsics.checkNotNull((Object)i, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        map2 = INSTANCE.fixNumericTypes(TypeIntrinsics.asMutableMap((Object)i), baseKey + entry.getKey() + ".");
                    } else {
                        map2 = i;
                    }
                    collection2.add(map2);
                }
                pair = TuplesKt.to(k, (Object)((List)destination$iv$iv2));
            } else {
                var13_16 = INSTANCE.fixNumericType((Map.Entry<String, ? extends Object>)entry, baseKey);
                pair = new Pair(var13_16.getKey(), var13_16.getValue());
            }
            collection.add(pair);
        }
        $this$map$iv = (List)destination$iv$iv;
        Map $i$f$map22 = new LinkedHashMap();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void pair;
            item$iv$iv = (Pair)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            acc.put(pair.getFirst(), pair.getSecond());
            accumulator$iv = acc;
        }
        return accumulator$iv;
    }

    static /* synthetic */ Map fixNumericTypes$default(Config config, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return config.fixNumericTypes(map, string);
    }

    private final Map.Entry<String, Object> fixNumericType(Map.Entry<String, ? extends Object> entry, String baseKey) {
        Object object;
        block12: {
            block11: {
                Object object2;
                String key = baseKey + entry.getKey();
                String[] stringArray = new String[]{"."};
                object = this.getNpr().lookupByFieldChain(StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null), hawkscanConfRoot);
                if (object == null) break block11;
                DescriptorProtos.FieldDescriptorProto fd = object;
                boolean bl = false;
                DescriptorProtos.FieldDescriptorProto.Type type = fd.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Object intVal = entry.getValue();
                        if (intVal instanceof Number) {
                            object2 = ((Number)intVal).intValue();
                            break;
                        }
                        if (intVal instanceof String) {
                            object2 = Integer.parseInt((String)intVal);
                            break;
                        }
                        object2 = entry.getValue();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        Object longVal = entry.getValue();
                        if (longVal instanceof Number) {
                            object2 = ((Number)longVal).longValue();
                            break;
                        }
                        if (longVal instanceof String) {
                            object2 = Long.parseLong((String)longVal);
                            break;
                        }
                        object2 = entry.getValue();
                        break;
                    }
                    default: {
                        object2 = entry.getValue();
                    }
                }
                object = object2;
                if (object2 != null) break block12;
            }
            object = entry.getValue();
        }
        Object newValue = object;
        return (Map.Entry)CollectionsKt.first((Iterable)MapsKt.mapOf((Pair)TuplesKt.to((Object)entry.getKey(), (Object)newValue)).entrySet());
    }

    static /* synthetic */ Map.Entry fixNumericType$default(Config config, Map.Entry entry, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return config.fixNumericType(entry, string);
    }

    private final void validateConfig(HawkScanMessages.HawkscanConf conf, Schema schema, Object document) {
        List<FieldValidationError> list = this.validate(conf);
        if (list == null) {
            return;
        }
        List<FieldValidationError> errors = list;
        Collection encodingErrors = new ArrayList();
        Iterable $this$forEach$iv = errors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldValidationError it = (FieldValidationError)element$iv;
            boolean bl = false;
            encodingErrors.add(new HawkScanConfigValidationError(new URI(it.getPath()), document, schema, it.getMessage()));
        }
        throw new ListValidationException(encodingErrors);
    }

    @NotNull
    public final String toJson(@NotNull HawkScanMessages.HawkscanConf $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        String string = Formatter.INSTANCE.printer().print((MessageOrBuilder)$this$toJson);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    @NotNull
    public final HawkScanMessages.HawkscanConf.Builder withDefaults(@NotNull HawkScanMessages.HawkscanConf.Builder $this$withDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$withDefaults, (String)"<this>");
        HawkScanMessages.HawkscanConf.Builder builder = $this$withDefaults.setApp($this$withDefaults.getAppBuilder());
        HawkScanMessages.HawkConf.Builder builder2 = $this$withDefaults.getHawkBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"getHawkBuilder(...)");
        HawkScanMessages.HawkscanConf.Builder builder3 = builder.setHawk(this.withDefaults(builder2));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setHawk(...)");
        return builder3;
    }

    @NotNull
    public final HawkScanMessages.HawkConf.Builder withDefaults(@NotNull HawkScanMessages.HawkConf.Builder $this$withDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$withDefaults, (String)"<this>");
        HawkScanMessages.HawkConf.Spider.Builder builder = $this$withDefaults.getSpiderBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getSpiderBuilder(...)");
        HawkScanMessages.HawkConf.Builder builder2 = $this$withDefaults.setSpider(this.withDefaults(builder)).setStartupTimeoutMinutes(5);
        HawkScanMessages.HawkConf.ScanConf.Builder builder3 = $this$withDefaults.getScanBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"getScanBuilder(...)");
        HawkScanMessages.HawkConf.Builder builder4 = builder2.setScan(this.withDefaults(builder3));
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setScan(...)");
        return builder4;
    }

    @NotNull
    public final HawkScanMessages.HawkConf.Spider.Builder withDefaults(@NotNull HawkScanMessages.HawkConf.Spider.Builder $this$withDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$withDefaults, (String)"<this>");
        HawkScanMessages.HawkConf.Spider.Builder builder = $this$withDefaults.setBase(true).setMaxDurationMinutes(5);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setMaxDurationMinutes(...)");
        return builder;
    }

    @NotNull
    public final HawkScanMessages.HawkConf.ScanConf.Builder withDefaults(@NotNull HawkScanMessages.HawkConf.ScanConf.Builder $this$withDefaults) {
        Intrinsics.checkNotNullParameter((Object)$this$withDefaults, (String)"<this>");
        HawkScanMessages.HawkConf.ScanConf.Builder builder = $this$withDefaults.setConcurrentRequests(20L).setThrottlePassiveBacklog(10000L);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setThrottlePassiveBacklog(...)");
        return builder;
    }

    private static final boolean _get_validator_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LogManager.getLogger(Config.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Config.logger = logger;
        Object[] objectArray = new String[]{"stackhawk.yml", "stackhawk.yaml"};
        defaultConfigFiles = CollectionsKt.listOf((Object[])objectArray);
        quotedStringRegex = Pattern.compile(" with \"(.*)\"");
        additionalPropertiesString = Pattern.compile(".*/(.*)/additionalProperties with \"False\"");
        validationErrorsPrefix = "Validation errors: ";
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DescriptorProtos.FieldDescriptorProto.Type.values().length];
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

