/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.config;

import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.BasicHttpClient;
import com.stackhawk.hste.extension.talon.config.ConfigUtils;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidYamlFileException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScannerConfigException;
import com.stackhawk.nest.HostedAssetMessages;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stackhawk/hste/extension/talon/config/ConfigUtils;", "", "()V", "Companion", "talon-common"})
public final class ConfigUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LogManager.getLogger(Companion.getClass());

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rJ$\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rJ*\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\"2\b\b\u0002\u0010#\u001a\u00020\u0007J\n\u0010$\u001a\u00020%*\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stackhawk/hste/extension/talon/config/ConfigUtils$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "doesLocalFileExist", "", "uri", "Ljava/net/URI;", "isRemoteUri", "extractInterpolationVariables", "", "", "confText", "getConfigFileText", "httpClient", "Lcom/stackhawk/hste/extension/talon/client/BasicHttpClient;", "assetManagerClient", "Lcom/stackhawk/hste/extension/talon/client/AssetManagerClient;", "getFileText", "getFileUri", "uriString", "getHostedText", "getRemoteText", "isRemoteUriString", "loadYamlAsMap", "", "yaml", "Lorg/yaml/snakeyaml/Yaml;", "missingEnvVarRegex", "Lkotlin/text/Regex;", "replaceEnvVars", "envMap", "", "enableUndefinedVariableException", "fileLocation", "Lcom/stackhawk/hste/extension/talon/config/ConfigUtils$Companion$FileLocation;", "FileLocation", "talon-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRemoteUriString(@NotNull String uriString) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            LOG.debug("Checking for remote on config " + uriString);
            URI uri = this.getFileUri(uriString);
            return this.isRemoteUri(uri);
        }

        public final boolean isRemoteUri(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return switch (WhenMappings.$EnumSwitchMapping$0[this.fileLocation(uri).ordinal()]) {
                case 1, 2 -> true;
                default -> false;
            };
        }

        @NotNull
        public final URI getFileUri(@NotNull String uriString) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            try {
                LOG.debug("Attempting to parse config " + uriString + " as URI.");
                return new URI(uriString);
            }
            catch (Exception ex) {
                LOG.debug("Attempting to parse config " + uriString + " as file.");
                URI uRI = new File(uriString).toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                return uRI;
            }
        }

        public final boolean doesLocalFileExist(@NotNull URI uri, boolean isRemoteUri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return isRemoteUri ? false : new File(uri.getPath()).exists();
        }

        @NotNull
        public final String getConfigFileText(@NotNull URI uri, @NotNull BasicHttpClient httpClient, @Nullable AssetManagerClient assetManagerClient) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            return switch (WhenMappings.$EnumSwitchMapping$0[this.fileLocation(uri).ordinal()]) {
                case 1 -> this.getRemoteText(uri, httpClient);
                case 3 -> this.getFileText(uri);
                case 2 -> this.getHostedText(uri, assetManagerClient);
                default -> throw new IllegalArgumentException("Unsupported file location: " + this.fileLocation(uri));
            };
        }

        public static /* synthetic */ String getConfigFileText$default(Companion companion, URI uRI, BasicHttpClient basicHttpClient, AssetManagerClient assetManagerClient, int n, Object object) {
            if ((n & 2) != 0) {
                basicHttpClient = Utils.INSTANCE.createHttpClient();
            }
            if ((n & 4) != 0) {
                assetManagerClient = null;
            }
            return companion.getConfigFileText(uRI, basicHttpClient, assetManagerClient);
        }

        @NotNull
        public final String replaceEnvVars(@NotNull String confText, @NotNull Map<String, String> envMap, boolean enableUndefinedVariableException) {
            Intrinsics.checkNotNullParameter((Object)confText, (String)"confText");
            Intrinsics.checkNotNullParameter(envMap, (String)"envMap");
            StringSubstitutor sub = new StringSubstitutor(StringLookupFactory.INSTANCE.mapStringLookup(envMap), StringSubstitutor.DEFAULT_PREFIX, StringSubstitutor.DEFAULT_SUFFIX, '$', StringMatcherFactory.INSTANCE.stringMatcher(":"));
            sub.setEnableUndefinedVariableException(enableUndefinedVariableException);
            String string = sub.replace(confText);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            return string;
        }

        public static /* synthetic */ String replaceEnvVars$default(Companion companion, String string, Map map, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.replaceEnvVars(string, map, bl);
        }

        @NotNull
        public final Map<String, Object> loadYamlAsMap(@NotNull Yaml yaml, @NotNull String confText, @NotNull URI uri) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
            Intrinsics.checkNotNullParameter((Object)confText, (String)"confText");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            try {
                object = yaml.load(confText);
                Intrinsics.checkNotNull((Object)object);
                object = (Map)object;
            }
            catch (Exception e) {
                Exception exception = e;
                if ((exception instanceof YAMLException ? true : exception instanceof ClassCastException) ? true : exception instanceof NullPointerException) {
                    throw new InvalidYamlFileException("Invalid Yaml File: " + uri, new File(uri.getPath()), e, null, 8, null);
                }
                throw e;
            }
            return object;
        }

        @NotNull
        public final String getFileText(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return FilesKt.readText$default((File)new File(uri.getPath()), null, (int)1, null);
        }

        @NotNull
        public final String getRemoteText(@NotNull URI uri, @NotNull BasicHttpClient httpClient) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String configFileText = BasicHttpClient.getStringBody$default(httpClient, string, null, 2, null);
            httpClient.getHttpClient().stop();
            return configFileText;
        }

        @NotNull
        public final String getHostedText(@NotNull URI uri, @Nullable AssetManagerClient assetManagerClient) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            AssetManagerClient assetManagerClient2 = assetManagerClient;
            if (assetManagerClient2 != null) {
                AssetManagerClient it = assetManagerClient2;
                boolean bl = false;
                Pair<String, String> pair = it.resolveOrgAssetName(uri);
                String organizationId = (String)pair.component1();
                String assetName = (String)pair.component2();
                v1 = IOUtils.toString((InputStream)AssetManagerClient.getRawAsset$default(it, organizationId, HostedAssetMessages.HostedAssetType.HAWKSCAN_CONFIGURATION, assetName, null, 8, null), (Charset)Charset.defaultCharset());
            } else {
                v1 = string = null;
            }
            if (string == null) {
                throw new ScannerConfigException("Invalid hosted asset URI: " + uri, null, null, 6, null);
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final FileLocation fileLocation(@NotNull URI $this$fileLocation) {
            Intrinsics.checkNotNullParameter((Object)$this$fileLocation, (String)"<this>");
            var2_2 = $this$fileLocation.getScheme();
            if (var2_2 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var2_2.hashCode()) {
                case 99053702: {
                    if (var2_2.equals("hawks")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3143036: {
                    if (var2_2.equals("file")) {
                        tmp = 2;
                    }
                    break;
                }
                case 3213448: {
                    if (var2_2.equals("http")) {
                        tmp = 3;
                    }
                    break;
                }
                case 99617003: {
                    if (var2_2.equals("https")) {
                        tmp = 3;
                    }
                    break;
                }
                case 3195277: {
                    if (var2_2.equals("hawk")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    v0 = FileLocation.REMOTE;
                    break;
                }
                case 1: {
                    v0 = FileLocation.HOSTED;
                    break;
                }
                case 2: lbl-1000:
                // 2 sources

                {
                    v0 = FileLocation.LOCAL;
                    break;
                }
                default: {
                    v0 = FileLocation.UNKNOWN;
                }
            }
            return v0;
        }

        @NotNull
        public final Regex missingEnvVarRegex() {
            String escape = "\\$";
            String prefix = "\\{";
            String suffix = "\\}";
            String match = "(\\w+)(?::[^}]*)?";
            String str = escape + prefix + match + suffix;
            return new Regex(str);
        }

        @NotNull
        public final List<String> extractInterpolationVariables(@NotNull String confText) {
            Intrinsics.checkNotNullParameter((Object)confText, (String)"confText");
            Regex pattern = this.missingEnvVarRegex();
            Sequence matches2 = SequencesKt.map((Sequence)Regex.findAll$default((Regex)pattern, (CharSequence)confText, (int)0, (int)2, null), (Function1)extractInterpolationVariables.matches.1.INSTANCE);
            return SequencesKt.toList((Sequence)matches2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stackhawk/hste/extension/talon/config/ConfigUtils$Companion$FileLocation;", "", "(Ljava/lang/String;I)V", "LOCAL", "REMOTE", "HOSTED", "UNKNOWN", "talon-common"})
        public static final class FileLocation
        extends Enum<FileLocation> {
            public static final /* enum */ FileLocation LOCAL = new FileLocation();
            public static final /* enum */ FileLocation REMOTE = new FileLocation();
            public static final /* enum */ FileLocation HOSTED = new FileLocation();
            public static final /* enum */ FileLocation UNKNOWN = new FileLocation();
            private static final /* synthetic */ FileLocation[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static FileLocation[] values() {
                return (FileLocation[])$VALUES.clone();
            }

            public static FileLocation valueOf(String value) {
                return Enum.valueOf(FileLocation.class, value);
            }

            @NotNull
            public static EnumEntries<FileLocation> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = fileLocationArray = new FileLocation[]{FileLocation.LOCAL, FileLocation.REMOTE, FileLocation.HOSTED, FileLocation.UNKNOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileLocation.values().length];
                try {
                    nArray[FileLocation.REMOTE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileLocation.HOSTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileLocation.LOCAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

