/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.hawkscan;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.stackhawk.hste.extension.talon.client.StackHawkAWSClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.hawkscan.DownloadedCrawlPlan;
import com.stackhawk.http.HttpClientImpl;
import com.stackhawk.nest.FlockMessages;
import com.stackhawk.nest.json.Formatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/CrawlPlanDownloader;", "", "stackhawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "awsClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkAWSClient;", "scanId", "", "(Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;Lcom/stackhawk/hste/extension/talon/client/StackHawkAWSClient;Ljava/lang/String;)V", "downloadCrawlPlanFromPresignedUrl", "Lcom/stackhawk/hste/extension/talon/hawkscan/DownloadedCrawlPlan;", "crawlPlanResult", "Lcom/stackhawk/nest/FlockMessages$CrawlPlanResult;", "downloadCrawlPlans", "", "requestCrawlPlansFromPlatform", "Lcom/stackhawk/nest/FlockMessages$GenerateCrawlPlanResponse;", "Companion", "talon-common"})
@SourceDebugExtension(value={"SMAP\nCrawlPlanDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrawlPlanDownloader.kt\ncom/stackhawk/hste/extension/talon/hawkscan/CrawlPlanDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1603#2,9:130\n1855#2:139\n1856#2:141\n1612#2:142\n1#3:140\n*S KotlinDebug\n*F\n+ 1 CrawlPlanDownloader.kt\ncom/stackhawk/hste/extension/talon/hawkscan/CrawlPlanDownloader\n*L\n58#1:130,9\n58#1:139\n58#1:141\n58#1:142\n58#1:140\n*E\n"})
public final class CrawlPlanDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StackHawkApiClient stackhawkApiClient;
    @NotNull
    private final StackHawkAWSClient awsClient;
    @NotNull
    private final String scanId;
    @NotNull
    private static final Logger LOG;

    public CrawlPlanDownloader(@NotNull StackHawkApiClient stackhawkApiClient, @NotNull StackHawkAWSClient awsClient, @NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)stackhawkApiClient, (String)"stackhawkApiClient");
        Intrinsics.checkNotNullParameter((Object)awsClient, (String)"awsClient");
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        this.stackhawkApiClient = stackhawkApiClient;
        this.awsClient = awsClient;
        this.scanId = scanId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DownloadedCrawlPlan> downloadCrawlPlans() {
        void $this$mapNotNullTo$iv$iv;
        LOG.debug("Requesting crawl plans from platform for scan: " + this.scanId);
        FlockMessages.GenerateCrawlPlanResponse generateCrawlPlanResponse = this.requestCrawlPlansFromPlatform();
        if (generateCrawlPlanResponse == null) {
            CrawlPlanDownloader $this$downloadCrawlPlans_u24lambda_u240 = this;
            boolean bl = false;
            LOG.debug("No crawl plan response from platform");
            return CollectionsKt.emptyList();
        }
        FlockMessages.GenerateCrawlPlanResponse response2 = generateCrawlPlanResponse;
        if (response2.getCrawlPlansList().isEmpty()) {
            LOG.info("Platform returned empty crawl plans list (this is OK, continuing)");
            return CollectionsKt.emptyList();
        }
        LOG.info("Platform returned " + response2.getCrawlPlansList().size() + " crawl plan(s)");
        List list = response2.getCrawlPlansList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCrawlPlansList(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DownloadedCrawlPlan it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            FlockMessages.CrawlPlanResult crawlPlanResult = (FlockMessages.CrawlPlanResult)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)crawlPlanResult);
            if (this.downloadCrawlPlanFromPresignedUrl(crawlPlanResult) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List downloadedPlans = (List)destination$iv$iv;
        if (downloadedPlans.isEmpty()) {
            List list2 = response2.getCrawlPlansList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCrawlPlansList(...)");
            if (!((Collection)list2).isEmpty()) {
                LOG.warn("Failed to download all crawl plans (" + response2.getCrawlPlansList().size() + " available)");
            }
        }
        return downloadedPlans;
    }

    private final FlockMessages.GenerateCrawlPlanResponse requestCrawlPlansFromPlatform() {
        FlockMessages.GenerateCrawlPlanResponse generateCrawlPlanResponse;
        try {
            generateCrawlPlanResponse = (FlockMessages.GenerateCrawlPlanResponse)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.stackhawkApiClient.getDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FlockMessages.GenerateCrawlPlanResponse>, Object>(this, null){
                int label;
                final /* synthetic */ CrawlPlanDownloader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void this_$iv;
                            ResultKt.throwOnFailure((Object)object);
                            String uri = "/scan/" + CrawlPlanDownloader.access$getScanId$p(this.this$0) + "/crawl-plan";
                            StackHawkApiClient stackHawkApiClient = CrawlPlanDownloader.access$getStackhawkApiClient$p(this.this$0);
                            GeneratedMessageV3 resultBuilder$iv = (GeneratedMessageV3)FlockMessages.GenerateCrawlPlanResponse.getDefaultInstance();
                            boolean $i$f$get = false;
                            this.label = 1;
                            Object object3 = this_$iv.getTyped(uri, (Function1<? super RequestConfig.Builder, Unit>)((Function1)StackHawkApiClient.get.2.INSTANCE), (Function1)new Function1<SimpleHttpResponse, FlockMessages.GenerateCrawlPlanResponse>(resultBuilder$iv){
                                final /* synthetic */ GeneratedMessageV3 $resultBuilder;
                                {
                                    this.$resultBuilder = $resultBuilder;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final FlockMessages.GenerateCrawlPlanResponse invoke(@NotNull SimpleHttpResponse $this$getTyped) {
                                    void builder$iv;
                                    void json$iv;
                                    void this_$iv;
                                    Intrinsics.checkNotNullParameter((Object)$this$getTyped, (String)"$this$getTyped");
                                    HttpClientImpl.Companion.validateResponse$default((HttpClientImpl.Companion)HttpClientImpl.Companion, (SimpleHttpResponse)$this$getTyped, null, (int)1, null);
                                    Formatter formatter = Formatter.INSTANCE;
                                    String string = $this$getTyped.getBodyText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBodyText(...)");
                                    String string2 = string;
                                    MessageLite.Builder builder = this.$resultBuilder.newBuilderForType();
                                    Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilderForType(...)");
                                    Message.Builder builder2 = (Message.Builder)builder;
                                    boolean $i$f$parse = false;
                                    this_$iv.parser().merge((String)json$iv, (Message.Builder)builder$iv);
                                    Message ret$iv = builder$iv.build();
                                    return (GeneratedMessageV3)((FlockMessages.GenerateCrawlPlanResponse)ret$iv);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$get = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super FlockMessages.GenerateCrawlPlanResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Exception e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"404", (boolean)false, (int)2, null) : false;
            if (bl) {
                LOG.info("Crawl plans not yet available from platform (404) - this is OK");
            } else {
                String string2 = e.getMessage();
                boolean bl2 = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"403", (boolean)false, (int)2, null) : false;
                if (bl2) {
                    LOG.warn("Insufficient permissions to retrieve crawl plans (403)");
                } else {
                    LOG.warn("Failed to retrieve crawl plans from platform: " + e.getMessage(), (Throwable)e);
                }
            }
            generateCrawlPlanResponse = null;
        }
        return generateCrawlPlanResponse;
    }

    private final DownloadedCrawlPlan downloadCrawlPlanFromPresignedUrl(FlockMessages.CrawlPlanResult crawlPlanResult) {
        DownloadedCrawlPlan downloadedCrawlPlan;
        try {
            LOG.debug("Downloading crawl plan for spec: " + crawlPlanResult.getSpecId());
            File tempFile = Files.createTempFile("crawl-plan-" + crawlPlanResult.getSpecId() + "-", ".json", new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            String string = crawlPlanResult.getPresignedUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresignedUrl(...)");
            InputStream inputStream = this.awsClient.getFileAssetFromS3(string);
            Intrinsics.checkNotNull((Object)tempFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(tempFile));
            LOG.info("Successfully downloaded crawl plan to temp file: " + tempFile.getAbsolutePath());
            String string2 = crawlPlanResult.getSpecId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecId(...)");
            FlockMessages.CrawlPlanStats crawlPlanStats = crawlPlanResult.getStats();
            Intrinsics.checkNotNullExpressionValue((Object)crawlPlanStats, (String)"getStats(...)");
            downloadedCrawlPlan = new DownloadedCrawlPlan(string2, tempFile, crawlPlanStats);
        }
        catch (Exception e) {
            LOG.error("Failed to download crawl plan for " + crawlPlanResult.getSpecId() + ": " + e.getMessage(), (Throwable)e);
            downloadedCrawlPlan = null;
        }
        return downloadedCrawlPlan;
    }

    public static final /* synthetic */ String access$getScanId$p(CrawlPlanDownloader $this) {
        return $this.scanId;
    }

    public static final /* synthetic */ StackHawkApiClient access$getStackhawkApiClient$p(CrawlPlanDownloader $this) {
        return $this.stackhawkApiClient;
    }

    static {
        Logger logger = LogManager.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/CrawlPlanDownloader$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getLOG", "()Lorg/apache/logging/log4j/Logger;", "talon-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

