/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.hawkscan;

import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.hawkscan.api.PlatformConfigException;
import com.stackhawk.nest.HostedAssetMessages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/HostedOASDownloader;", "", "hostedOASIds", "", "", "sessionDir", "Ljava/nio/file/Path;", "stackhawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "orgId", "appId", "usePlatform", "", "(Ljava/util/List;Ljava/nio/file/Path;Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "download", "", "Companion", "talon-common"})
@SourceDebugExtension(value={"SMAP\nHostedOASDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostedOASDownloader.kt\ncom/stackhawk/hste/extension/talon/hawkscan/HostedOASDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 HostedOASDownloader.kt\ncom/stackhawk/hste/extension/talon/hawkscan/HostedOASDownloader\n*L\n54#1:80\n54#1:81,3\n66#1:84,2\n*E\n"})
public final class HostedOASDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> hostedOASIds;
    @NotNull
    private final Path sessionDir;
    @NotNull
    private final StackHawkApiClient stackhawkApiClient;
    @Nullable
    private final String orgId;
    @Nullable
    private final String appId;
    @Nullable
    private final Boolean usePlatform;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String nudgeDocsOasUrl;

    public HostedOASDownloader(@NotNull List<String> hostedOASIds, @NotNull Path sessionDir, @NotNull StackHawkApiClient stackhawkApiClient, @Nullable String orgId, @Nullable String appId, @Nullable Boolean usePlatform) {
        Intrinsics.checkNotNullParameter(hostedOASIds, (String)"hostedOASIds");
        Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
        Intrinsics.checkNotNullParameter((Object)stackhawkApiClient, (String)"stackhawkApiClient");
        this.hostedOASIds = hostedOASIds;
        this.sessionDir = sessionDir;
        this.stackhawkApiClient = stackhawkApiClient;
        this.orgId = orgId;
        this.appId = appId;
        this.usePlatform = usePlatform;
    }

    public /* synthetic */ HostedOASDownloader(List list, Path path, StackHawkApiClient stackHawkApiClient, String string, String string2, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(list, path, stackHawkApiClient, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void download() {
        Iterator iterator;
        AssetManagerClient assetManagerClient = this.stackhawkApiClient.assetManagerClient();
        if (Intrinsics.areEqual((Object)this.usePlatform, (Object)true) && this.appId != null) {
            void $this$mapTo$iv$iv;
            LOG.info("Checking platform hosted OAS files");
            Pair<String, List<String>> downloadPresignedUrlsResp = assetManagerClient.getPlatformApplicationOASPresignedUrls(this.appId);
            if (!Intrinsics.areEqual((Object)downloadPresignedUrlsResp.getFirst(), (Object)this.appId)) {
                String nudgeReposOasUrl = "https://app.stackhawk.com/applications/" + this.appId + "/details/repositories";
                String nudge = "Visit " + nudgeReposOasUrl + " to associate discovered code repositories to this application.";
                Object[] objectArray = new String[]{nudgeReposOasUrl, nudgeDocsOasUrl};
                throw new PlatformConfigException("No code repositories have been mapped to this application.", SetsKt.setOf((Object[])objectArray), null, null, nudge, 12, null);
            }
            List presignedUrls = (List)downloadPresignedUrlsResp.getSecond();
            List<Pair<InputStream, String>> bulkPresignedUrls = assetManagerClient.bulkRawAssetsFromPresignedUrls(presignedUrls, HostedAssetMessages.HostedAssetType.OPEN_API_SPEC);
            LOG.info("Downloading " + bulkPresignedUrls.size() + " platform hosted OAS files");
            if (bulkPresignedUrls.isEmpty()) {
                String nudgeAppOasUrl = "https://app.stackhawk.com/applications/" + this.appId + "/details/oas";
                String nudge = "Visit " + nudgeAppOasUrl + " to include generated OpenAPI specifications with OpenAPI scanning.";
                Object[] objectArray = new String[]{nudgeAppOasUrl, nudgeDocsOasUrl};
                throw new PlatformConfigException("No OpenAPI specifications are included with this application.", SetsKt.setOf((Object[])objectArray), null, null, nudge, 12, null);
            }
            Iterable $this$map$iv = bulkPresignedUrls;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                File file;
                void it;
                Object item$iv$iv = iterator.next();
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                InputStream inputStream = (InputStream)it.component1();
                String oasId = (String)it.component2();
                Path localAssetPath = this.sessionDir.resolve("oas/" + oasId + ".json");
                Files.deleteIfExists(localAssetPath);
                Files.createDirectories(this.sessionDir.resolve("oas"), new FileAttribute[0]);
                Files.createFile(localAssetPath, new FileAttribute[0]);
                Intrinsics.checkNotNullExpressionValue((Object)localAssetPath.toFile(), (String)"toFile(...)");
                IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
                LOG.info("Successfully created hosted OAS file " + localAssetPath);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        if (this.orgId != null && !((Collection)this.hostedOASIds).isEmpty()) {
            LOG.info("Downloading " + this.hostedOASIds.size() + " specified hosted OAS files");
            Iterable $this$forEach$iv = this.hostedOASIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String oasAssetId = (String)element$iv;
                boolean bl = false;
                Path localAssetPath = this.sessionDir.resolve("oas/" + oasAssetId + ".json");
                Files.deleteIfExists(localAssetPath);
                Files.createDirectories(this.sessionDir.resolve("oas"), new FileAttribute[0]);
                Files.createFile(localAssetPath, new FileAttribute[0]);
                InputStream inputStream = AssetManagerClient.getRawAsset$default(assetManagerClient, this.orgId, HostedAssetMessages.HostedAssetType.OPEN_API_SPEC, oasAssetId, null, 8, null);
                Intrinsics.checkNotNullExpressionValue((Object)localAssetPath.toFile(), (String)"toFile(...)");
                IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream((File)((Object)iterator)));
                LOG.info("Successfully created hosted OAS file " + localAssetPath);
            }
        }
    }

    static {
        Logger logger = LogManager.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        nudgeDocsOasUrl = "https://docs.stackhawk.com/web-app/api-discovery/oas-generation.html";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/HostedOASDownloader$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getLOG", "()Lorg/apache/logging/log4j/Logger;", "nudgeDocsOasUrl", "", "getNudgeDocsOasUrl", "()Ljava/lang/String;", "talon-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final String getNudgeDocsOasUrl() {
            return nudgeDocsOasUrl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

