/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.hawkscan;

import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.extension.talon.hawkscan.ScanResponseGrpcClient;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.nest.TalonMessages;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/ScanResponder;", "", "scanResponseGrpcClient", "Lcom/stackhawk/hste/extension/talon/hawkscan/ScanResponseGrpcClient;", "(Lcom/stackhawk/hste/extension/talon/hawkscan/ScanResponseGrpcClient;)V", "getScanResponseGrpcClient", "()Lcom/stackhawk/hste/extension/talon/hawkscan/ScanResponseGrpcClient;", "sendScanResponse", "", "response", "Lcom/stackhawk/nest/TalonMessages$TalonScanResponse;", "Companion", "talon-common"})
public final class ScanResponder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScanResponseGrpcClient scanResponseGrpcClient;
    private static final long currentProcessId = ProcessHandle.current().pid();

    public ScanResponder(@NotNull ScanResponseGrpcClient scanResponseGrpcClient) {
        Intrinsics.checkNotNullParameter((Object)scanResponseGrpcClient, (String)"scanResponseGrpcClient");
        this.scanResponseGrpcClient = scanResponseGrpcClient;
    }

    @NotNull
    public final ScanResponseGrpcClient getScanResponseGrpcClient() {
        return this.scanResponseGrpcClient;
    }

    public final void sendScanResponse(@NotNull TalonMessages.TalonScanResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        TalonMessages.TalonScanResponse outResponse = response2.toBuilder().setPid(currentProcessId).build();
        Intrinsics.checkNotNull((Object)outResponse);
        this.scanResponseGrpcClient.scanResponse(outResponse);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015JH\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004J*\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010%\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006'"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/ScanResponder$Companion;", "", "()V", "currentProcessId", "", "getCurrentProcessId", "()J", "alertsResponse", "Lcom/stackhawk/nest/TalonMessages$TalonScanResponse;", "alertsCompact", "Lcom/stackhawk/nest/TalonMessages$AlertsCompact;", "controlResponse", "ctrl", "Lcom/stackhawk/nest/TalonMessages$ScanControl$ControlType;", "profileName", "", "errorResponse", "hawkScanException", "Lcom/stackhawk/hste/extension/talon/hawkscan/api/HawkScanException;", "missingParamsResponse", "missingParams", "", "preflightWarningsResponse", "rateLimitHeaders", "", "cdnHeaders", "javaScriptFiles", "noScriptTagCount", "", "pathCount", "paramCount", "progressResponse", "type", "Lcom/stackhawk/nest/TalonMessages$ScanProgress$ProgressType;", "progress", "status", "Lcom/stackhawk/nest/TalonMessages$ScanProgress$Status;", "urlsResponse", "urls", "talon-common"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCurrentProcessId() {
            return currentProcessId;
        }

        @NotNull
        public final TalonMessages.TalonScanResponse controlResponse(@NotNull TalonMessages.ScanControl.ControlType ctrl, @NotNull String profileName) {
            Intrinsics.checkNotNullParameter((Object)ctrl, (String)"ctrl");
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setControl(TalonMessages.ScanControl.newBuilder().setType(ctrl)).setProfileName(profileName).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        public static /* synthetic */ TalonMessages.TalonScanResponse controlResponse$default(Companion companion, TalonMessages.ScanControl.ControlType controlType, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return companion.controlResponse(controlType, string);
        }

        @NotNull
        public final TalonMessages.TalonScanResponse errorResponse(@NotNull HawkScanException hawkScanException, @NotNull String profileName) {
            Intrinsics.checkNotNullParameter((Object)hawkScanException, (String)"hawkScanException");
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            String string = hawkScanException.getCategory();
            if (string == null) {
                string = "unknown";
            }
            TalonMessages.TalonScanResponse talonScanResponse = Utils.INSTANCE.errorResponse(string, hawkScanException.label(), hawkScanException.getMessage(), ExceptionsKt.stackTraceToString((Throwable)hawkScanException), hawkScanException.helpUrls()).toBuilder().setProfileName(profileName).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        public static /* synthetic */ TalonMessages.TalonScanResponse errorResponse$default(Companion companion, HawkScanException hawkScanException, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            return companion.errorResponse(hawkScanException, string);
        }

        @NotNull
        public final TalonMessages.TalonScanResponse progressResponse(@NotNull TalonMessages.ScanProgress.ProgressType type, long progress, @NotNull TalonMessages.ScanProgress.Status status, @NotNull String profileName) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setStatus(TalonMessages.ScanProgress.newBuilder().setType(type).setProgress(progress).setStatus(status)).setProfileName(profileName).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        public static /* synthetic */ TalonMessages.TalonScanResponse progressResponse$default(Companion companion, TalonMessages.ScanProgress.ProgressType progressType, long l, TalonMessages.ScanProgress.Status status, String string, int n, Object object) {
            if ((n & 4) != 0) {
                status = TalonMessages.ScanProgress.Status.RUNNING;
            }
            if ((n & 8) != 0) {
                string = "";
            }
            return companion.progressResponse(progressType, l, status, string);
        }

        @NotNull
        public final TalonMessages.TalonScanResponse alertsResponse(@NotNull TalonMessages.AlertsCompact alertsCompact) {
            Intrinsics.checkNotNullParameter((Object)alertsCompact, (String)"alertsCompact");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setAlertsCompact(alertsCompact).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        @NotNull
        public final TalonMessages.TalonScanResponse urlsResponse(@NotNull List<String> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setUrls(TalonMessages.SiteUrls.newBuilder().addAllUrls((Iterable)urls)).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        @NotNull
        public final TalonMessages.TalonScanResponse missingParamsResponse(@NotNull List<String> missingParams) {
            Intrinsics.checkNotNullParameter(missingParams, (String)"missingParams");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setMissingApiParams(TalonMessages.MissingApiParams.newBuilder().addAllMissingApiParams((Iterable)missingParams)).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        @NotNull
        public final TalonMessages.TalonScanResponse preflightWarningsResponse(@NotNull Set<String> rateLimitHeaders, @NotNull Set<String> cdnHeaders, @NotNull List<String> javaScriptFiles, int noScriptTagCount, int pathCount, long paramCount) {
            Intrinsics.checkNotNullParameter(rateLimitHeaders, (String)"rateLimitHeaders");
            Intrinsics.checkNotNullParameter(cdnHeaders, (String)"cdnHeaders");
            Intrinsics.checkNotNullParameter(javaScriptFiles, (String)"javaScriptFiles");
            TalonMessages.TalonScanResponse talonScanResponse = TalonMessages.TalonScanResponse.newBuilder().setPreflightWarnings(TalonMessages.PreflightWarnings.newBuilder().addAllRateLimitHeaders((Iterable)rateLimitHeaders).addAllCdnHeaders((Iterable)cdnHeaders).addAllJavascriptFiles((Iterable)javaScriptFiles).setNoScriptTagCount(noScriptTagCount).setPathCount(pathCount).setParamCount(paramCount)).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonScanResponse, (String)"build(...)");
            return talonScanResponse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

