/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.hawkscan;

import com.stackhawk.coroutines.AsyncJobScope;
import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.extension.talon.hawkscan.TalonScanResponderServiceImpl;
import com.stackhawk.nest.TalonMessages;
import io.grpc.BindableService;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.channels.Channel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/TalonScanResponseServer;", "", "portRange", "Lkotlin/ranges/IntRange;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/stackhawk/nest/TalonMessages$TalonScanResponse;", "asyncScope", "Lcom/stackhawk/coroutines/AsyncJobScope;", "(Lkotlin/ranges/IntRange;Lkotlinx/coroutines/channels/Channel;Lcom/stackhawk/coroutines/AsyncJobScope;)V", "getAsyncScope", "()Lcom/stackhawk/coroutines/AsyncJobScope;", "getChannel", "()Lkotlinx/coroutines/channels/Channel;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "server", "Lio/grpc/Server;", "getServer", "()Lio/grpc/Server;", "setServer", "(Lio/grpc/Server;)V", "shutdown", "", "start", "", "talon-common"})
public final class TalonScanResponseServer {
    @NotNull
    private final IntRange portRange;
    @NotNull
    private final Channel<TalonMessages.TalonScanResponse> channel;
    @NotNull
    private final AsyncJobScope asyncScope;
    private final Logger logger;
    public Server server;

    public TalonScanResponseServer(@NotNull IntRange portRange, @NotNull Channel<TalonMessages.TalonScanResponse> channel, @NotNull AsyncJobScope asyncScope) {
        Intrinsics.checkNotNullParameter((Object)portRange, (String)"portRange");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)asyncScope, (String)"asyncScope");
        this.portRange = portRange;
        this.channel = channel;
        this.asyncScope = asyncScope;
        this.logger = LogManager.getLogger(TalonScanResponseServer.class);
    }

    public /* synthetic */ TalonScanResponseServer(IntRange intRange, Channel channel, AsyncJobScope asyncJobScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intRange = new IntRange(22000, 23000);
        }
        this(intRange, (Channel<TalonMessages.TalonScanResponse>)channel, asyncJobScope);
    }

    @NotNull
    public final Channel<TalonMessages.TalonScanResponse> getChannel() {
        return this.channel;
    }

    @NotNull
    public final AsyncJobScope getAsyncScope() {
        return this.asyncScope;
    }

    @NotNull
    public final Server getServer() {
        Server server = this.server;
        if (server != null) {
            return server;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        return null;
    }

    public final void setServer(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"<set-?>");
        this.server = server;
    }

    public final int start() {
        int port = Utils.findTcpPort$default(Utils.INSTANCE, this.portRange.getFirst(), this.portRange.getLast(), null, 4, null);
        InetAddress addr = InetAddress.getLoopbackAddress();
        InetSocketAddress srvAddr = new InetSocketAddress(addr, port);
        Server server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)srvAddr, (ServerCredentials)InsecureServerCredentials.create()).addService((BindableService)new TalonScanResponderServiceImpl(this.asyncScope, this.channel))).addService(ProtoReflectionService.newInstance())).build().start();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"start(...)");
        this.setServer(server);
        this.logger.info("Started TalonScanResponseServer on port " + port);
        return this.getServer().getPort();
    }

    public final void shutdown() {
        this.getServer().shutdown();
    }
}

