/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.talon.hawkscan.api;

import com.stackhawk.hste.extension.talon.hawkscan.api.ExceptionKt;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.nest.AssetValidationMessages;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.MarkedYAMLException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/stackhawk/hste/extension/talon/hawkscan/api/InvalidYamlFileException;", "Lcom/stackhawk/hste/extension/talon/hawkscan/api/HawkScanException;", "message", "", "file", "Ljava/io/File;", "cause", "", "category", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/Throwable;Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "confText", "isMarkedYamlExceptionCause", "", "label", "markedYamlException", "Lorg/yaml/snakeyaml/error/MarkedYAMLException;", "toAssetValidationMarker", "Lcom/stackhawk/nest/AssetValidationMessages$Marker;", "talon-common"})
public final class InvalidYamlFileException
extends HawkScanException {
    @NotNull
    private final File file;

    public InvalidYamlFileException(@NotNull String message, @NotNull File file, @Nullable Throwable cause, @Nullable String category) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(message, cause, category, null, 8, null);
        this.file = file;
    }

    public /* synthetic */ InvalidYamlFileException(String string, File file, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        if ((n & 8) != 0) {
            string2 = "config-verify.linting.parse";
        }
        this(string, file, throwable, string2);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String label() {
        return "Invalid Yaml File";
    }

    public final boolean isMarkedYamlExceptionCause() {
        return this.getCause() != null && this.getCause() instanceof MarkedYAMLException;
    }

    @Nullable
    public final MarkedYAMLException markedYamlException() {
        MarkedYAMLException markedYAMLException;
        if (this.isMarkedYamlExceptionCause()) {
            Throwable throwable = this.getCause();
            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type org.yaml.snakeyaml.error.MarkedYAMLException");
            markedYAMLException = (MarkedYAMLException)throwable;
        } else {
            markedYAMLException = null;
        }
        return markedYAMLException;
    }

    @NotNull
    public final AssetValidationMessages.Marker toAssetValidationMarker() {
        AssetValidationMessages.Marker marker;
        if (this.isMarkedYamlExceptionCause()) {
            MarkedYAMLException markedYAMLException = this.markedYamlException();
            Intrinsics.checkNotNull((Object)markedYAMLException);
            marker = ExceptionKt.toAssetValidationMarker(markedYAMLException);
        } else {
            AssetValidationMessages.Marker.Builder builder = AssetValidationMessages.Marker.newBuilder();
            Object object = this.getCause();
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = this.getMessage();
            }
            AssetValidationMessages.Marker marker2 = builder.setMessage((String)object).setOwner("InvalidYamlFileException").setSeverity(AssetValidationMessages.MarkerSeverity.ERROR).build();
            Intrinsics.checkNotNull((Object)marker2);
            marker = marker2;
        }
        return marker;
    }

    @NotNull
    public final String confText() {
        return FilesKt.readText$default((File)this.file, null, (int)1, null);
    }
}

