/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.crypto;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/stackhawk/crypto/SecureHasher;", "", "()V", "hash", "", "value", "secret", "algorithm", "Lcom/stackhawk/crypto/SecureHasher$Algorithm;", "hasherCreator", "Ljavax/crypto/Mac;", "secretValue", "Algorithm", "nest"})
public final class SecureHasher {
    @NotNull
    public static final SecureHasher INSTANCE = new SecureHasher();

    private SecureHasher() {
    }

    private final Mac hasherCreator(String secretValue, Algorithm algorithm) {
        Mac mac = Mac.getInstance(algorithm.getDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
        Mac hasher = mac;
        String string = secretValue;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec secret = new SecretKeySpec(byArray, algorithm.getDescriptor());
        hasher.init(secret);
        return hasher;
    }

    @NotNull
    public final String hash(@NotNull String value, @NotNull String secret, @NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Mac mac = this.hasherCreator(secret, algorithm);
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = Hex.encodeHexString((byte[])mac.doFinal(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeHexString(...)");
        return string2;
    }

    public static /* synthetic */ String hash$default(SecureHasher secureHasher, String string, String string2, Algorithm algorithm, int n, Object object) {
        if ((n & 4) != 0) {
            algorithm = Algorithm.HMAC_SHA_256;
        }
        return secureHasher.hash(string, string2, algorithm);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/stackhawk/crypto/SecureHasher$Algorithm;", "", "descriptor", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescriptor", "()Ljava/lang/String;", "HMAC_SHA_256", "nest"})
    public static final class Algorithm
    extends Enum<Algorithm> {
        @NotNull
        private final String descriptor;
        public static final /* enum */ Algorithm HMAC_SHA_256 = new Algorithm("HmacSHA256");
        private static final /* synthetic */ Algorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Algorithm(String descriptor) {
            this.descriptor = descriptor;
        }

        @NotNull
        public final String getDescriptor() {
            return this.descriptor;
        }

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String value) {
            return Enum.valueOf(Algorithm.class, value);
        }

        @NotNull
        public static EnumEntries<Algorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algorithmArray = new Algorithm[]{Algorithm.HMAC_SHA_256};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

