/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.insights;

import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.ScanResultMessages;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.nest.insights.ThresholdHelper;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper;", "", "()V", "THRESHOLD_UNCONFIGURED", "", "countAlertsOverThreshold", "scanStats", "Lcom/stackhawk/nest/ScanResultMessages$ScanResultsStats;", "hawkConf", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf;", "severityCounts", "Lcom/stackhawk/nest/TalonMessages$SeverityCounts;", "remappedCounts", "Lcom/stackhawk/nest/insights/ThresholdHelper$RemappedSeverityCounts;", "RemappedSeverityCounts", "SeverityContainer", "ThresholdExtractor", "nest"})
@SourceDebugExtension(value={"SMAP\nThresholdHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThresholdHelper.kt\ncom/stackhawk/nest/insights/ThresholdHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class ThresholdHelper {
    @NotNull
    public static final ThresholdHelper INSTANCE = new ThresholdHelper();
    private static final int THRESHOLD_UNCONFIGURED = 0;

    private ThresholdHelper() {
    }

    public final int countAlertsOverThreshold(@NotNull TalonMessages.SeverityCounts severityCounts, @NotNull HawkScanMessages.HawkConf hawkConf) {
        Intrinsics.checkNotNullParameter((Object)severityCounts, (String)"severityCounts");
        Intrinsics.checkNotNullParameter((Object)hawkConf, (String)"hawkConf");
        return this.countAlertsOverThreshold(new RemappedSeverityCounts((Function0<Long>)((Function0)new Function0<Long>((Object)severityCounts){

            @NotNull
            public final Long invoke() {
                return ((TalonMessages.SeverityCounts)this.receiver).getHigh();
            }
        }), (Function0<Long>)((Function0)new Function0<Long>((Object)severityCounts){

            @NotNull
            public final Long invoke() {
                return ((TalonMessages.SeverityCounts)this.receiver).getMedium();
            }
        }), (Function0<Long>)((Function0)new Function0<Long>((Object)severityCounts){

            @NotNull
            public final Long invoke() {
                return ((TalonMessages.SeverityCounts)this.receiver).getLow();
            }
        })), hawkConf);
    }

    public final int countAlertsOverThreshold(@NotNull ScanResultMessages.ScanResultsStats scanStats, @NotNull HawkScanMessages.HawkConf hawkConf) {
        Intrinsics.checkNotNullParameter((Object)scanStats, (String)"scanStats");
        Intrinsics.checkNotNullParameter((Object)hawkConf, (String)"hawkConf");
        return this.countAlertsOverThreshold(new RemappedSeverityCounts((Function0<Long>)((Function0)new Function0<Long>((Object)scanStats){

            @NotNull
            public final Long invoke() {
                return ((ScanResultMessages.ScanResultsStats)this.receiver).getHighCount();
            }
        }), (Function0<Long>)((Function0)new Function0<Long>((Object)scanStats){

            @NotNull
            public final Long invoke() {
                return ((ScanResultMessages.ScanResultsStats)this.receiver).getMediumCount();
            }
        }), (Function0<Long>)((Function0)new Function0<Long>((Object)scanStats){

            @NotNull
            public final Long invoke() {
                return ((ScanResultMessages.ScanResultsStats)this.receiver).getLowCount();
            }
        })), hawkConf);
    }

    /*
     * WARNING - void declaration
     */
    private final int countAlertsOverThreshold(RemappedSeverityCounts remappedCounts, HawkScanMessages.HawkConf hawkConf) {
        ThresholdExtractor.ThresholdMapping thresholdMapping = ThresholdExtractor.INSTANCE.thresholdFromConfig(hawkConf);
        if (Intrinsics.areEqual((Object)thresholdMapping, (Object)ThresholdExtractor.ThresholdMapping.Unconfigured.INSTANCE)) {
            return 0;
        }
        Sequence sequence = SequencesKt.filter(remappedCounts.spreadOn(thresholdMapping), (Function1)countAlertsOverThreshold.7.INSTANCE);
        int n = 0;
        for (Object e : sequence) {
            void it;
            SeverityContainer severityContainer = (SeverityContainer)e;
            int n2 = n;
            boolean bl = false;
            int n3 = (int)it.getCounts();
            n = n2 + n3;
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$RemappedSeverityCounts;", "", "deferredHigh", "Lkotlin/Function0;", "", "deferredMedium", "deferredLow", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "spreadOn", "Lkotlin/sequences/Sequence;", "Lcom/stackhawk/nest/insights/ThresholdHelper$SeverityContainer;", "thresholdMapping", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "nest"})
    private static final class RemappedSeverityCounts {
        @NotNull
        private final Function0<Long> deferredHigh;
        @NotNull
        private final Function0<Long> deferredMedium;
        @NotNull
        private final Function0<Long> deferredLow;

        public RemappedSeverityCounts(@NotNull Function0<Long> deferredHigh, @NotNull Function0<Long> deferredMedium, @NotNull Function0<Long> deferredLow) {
            Intrinsics.checkNotNullParameter(deferredHigh, (String)"deferredHigh");
            Intrinsics.checkNotNullParameter(deferredMedium, (String)"deferredMedium");
            Intrinsics.checkNotNullParameter(deferredLow, (String)"deferredLow");
            this.deferredHigh = deferredHigh;
            this.deferredMedium = deferredMedium;
            this.deferredLow = deferredLow;
        }

        @NotNull
        public final Sequence<SeverityContainer> spreadOn(@NotNull ThresholdExtractor.ThresholdMapping thresholdMapping) {
            Intrinsics.checkNotNullParameter((Object)thresholdMapping, (String)"thresholdMapping");
            Object[] objectArray = new SeverityContainer[]{new SeverityContainer(thresholdMapping, ThresholdExtractor.ThresholdMapping.High.INSTANCE, this.deferredHigh), new SeverityContainer(thresholdMapping, ThresholdExtractor.ThresholdMapping.Medium.INSTANCE, this.deferredMedium), new SeverityContainer(thresholdMapping, ThresholdExtractor.ThresholdMapping.Low.INSTANCE, this.deferredLow)};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0010\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0082\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$SeverityContainer;", "", "configuredThreshold", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "testingThreshold", "inferredCounts", "Lkotlin/Function0;", "", "(Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;Lkotlin/jvm/functions/Function0;)V", "counts", "getCounts", "()J", "counts$delegate", "Lkotlin/Lazy;", "isAtOrAboveConfiguredThreshold", "", "isAtOrBelow", "other", "nest"})
    private static final class SeverityContainer {
        @NotNull
        private final ThresholdExtractor.ThresholdMapping configuredThreshold;
        @NotNull
        private final ThresholdExtractor.ThresholdMapping testingThreshold;
        @NotNull
        private final Function0<Long> inferredCounts;
        @NotNull
        private final Lazy counts$delegate;

        public SeverityContainer(@NotNull ThresholdExtractor.ThresholdMapping configuredThreshold, @NotNull ThresholdExtractor.ThresholdMapping testingThreshold, @NotNull Function0<Long> inferredCounts) {
            Intrinsics.checkNotNullParameter((Object)configuredThreshold, (String)"configuredThreshold");
            Intrinsics.checkNotNullParameter((Object)testingThreshold, (String)"testingThreshold");
            Intrinsics.checkNotNullParameter(inferredCounts, (String)"inferredCounts");
            this.configuredThreshold = configuredThreshold;
            this.testingThreshold = testingThreshold;
            this.inferredCounts = inferredCounts;
            this.counts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
                final /* synthetic */ SeverityContainer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return (Long)SeverityContainer.access$getInferredCounts$p(this.this$0).invoke();
                }
            }));
        }

        public final long getCounts() {
            Lazy lazy = this.counts$delegate;
            return ((Number)lazy.getValue()).longValue();
        }

        public final boolean isAtOrAboveConfiguredThreshold() {
            return this.isAtOrBelow(this.configuredThreshold, this.testingThreshold);
        }

        private final boolean isAtOrBelow(ThresholdExtractor.ThresholdMapping $this$isAtOrBelow, ThresholdExtractor.ThresholdMapping other) {
            return $this$isAtOrBelow.compareTo(other) >= 0;
        }

        public static final /* synthetic */ Function0 access$getInferredCounts$p(SeverityContainer $this) {
            return $this.inferredCounts;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor;", "", "()V", "thresholdFromConfig", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "hawkConf", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf;", "threshold", "", "ThresholdMapping", "nest"})
    private static final class ThresholdExtractor {
        @NotNull
        public static final ThresholdExtractor INSTANCE = new ThresholdExtractor();

        private ThresholdExtractor() {
        }

        @NotNull
        public final ThresholdMapping thresholdFromConfig(@NotNull HawkScanMessages.HawkConf hawkConf) {
            Intrinsics.checkNotNullParameter((Object)hawkConf, (String)"hawkConf");
            String string = hawkConf.getFailureThreshold();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFailureThreshold(...)");
            return this.thresholdFromConfig(string);
        }

        private final ThresholdMapping thresholdFromConfig(String threshold) {
            return ThresholdMapping.Companion.parse(threshold);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \r2\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "", "value", "", "(I)V", "name", "", "getName", "()Ljava/lang/String;", "name$delegate", "Lkotlin/Lazy;", "compareTo", "other", "Companion", "High", "Low", "Medium", "Unconfigured", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$High;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Low;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Medium;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Unconfigured;", "nest"})
        public static abstract class ThresholdMapping {
            @NotNull
            public static final Companion Companion = new Companion(null);
            private final int value;
            @NotNull
            private final Lazy name$delegate;
            @NotNull
            private static final Lazy<List<ThresholdMapping>> values$delegate = LazyKt.lazy((Function0)Companion.values.2.INSTANCE);

            private ThresholdMapping(int value) {
                this.value = value;
                this.name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ThresholdMapping this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        return Reflection.getOrCreateKotlinClass(this.this$0.getClass()).getSimpleName();
                    }
                }));
            }

            private final String getName() {
                Lazy lazy = this.name$delegate;
                return (String)lazy.getValue();
            }

            public final int compareTo(@NotNull ThresholdMapping other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return Intrinsics.compare((int)this.value, (int)other.value);
            }

            public /* synthetic */ ThresholdMapping(int value, DefaultConstructorMarker $constructor_marker) {
                this(value);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Companion;", "", "()V", "values", "", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "getValues", "()Ljava/util/Collection;", "values$delegate", "Lkotlin/Lazy;", "parse", "value", "", "nest"})
            @SourceDebugExtension(value={"SMAP\nThresholdHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThresholdHelper.kt\ncom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n288#2,2:115\n*S KotlinDebug\n*F\n+ 1 ThresholdHelper.kt\ncom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Companion\n*L\n100#1:115,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                private final Collection<ThresholdMapping> getValues() {
                    Lazy lazy = values$delegate;
                    return (Collection)lazy.getValue();
                }

                @NotNull
                public final ThresholdMapping parse(@NotNull String value) {
                    ThresholdMapping thresholdMapping;
                    Object v0;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        String trimmed = ((Object)StringsKt.trim((CharSequence)value)).toString();
                        Iterable $this$firstOrNull$iv = this.getValues();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ThresholdMapping it = (ThresholdMapping)element$iv;
                            boolean bl = false;
                            if (!StringsKt.equals((String)it.getName(), (String)trimmed, (boolean)true)) continue;
                            v0 = element$iv;
                            break block2;
                        }
                        v0 = null;
                    }
                    if ((thresholdMapping = (ThresholdMapping)v0) == null) {
                        thresholdMapping = Unconfigured.INSTANCE;
                    }
                    return thresholdMapping;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$High;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "()V", "nest"})
            public static final class High
            extends ThresholdMapping {
                @NotNull
                public static final High INSTANCE = new High();

                private High() {
                    super(1, null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Low;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "()V", "nest"})
            public static final class Low
            extends ThresholdMapping {
                @NotNull
                public static final Low INSTANCE = new Low();

                private Low() {
                    super(3, null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Medium;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "()V", "nest"})
            public static final class Medium
            extends ThresholdMapping {
                @NotNull
                public static final Medium INSTANCE = new Medium();

                private Medium() {
                    super(2, null);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping$Unconfigured;", "Lcom/stackhawk/nest/insights/ThresholdHelper$ThresholdExtractor$ThresholdMapping;", "()V", "nest"})
            public static final class Unconfigured
            extends ThresholdMapping {
                @NotNull
                public static final Unconfigured INSTANCE = new Unconfigured();

                private Unconfigured() {
                    super(0, null);
                }
            }
        }
    }
}

