/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.proto;

import com.google.gson.JsonObject;
import com.stackhawk.nest.markdown.MarkdownDocumentationCustomizer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "nest"})
public final class GenerateProtoJsonKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            System.err.println("Usage: GenerateProtoJson <output-file-path>");
            System.exit(1);
        }
        String outputPath = args[0];
        System.out.println((Object)("Generating proto.json documentation to: " + outputPath));
        try {
            MarkdownDocumentationCustomizer customizer = new MarkdownDocumentationCustomizer();
            JsonObject protoJson = customizer.createMarkdownDocumentation();
            Path outputFile = Path.of(outputPath, new String[0]);
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            String string = protoJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(outputFile, byArray, new OpenOption[0]);
            System.out.println((Object)("Successfully generated proto.json at: " + outputPath));
        }
        catch (Exception e) {
            System.err.println("Failed to generate proto.json: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

