/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.proto;

import com.stackhawk.nest.OrganizationMessages;
import com.stackhawk.nest.UserMessages;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stackhawk/nest/proto/UserUtils;", "", "()V", "emailMask", "Lkotlin/text/Regex;", "hasSubscription", "", "user", "Lcom/stackhawk/nest/UserMessages$User;", "isFreeUser", "maskEmail", "", "email", "maskIp", "ip", "orgSubscriptionValid", "userOrg", "Lcom/stackhawk/nest/UserMessages$UserOrganization;", "gracePeriodDays", "", "validSubscription", "nest"})
@SourceDebugExtension(value={"SMAP\nUserUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserUtils.kt\ncom/stackhawk/nest/proto/UserUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1#2:110\n1726#3,3:111\n*S KotlinDebug\n*F\n+ 1 UserUtils.kt\ncom/stackhawk/nest/proto/UserUtils\n*L\n30#1:111,3\n*E\n"})
public final class UserUtils {
    @NotNull
    public static final UserUtils INSTANCE = new UserUtils();
    @NotNull
    private static final Regex emailMask = new Regex("(^[^@]{3}|(?!^)\\G)[^@]");

    private UserUtils() {
    }

    public final boolean hasSubscription(@NotNull UserMessages.User user) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            if (user.getExternal().getOrganizationsCount() == 0) {
                return false;
            }
            List<UserMessages.UserOrganization> list2 = user.getExternal().getOrganizationsList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getOrganizationsList(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                UserMessages.UserOrganization it = (UserMessages.UserOrganization)t;
                boolean bl = false;
                if (!it.getOrganization().getSubscription().getIsEnabled()) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1 != null;
    }

    public final boolean validSubscription(@NotNull UserMessages.User user, long gracePeriodDays) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (user.getExternal().getOrganizationsCount() == 0) {
            bl = false;
        } else if (this.isFreeUser(user)) {
            bl = true;
        } else {
            Object v2;
            block5: {
                List<UserMessages.UserOrganization> list2 = user.getExternal().getOrganizationsList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getOrganizationsList(...)");
                Iterable iterable = list2;
                for (Object t : iterable) {
                    UserMessages.UserOrganization userOrg = (UserMessages.UserOrganization)t;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)userOrg);
                    if (!INSTANCE.orgSubscriptionValid(userOrg, gracePeriodDays)) continue;
                    v2 = t;
                    break block5;
                }
                v2 = null;
            }
            bl = v2 != null;
        }
        return bl;
    }

    public static /* synthetic */ boolean validSubscription$default(UserUtils userUtils, UserMessages.User user, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 30L;
        }
        return userUtils.validSubscription(user, l);
    }

    private final boolean isFreeUser(UserMessages.User user) {
        boolean bl;
        block3: {
            List<UserMessages.UserOrganization> list2 = user.getExternal().getOrganizationsList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getOrganizationsList(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    UserMessages.UserOrganization it = (UserMessages.UserOrganization)element$iv;
                    boolean bl2 = false;
                    if (it.getOrganization().getSubscription().getStatus() == OrganizationMessages.SubscriptionStatus.FREE || it.getOrganization().getSubscription().getStatus() == OrganizationMessages.SubscriptionStatus.DOWNGRADED) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean orgSubscriptionValid(@NotNull UserMessages.UserOrganization userOrg, long gracePeriodDays) {
        Intrinsics.checkNotNullParameter((Object)userOrg, (String)"userOrg");
        OrganizationMessages.Organization org = userOrg.getOrganization();
        OrganizationMessages.Subscription sub = org.getSubscription();
        Instant endDate = Instant.ofEpochSecond(sub.getEndDate());
        return endDate.plus(gracePeriodDays, ChronoUnit.DAYS).isAfter(Instant.now());
    }

    public static /* synthetic */ boolean orgSubscriptionValid$default(UserUtils userUtils, UserMessages.UserOrganization userOrganization, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 30L;
        }
        return userUtils.orgSubscriptionValid(userOrganization, l);
    }

    @NotNull
    public final String maskEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        CharSequence charSequence = email;
        Regex regex = emailMask;
        String string = "$1*";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public final String maskIp(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String string = ip.substring(StringsKt.indexOf$default((CharSequence)ip, (char)'.', (int)(StringsKt.indexOf$default((CharSequence)ip, (char)'.', (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String toMask = string;
        return StringsKt.replace$default((String)ip, (String)toMask, (String)StringsKt.repeat((CharSequence)"*", (int)toMask.length()), (boolean)false, (int)4, null);
    }
}

