/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.redis;

import com.stackhawk.nest.redis.NoopOverLimitHandler;
import com.stackhawk.nest.redis.OverLimitHandler;
import com.stackhawk.nest.redis.service.RateLimitingService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.GenericFilterBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stackhawk/nest/redis/RateLimitingFilter;", "Lorg/springframework/web/filter/GenericFilterBean;", "rateLimiter", "Lcom/stackhawk/nest/redis/service/RateLimitingService;", "handler", "Lcom/stackhawk/nest/redis/OverLimitHandler;", "(Lcom/stackhawk/nest/redis/service/RateLimitingService;Lcom/stackhawk/nest/redis/OverLimitHandler;)V", "doFilter", "", "request", "Ljakarta/servlet/ServletRequest;", "response", "Ljakarta/servlet/ServletResponse;", "chain", "Ljakarta/servlet/FilterChain;", "nest"})
public final class RateLimitingFilter
extends GenericFilterBean {
    @NotNull
    private final RateLimitingService rateLimiter;
    @NotNull
    private final OverLimitHandler handler;

    public RateLimitingFilter(@NotNull RateLimitingService rateLimiter, @NotNull OverLimitHandler handler) {
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.rateLimiter = rateLimiter;
        this.handler = handler;
    }

    public /* synthetic */ RateLimitingFilter(RateLimitingService rateLimitingService, OverLimitHandler overLimitHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            overLimitHandler = new NoopOverLimitHandler();
        }
        this(rateLimitingService, overLimitHandler);
    }

    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        RateLimitingService.OverLimitResponse limit = this.rateLimiter.overLimitResponse(req);
        if (limit.getOverLimit()) {
            resp.reset();
            resp.sendError(HttpStatus.TOO_MANY_REQUESTS.value(), "Slow down there cow person.");
            this.logger.warn((Object)("Too many requests: " + limit.getLimiterName() + " : " + limit.getKey() + " : " + limit.getRequestURI()));
            this.handler.overLimit(limit, (HttpServletRequest)request);
        } else {
            chain.doFilter((ServletRequest)req, response);
        }
    }
}

