/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.redis.service;

import com.stackhawk.nest.redis.config.JedisProperties;
import com.stackhawk.nest.redis.config.ReadHost;
import com.stackhawk.nest.redis.service.JedisService;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.params.SetParams;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 :2\u00020\u0001:\u0001:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J/\u0010\"\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010%J/\u0010\"\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010$\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010)J3\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00152\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010$\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010*J(\u0010+\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001bH\u0016J\b\u0010,\u001a\u00020-H\u0007J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150/2\u0006\u00100\u001a\u00020\u0015H\u0016J?\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020-052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H205H\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001bH\u0016J \u00108\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001bH\u0016J \u00109\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006;"}, d2={"Lcom/stackhawk/nest/redis/service/JedisServiceImpl;", "Lcom/stackhawk/nest/redis/service/JedisService;", "jedisProperties", "Lcom/stackhawk/nest/redis/config/JedisProperties;", "(Lcom/stackhawk/nest/redis/config/JedisProperties;)V", "getJedisProperties", "()Lcom/stackhawk/nest/redis/config/JedisProperties;", "readPool", "Lredis/clients/jedis/JedisPool;", "getReadPool", "()Lredis/clients/jedis/JedisPool;", "setReadPool", "(Lredis/clients/jedis/JedisPool;)V", "writePool", "getWritePool", "setWritePool", "del", "", "key", "", "([B)Ljava/lang/Long;", "", "(Ljava/lang/String;)Ljava/lang/Long;", "eval", "", "script", "keyCount", "", "token", "get", "hGet", "field", "hGetAll", "", "hSet", "value", "ttl", "([B[B[BI)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/Long;", "hSetAll", "values", "([BLjava/util/Map;I)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/util/Map;I)Ljava/lang/Long;", "hSetNx", "init", "", "keys", "", "pattern", "mutexBlock", "T", "maxOpSeconds", "waitFn", "Lkotlin/Function0;", "op", "([BILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "set", "setNx", "Companion", "nest"})
@SourceDebugExtension(value={"SMAP\nJedisService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JedisService.kt\ncom/stackhawk/nest/redis/service/JedisServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,242:1\n1#2:243\n125#3:244\n152#3,3:245\n125#3:248\n152#3,3:249\n*S KotlinDebug\n*F\n+ 1 JedisService.kt\ncom/stackhawk/nest/redis/service/JedisServiceImpl\n*L\n123#1:244\n123#1:245,3\n133#1:248\n133#1:249,3\n*E\n"})
public final class JedisServiceImpl
implements JedisService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JedisProperties jedisProperties;
    public JedisPool readPool;
    public JedisPool writePool;
    private static final Logger logger = LoggerFactory.getLogger(JedisServiceImpl.class);

    public JedisServiceImpl(@NotNull JedisProperties jedisProperties) {
        Intrinsics.checkNotNullParameter((Object)jedisProperties, (String)"jedisProperties");
        this.jedisProperties = jedisProperties;
    }

    @NotNull
    public final JedisProperties getJedisProperties() {
        return this.jedisProperties;
    }

    @NotNull
    public final JedisPool getReadPool() {
        JedisPool jedisPool = this.readPool;
        if (jedisPool != null) {
            return jedisPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"readPool");
        return null;
    }

    public final void setReadPool(@NotNull JedisPool jedisPool) {
        Intrinsics.checkNotNullParameter((Object)jedisPool, (String)"<set-?>");
        this.readPool = jedisPool;
    }

    @NotNull
    public final JedisPool getWritePool() {
        JedisPool jedisPool = this.writePool;
        if (jedisPool != null) {
            return jedisPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"writePool");
        return null;
    }

    public final void setWritePool(@NotNull JedisPool jedisPool) {
        Intrinsics.checkNotNullParameter((Object)jedisPool, (String)"<set-?>");
        this.writePool = jedisPool;
    }

    @PostConstruct
    public final void init() {
        this.setWritePool(new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.jedisProperties.getHost(), this.jedisProperties.getPort().intValue(), this.jedisProperties.getSsl()));
        if (this.jedisProperties.getRead() != null) {
            Object object;
            ReadHost readHost = this.jedisProperties.getRead();
            this.setReadPool(new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), readHost != null ? readHost.getHost() : null, (object = this.jedisProperties.getRead()) != null && (object = ((ReadHost)object).getPort()) != null ? ((Number)object).intValue() : 6379, this.jedisProperties.getSsl()));
        } else {
            this.setReadPool(this.getWritePool());
        }
    }

    @Override
    @NotNull
    public String set(@NotNull String key, @NotNull String value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byArray = key.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = value.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return this.set(byArray, byArray2, ttl);
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = key.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = this.get(byArray);
        if (byArray2 != null) {
            byte[] it = byArray2;
            boolean bl = false;
            string = new String(it, Charsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Long del(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = key.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.del(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<String> keys(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Closeable closeable = (Closeable)this.getReadPool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            Set set = jedis.keys(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keys(...)");
            Set set2 = set;
            return set2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String set(@NotNull byte[] key, @NotNull byte[] value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            String string;
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            String code = jedis.set(key, value);
            if (ttl > 0) {
                string = String.valueOf(jedis.expire(key, (long)ttl));
            } else {
                String string2 = code;
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
            String string3 = string;
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Map<String, String> hGetAll(@NotNull String key) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Map<byte[], byte[]> map3 = this.hGetAll(byArray);
        if (map3 != null) {
            void $this$mapTo$iv$iv;
            Map<byte[], byte[]> $this$map$iv = map3;
            boolean $i$f$map = false;
            Map<byte[], byte[]> map4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)new String((byte[])it.getKey(), Charsets.UTF_8), (Object)new String((byte[])it.getValue(), Charsets.UTF_8)));
            }
            map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Map<byte[], byte[]> hGetAll(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Closeable closeable = (Closeable)this.getReadPool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            Map map2 = jedis.hgetAll(key);
            return map2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Long hSetAll(@NotNull String key, @NotNull Map<String, String> values2, int ttl) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Object object = key;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        object = values2;
        byte[] byArray2 = byArray;
        JedisServiceImpl jedisServiceImpl = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray3 = ((String)it.getKey()).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] byArray4 = ((String)it.getValue()).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
            collection.add(TuplesKt.to((Object)byArray3, (Object)byArray4));
        }
        collection = (List)destination$iv$iv;
        return jedisServiceImpl.hSetAll(byArray2, MapsKt.toMap((Iterable)collection), ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Long hSetAll(@NotNull byte[] key, @NotNull Map<byte[], byte[]> values2, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            long code = jedis.hset(key, values2);
            Long l = ttl > 0 ? Long.valueOf(jedis.expire(key, (long)ttl)) : Long.valueOf(code);
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @Nullable
    public Long hSet(@NotNull String key, @NotNull String field, @NotNull String value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = field;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        string = value;
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        return this.hSet(byArray, byArray2, byArray3, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Long hSet(@NotNull byte[] key, @NotNull byte[] field, @NotNull byte[] value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            long code = jedis.hset(key, field, value);
            Long l = ttl > 0 ? Long.valueOf(jedis.expire(key, (long)ttl)) : Long.valueOf(code);
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @Nullable
    public String hGet(@NotNull String key, @NotNull String field) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string2 = key;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string2 = field;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = this.hGet(byArray, byArray2);
        if (byArray3 != null) {
            byte[] it = byArray3;
            boolean bl = false;
            string = new String(it, Charsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] hGet(@NotNull byte[] key, @NotNull byte[] field) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Closeable closeable = (Closeable)this.getReadPool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            byte[] byArray = jedis.hget(key, field);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] get(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Closeable closeable = (Closeable)this.getReadPool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            byte[] byArray = jedis.get(key);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Long del(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            Long l = jedis.del(key);
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setNx(@NotNull byte[] key, @NotNull byte[] value, int ttl) {
        long l;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            l = jedis.set(key, value, (SetParams)new SetParams().nx().px((long)ttl * 1000L)) == null ? 0L : 1L;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long hSetNx(@NotNull byte[] key, @NotNull byte[] field, @NotNull byte[] value, int ttl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            long assigned = jedis.hsetnx(key, field, value);
            if (assigned == 1L && ttl > 0) {
                jedis.expire(key, (long)ttl);
            }
            long l = assigned;
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T mutexBlock(@NotNull byte[] key, int maxOpSeconds, @NotNull Function0<Unit> waitFn, @NotNull Function0<? extends T> op) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(waitFn, (String)"waitFn");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] token = byArray;
        long created = this.setNx(key, token, maxOpSeconds);
        if (created == 1L) {
            Object object2;
            try {
                object2 = op.invoke();
            }
            finally {
                String string3 = "\nif redis.call(\"get\",KEYS[1]) == ARGV[1]\nthen\n    return redis.call(\"del\",KEYS[1])\nelse\n    return 0\nend";
                byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                if (Intrinsics.areEqual((Object)this.eval(byArray2, 1, key, token), (Object)0L)) {
                    logger.warn("Delete not called - unable to verify lock with key " + new String(key, Charsets.UTF_8) + ", token " + new String(token, Charsets.UTF_8));
                }
            }
            object = object2;
        } else {
            waitFn.invoke();
            object = this.mutexBlock(key, maxOpSeconds, waitFn, op);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object eval(@NotNull byte[] script, int keyCount, @NotNull byte[] key, @NotNull byte[] token) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Closeable closeable = (Closeable)this.getWritePool().getResource();
        Throwable throwable = null;
        try {
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            byte[][] byArrayArray = new byte[][]{key, token};
            Object object2 = jedis.eval(script, keyCount, (byte[][])byArrayArray);
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stackhawk/nest/redis/service/JedisServiceImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

