/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/stackhawk/net/NetworkUtilities;", "", "()V", "waitForSocketToBecomeAvailable", "", "port", "", "host", "", "pollDelay", "", "waitTimeout", "connectTimeout", "nest"})
public final class NetworkUtilities {
    @NotNull
    public static final NetworkUtilities INSTANCE = new NetworkUtilities();

    private NetworkUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitForSocketToBecomeAvailable(int port, @NotNull String host, long pollDelay, long waitTimeout, long connectTimeout) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Instant start = Instant.now();
        boolean connected = false;
        while (!connected) {
            try {
                new Socket().connect(new InetSocketAddress(host, port), (int)connectTimeout);
                connected = true;
                continue;
            }
            catch (ConnectException connectException) {
                continue;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            finally {
                if (Instant.now().compareTo(start.plusMillis(waitTimeout)) > 0) {
                    throw new IOException("Unable to connect to " + host + ":" + port + " after " + waitTimeout / (long)1000 + " seconds");
                }
                Thread.sleep(pollDelay);
                continue;
            }
            break;
        }
        return;
    }

    public static /* synthetic */ void waitForSocketToBecomeAvailable$default(NetworkUtilities networkUtilities, int n, String string, long l, long l2, long l3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            l = 100L;
        }
        if ((n2 & 8) != 0) {
            l2 = 60000L;
        }
        if ((n2 & 0x10) != 0) {
            l3 = l2 / (long)6;
        }
        networkUtilities.waitForSocketToBecomeAvailable(n, string, l, l2, l3);
    }
}

