/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.perch.hallux;

import com.stackhawk.perch.hallux.JWTTokenFactory;
import com.stackhawk.perch.hallux.PerchPreAuthGrpcClient;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/stackhawk/perch/hallux/PerchKeyTokenFactoryImpl;", "Lcom/stackhawk/perch/hallux/JWTTokenFactory;", "perchHost", "", "perchPort", "", "(Ljava/lang/String;I)V", "client", "Lcom/stackhawk/perch/hallux/PerchPreAuthGrpcClient;", "getClient", "()Lcom/stackhawk/perch/hallux/PerchPreAuthGrpcClient;", "jwtToken", "getJwtToken", "()Ljava/lang/String;", "setJwtToken", "(Ljava/lang/String;)V", "getToken", "init", "", "key", "shouldRenew", "", "Companion", "perch-hallux"})
public final class PerchKeyTokenFactoryImpl
implements JWTTokenFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String jwtToken;
    @NotNull
    private final PerchPreAuthGrpcClient client;
    @NotNull
    private static final Logger logger;

    public PerchKeyTokenFactoryImpl(@NotNull String perchHost, int perchPort) {
        Intrinsics.checkNotNullParameter((Object)perchHost, (String)"perchHost");
        this.client = new PerchPreAuthGrpcClient(perchHost, perchPort);
    }

    @Nullable
    public final String getJwtToken() {
        return this.jwtToken;
    }

    public final void setJwtToken(@Nullable String string) {
        this.jwtToken = string;
    }

    @NotNull
    public final PerchPreAuthGrpcClient getClient() {
        return this.client;
    }

    @Override
    public void init(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            this.jwtToken = this.client.getJWTToken(key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to initialize PerchKeyTokenFactoryImpl with provided Perch Key", e);
        }
    }

    @Override
    @Nullable
    public String getToken() {
        return this.jwtToken;
    }

    @Override
    public boolean shouldRenew() {
        return false;
    }

    static {
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        PerchKeyTokenFactoryImpl.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stackhawk/perch/hallux/PerchKeyTokenFactoryImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "perch-hallux"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

