/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.perch.hallux;

import com.stackhawk.nest.ExternalPerchServiceGrpc;
import com.stackhawk.nest.PerchMessages;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/stackhawk/perch/hallux/PerchPreAuthGrpcClient;", "Ljava/io/Closeable;", "host", "", "port", "", "(Ljava/lang/String;I)V", "channel", "Lio/grpc/ManagedChannel;", "credentials", "Lio/grpc/ChannelCredentials;", "getCredentials", "()Lio/grpc/ChannelCredentials;", "setCredentials", "(Lio/grpc/ChannelCredentials;)V", "externalPerchServiceStub", "Lcom/stackhawk/nest/ExternalPerchServiceGrpc$ExternalPerchServiceBlockingStub;", "getExternalPerchServiceStub", "()Lcom/stackhawk/nest/ExternalPerchServiceGrpc$ExternalPerchServiceBlockingStub;", "close", "", "getJWTToken", "perchKey", "Companion", "perch-hallux"})
public final class PerchPreAuthGrpcClient
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ChannelCredentials credentials;
    @NotNull
    private final ManagedChannel channel;
    @NotNull
    private final ExternalPerchServiceGrpc.ExternalPerchServiceBlockingStub externalPerchServiceStub;
    @NotNull
    private static final Logger logger;

    public PerchPreAuthGrpcClient(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        TrustManager[] trustManagerArray = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
        ChannelCredentials channelCredentials = TlsChannelCredentials.newBuilder().trustManager(Arrays.copyOf(trustManagerArray, trustManagerArray.length)).build();
        Intrinsics.checkNotNullExpressionValue((Object)channelCredentials, (String)"newBuilder()\n          /\u2026agers)\n          .build()");
        this.credentials = channelCredentials;
        ManagedChannel managedChannel = Grpc.newChannelBuilderForAddress((String)host, (int)port, (ChannelCredentials)this.credentials).idleTimeout(60L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"newChannelBuilderForAddr\u2026TimeUnit.SECONDS).build()");
        this.channel = managedChannel;
        ExternalPerchServiceGrpc.ExternalPerchServiceBlockingStub externalPerchServiceBlockingStub = ExternalPerchServiceGrpc.newBlockingStub((Channel)((Channel)this.channel));
        Intrinsics.checkNotNullExpressionValue((Object)externalPerchServiceBlockingStub, (String)"newBlockingStub(channel)");
        this.externalPerchServiceStub = externalPerchServiceBlockingStub;
    }

    public /* synthetic */ PerchPreAuthGrpcClient(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 7202;
        }
        this(string, n);
    }

    @NotNull
    public final ChannelCredentials getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(@NotNull ChannelCredentials channelCredentials) {
        Intrinsics.checkNotNullParameter((Object)channelCredentials, (String)"<set-?>");
        this.credentials = channelCredentials;
    }

    @NotNull
    public final ExternalPerchServiceGrpc.ExternalPerchServiceBlockingStub getExternalPerchServiceStub() {
        return this.externalPerchServiceStub;
    }

    @Override
    public void close() {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    @NotNull
    public final String getJWTToken(@NotNull String perchKey) {
        Intrinsics.checkNotNullParameter((Object)perchKey, (String)"perchKey");
        logger.info("Getting JWT token for perch key: " + perchKey);
        PerchMessages.AuthPerchKeyResponse token = this.externalPerchServiceStub.authPerchKey(PerchMessages.AuthPerchKeyRequest.newBuilder().setPerchKey(perchKey).build());
        String string = token.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"token.token");
        return string;
    }

    public PerchPreAuthGrpcClient() {
        this(null, 0, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        PerchPreAuthGrpcClient.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stackhawk/perch/hallux/PerchPreAuthGrpcClient$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "perch-hallux"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

