/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;

public class MetaSchemaDetector {
    static URI detectMetaSchema(Object document) {
        if (document instanceof Boolean) {
            return MetaSchemaUris.DRAFT_7;
        }
        if (document instanceof Map) {
            Map jsonDocument = (Map)document;
            if (jsonDocument.containsKey("$schema")) {
                return URI.create((String)jsonDocument.get("$schema"));
            }
            if (jsonDocument.containsKey("schema")) {
                return URI.create((String)jsonDocument.get("schema"));
            }
        }
        int[] idCount = new int[]{0};
        int[] dollarIdCount = new int[]{0};
        MetaSchemaDetector.allKeys(document, key -> {
            if ("id".equals(key)) {
                idCount[0] = idCount[0] + 1;
            } else if ("$id".equals(key)) {
                dollarIdCount[0] = dollarIdCount[0] + 1;
            }
        });
        if (dollarIdCount[0] > idCount[0]) {
            return MetaSchemaUris.DRAFT_7;
        }
        return MetaSchemaUris.DRAFT_4;
    }

    private static void allKeys(Object document, Consumer<String> consumer) {
        block3: {
            block2: {
                if (!(document instanceof Map)) break block2;
                for (Map.Entry entry : ((Map)document).entrySet()) {
                    consumer.accept((String)entry.getKey());
                    MetaSchemaDetector.allKeys(entry.getValue(), consumer);
                }
                break block3;
            }
            if (!(document instanceof List)) break block3;
            for (Object o : (Iterable)document) {
                MetaSchemaDetector.allKeys(o, consumer);
            }
        }
    }
}

