/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.ValidationError;

public class OneOfError
extends ValidationError {
    private final List<List<ValidationError>> allErrors;
    private final List<Schema> passed;

    public OneOfError(URI uri, Object document, List<Schema> passed, List<List<ValidationError>> allErrors, Schema schema) {
        super(uri, document, schema);
        this.passed = Collections.unmodifiableList(passed);
        this.allErrors = Collections.unmodifiableList(allErrors);
    }

    public List<List<ValidationError>> getAllErrors() {
        return this.allErrors;
    }

    public List<Schema> getPassed() {
        return this.passed;
    }

    @Override
    public String getMessage() {
        if (this.passed.isEmpty()) {
            return "No oneOf passed. Errors were: " + this.allErrors;
        }
        return "More than one oneOf passed: " + this.passed.stream().map(schema -> schema.getUri().toString()).collect(Collectors.joining(", "));
    }
}

