/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import net.jimblackler.jsonschemafriend.MissingPathException;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.Validator;

public abstract class ValidationError {
    private static final String ELLIPSES = "...";
    private final URI uri;
    private final Object document;
    private final Schema schema;
    private final Object object;
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected ValidationError(URI uri, Object document, Schema schema) {
        Object _object;
        this.uri = uri;
        this.document = document;
        this.schema = schema;
        try {
            _object = Validator.getObject(document, uri);
        }
        catch (MissingPathException e) {
            _object = null;
        }
        this.object = _object;
    }

    public String toString() {
        URI schemaPath = this.schema.getUri();
        try {
            String str = this.objectMapper.writeValueAsString(this.object);
            return ValidationError.truncate(str, 60) + (this.uri.toString().isEmpty() ? " at root " : " at " + this.uri + " ") + "failed " + (schemaPath.toString().isEmpty() ? "" : "against " + schemaPath + " ") + "with \"" + this.getMessage() + "\"";
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public URI getUri() {
        return this.uri;
    }

    public Object getDocument() {
        return this.document;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public abstract String getMessage();

    public static String truncate(String str, int maxLength) {
        int trueMax = maxLength - ELLIPSES.length();
        if (str.length() <= trueMax) {
            return str;
        }
        return str.substring(0, trueMax) + ELLIPSES;
    }
}

