/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.http;

import com.stackhawk.http.BaseHttpClientImpl;
import com.stackhawk.http.HttpClient;
import com.stackhawk.http.HttpClientConfig;
import com.stackhawk.http.HttpDispatcher;
import com.stackhawk.http.MaxIdleKeepAliveStrategy;
import com.stackhawk.http.NoopResponseCallback;
import com.stackhawk.http.ResponseStatusException;
import com.stackhawk.ssl.SSLContextFactory;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityConsumer;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stackhawk/http/HttpClientImpl;", "Lcom/stackhawk/http/BaseHttpClientImpl;", "config", "Lcom/stackhawk/http/HttpClientConfig;", "(Lcom/stackhawk/http/HttpClientConfig;)V", "httpAsyncClient", "Lorg/apache/hc/client5/http/impl/async/CloseableHttpAsyncClient;", "requestFuture", "Ljava/util/concurrent/Future;", "Lorg/apache/hc/client5/http/async/methods/SimpleHttpResponse;", "request", "Lorg/apache/hc/client5/http/async/methods/SimpleHttpRequest;", "requestFutureFile", "file", "Ljava/io/File;", "requestFutureStream", "Lorg/apache/hc/core5/http/Message;", "Lorg/apache/hc/core5/http/HttpResponse;", "Ljava/io/InputStream;", "start", "", "stop", "Companion", "talon-http"})
public final class HttpClientImpl
extends BaseHttpClientImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpAsyncClient httpAsyncClient;
    private static final Logger logger = LogManager.getLogger(Companion.getClass());

    public HttpClientImpl(@NotNull HttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        this.httpAsyncClient = HttpClientImpl.Companion.createAsyncHttpClient(config);
        if (config.getAutoStart()) {
            this.start();
        }
    }

    @Override
    public void start() {
        this.httpAsyncClient.start();
    }

    @Override
    public void stop() {
        do {
            Thread.sleep(50L);
        } while (this.getRequestsInflight().getValue() > 0L);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.getRequestChannel()), null, (int)1, null);
        CoroutineDispatcher dispatcher = this.getConfig().getHttpDispatcher();
        if (dispatcher instanceof HttpDispatcher) {
            ((HttpDispatcher)dispatcher).getExecService().shutdown();
        }
        this.httpAsyncClient.initiateShutdown();
        this.httpAsyncClient.awaitShutdown((TimeValue)this.getConfig().getShutdownTimeout());
    }

    @Override
    @NotNull
    public Future<SimpleHttpResponse> requestFuture(@NotNull SimpleHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Future future = this.httpAsyncClient.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)NoopResponseCallback.Companion.create());
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"execute(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<Message<HttpResponse, InputStream>> requestFutureStream(@NotNull SimpleHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Executor executor = ExecutorsKt.asExecutor((CoroutineDispatcher)this.getConfig().getDispatcher());
        AbstractClassicEntityConsumer<InputStream> isConsumer2 = new AbstractClassicEntityConsumer<InputStream>(executor){

            @NotNull
            protected InputStream consumeData(@NotNull ContentType contentType, @NotNull InputStream inputStream) {
                Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                return inputStream;
            }
        };
        BasicRequestProducer producer = new BasicRequestProducer((HttpRequest)request, (AsyncEntityProducer)new BasicAsyncEntityProducer((CharSequence)""));
        BasicResponseConsumer consumer = new BasicResponseConsumer((AsyncEntityConsumer)isConsumer2);
        Future future = this.httpAsyncClient.execute((AsyncRequestProducer)producer, (AsyncResponseConsumer)consumer, (FutureCallback)NoopResponseCallback.Companion.create());
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"execute(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<SimpleHttpResponse> requestFutureFile(@NotNull SimpleHttpRequest request, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BasicRequestProducer producer = new BasicRequestProducer((HttpRequest)request, (AsyncEntityProducer)new FileEntityProducer(file));
        Future future = this.httpAsyncClient.execute((AsyncRequestProducer)producer, (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)NoopResponseCallback.Companion.create());
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"execute(...)");
        return future;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J.\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a*\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/stackhawk/http/HttpClientImpl$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "createAsyncHttpClient", "Lorg/apache/hc/client5/http/impl/async/CloseableHttpAsyncClient;", "config", "Lcom/stackhawk/http/HttpClientConfig;", "createConnectionManager", "Lorg/apache/hc/client5/http/nio/AsyncClientConnectionManager;", "httpClient", "Lcom/stackhawk/http/HttpClient;", "acceptJson", "", "Lorg/apache/hc/client5/http/async/methods/SimpleRequestBuilder;", "isSuccess", "", "Lorg/apache/hc/core5/http/HttpResponse;", "validateResponse", "Lorg/apache/hc/client5/http/async/methods/SimpleHttpResponse;", "request", "Lorg/apache/hc/client5/http/async/methods/SimpleHttpRequest;", "Lorg/apache/hc/core5/http/Message;", "Ljava/io/InputStream;", "talon-http"})
    @SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\ncom/stackhawk/http/HttpClientImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n1#2:511\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final HttpClient httpClient(@NotNull HttpClientConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new HttpClientImpl(config);
        }

        private final AsyncClientConnectionManager createConnectionManager(HttpClientConfig config) {
            PoolingAsyncClientConnectionManagerBuilder connManagerBuilder = PoolingAsyncClientConnectionManagerBuilder.create();
            SSLContext sSLContext = SSLContextFactory.Companion.getSSLContext(config.getInsecureSSL(), config.getCaCertPath(), config.getTrustStorePath(), config.getTrustStoreType(), config.getTrustStorePassword());
            if (sSLContext != null) {
                SSLContext it = sSLContext;
                boolean bl = false;
                ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setSslContext(it);
                if (config.getInsecureSSL()) {
                    tlsStrategyBuilder.setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
                }
                String[] stringArray = config.getAllowedCiphers();
                if (stringArray != null) {
                    String[] ciphers = stringArray;
                    boolean bl2 = false;
                    tlsStrategyBuilder.setCiphers(Arrays.copyOf(ciphers, ciphers.length));
                }
                TlsStrategy tlsStrategy = tlsStrategyBuilder.build();
                connManagerBuilder.setTlsStrategy(tlsStrategy);
            }
            PoolingAsyncClientConnectionManager poolingAsyncClientConnectionManager = connManagerBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)poolingAsyncClientConnectionManager, (String)"build(...)");
            return (AsyncClientConnectionManager)poolingAsyncClientConnectionManager;
        }

        private final CloseableHttpAsyncClient createAsyncHttpClient(HttpClientConfig config) {
            IOReactorConfig iOReactorConfig = IOReactorConfig.custom().setSoTimeout(config.getDefaultTimeout()).setSoKeepAlive(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)iOReactorConfig, (String)"build(...)");
            IOReactorConfig ioReactorConfig = iOReactorConfig;
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setConnectionManager(this.createConnectionManager(config)).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new MaxIdleKeepAliveStrategy(config.getMaxKeepAlive()));
            HttpHost httpHost = config.getProxyHost();
            if (httpHost != null) {
                HttpHost httpHost2 = httpHost;
                boolean bl = false;
                builder.setProxy(httpHost2);
                Credentials credentials = config.getProxyCredentials();
                if (credentials != null) {
                    Credentials creds = credentials;
                    boolean bl2 = false;
                    AuthScope authScope = new AuthScope(httpHost2);
                    CredentialsProvider credsProvider = CredentialsProviderBuilder.create().add(authScope, creds).build();
                    builder.setDefaultCredentialsProvider(credsProvider);
                }
            }
            CloseableHttpAsyncClient closeableHttpAsyncClient = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpAsyncClient, (String)"build(...)");
            return closeableHttpAsyncClient;
        }

        public final void acceptJson(@NotNull SimpleRequestBuilder $this$acceptJson) {
            Intrinsics.checkNotNullParameter((Object)$this$acceptJson, (String)"<this>");
            $this$acceptJson.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        }

        @NotNull
        public final SimpleHttpResponse validateResponse(@NotNull SimpleHttpResponse $this$validateResponse, @Nullable SimpleHttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)$this$validateResponse, (String)"<this>");
            if (!this.isSuccess((HttpResponse)$this$validateResponse)) {
                throw new ResponseStatusException((HttpResponse)$this$validateResponse, request);
            }
            return $this$validateResponse;
        }

        public static /* synthetic */ SimpleHttpResponse validateResponse$default(Companion companion, SimpleHttpResponse simpleHttpResponse, SimpleHttpRequest simpleHttpRequest, int n, Object object) {
            if ((n & 1) != 0) {
                simpleHttpRequest = null;
            }
            return companion.validateResponse(simpleHttpResponse, simpleHttpRequest);
        }

        @NotNull
        public final Message<HttpResponse, InputStream> validateResponse(@NotNull Message<HttpResponse, InputStream> $this$validateResponse, @Nullable SimpleHttpRequest request) {
            Intrinsics.checkNotNullParameter($this$validateResponse, (String)"<this>");
            MessageHeaders messageHeaders = $this$validateResponse.getHead();
            Intrinsics.checkNotNullExpressionValue((Object)messageHeaders, (String)"getHead(...)");
            if (!this.isSuccess((HttpResponse)messageHeaders)) {
                MessageHeaders messageHeaders2 = $this$validateResponse.getHead();
                Intrinsics.checkNotNullExpressionValue((Object)messageHeaders2, (String)"getHead(...)");
                throw new ResponseStatusException((HttpResponse)messageHeaders2, request);
            }
            return $this$validateResponse;
        }

        public static /* synthetic */ Message validateResponse$default(Companion companion, Message message, SimpleHttpRequest simpleHttpRequest, int n, Object object) {
            if ((n & 1) != 0) {
                simpleHttpRequest = null;
            }
            return companion.validateResponse((Message<HttpResponse, InputStream>)message, simpleHttpRequest);
        }

        public final boolean isSuccess(@NotNull HttpResponse $this$isSuccess) {
            Intrinsics.checkNotNullParameter((Object)$this$isSuccess, (String)"<this>");
            return $this$isSuccess.getCode() < 400;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

